/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.FileUtils;
import oracle.pgx.config.AbstractFileGraphConfigBuilder;
import oracle.pgx.config.ExternalStoreConfig;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.FileGraphConfigBuilder;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.PartitionWhileLoading;
import oracle.pgx.config.TwoTablesDatastore;
import oracle.pgx.config.internal.ConfigUtils;
import org.apache.commons.vfs2.provider.UriParser;

public abstract class AbstractFileGraphConfig
extends GraphConfig {
    @Override
    public AbstractFileGraphConfigBuilder toGraphConfigBuilder() {
        return new FileGraphConfigBuilder().copyFrom((FileGraphConfig)this);
    }

    public String getUri() {
        if (this.getUris().size() == 1) {
            return this.getUris().get(0);
        }
        throw new UnsupportedOperationException("CANNOT_GET_SINGLE_URI_FROM_LIST");
    }

    public List<String> getUris() {
        return this.getVertexUris();
    }

    @Deprecated
    public abstract FileGraphStoringConfig getStoring();

    public FileGraphStoringConfig getStoringOptions() {
        return this.getStoring();
    }

    public abstract List<String> getVertexUris();

    public abstract List<String> getEdgeUris();

    public abstract String getSeparator();

    public abstract Boolean isDetectGzip();

    public abstract Boolean isHeader();

    public abstract Object getVertexIdColumn();

    public abstract Object getVertexLabelsColumn();

    public abstract Object getEdgeIdColumn();

    public abstract Object getEdgeSourceColumn();

    public abstract Object getEdgeDestinationColumn();

    public abstract Object getEdgeLabelColumn();

    @Override
    public abstract List<ExternalStoreConfig> getExternalStores();

    @Override
    public String getName() {
        String uri = this.getUris().get(0);
        if (uri.startsWith("jdbc:oracle:thin:")) {
            return this.getAttributes().getOrDefault("graph_name", "graph");
        }
        return FileUtils.getBaseName((String)uri);
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getFormat() == Format.TWO_TABLES && Objects.equals((Object)PartitionWhileLoading.BY_LABEL, (Object)this.getPartitionWhileLoading())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARTITIONING_WHILE_LOADING_NOT_SUPPORTED_BY_TWO_TABLES_NOT_RDBMS", (Object[])new Object[]{this.getFormat(), TwoTablesDatastore.FILE}));
        }
        this.validateIsFileFormat();
        this.validateHasSeparator();
        this.validateUriLists();
        this.validateVectorComponentDelimiter();
        if (this.getFormat() == Format.CSV) {
            this.validateColumns();
        } else {
            this.validateColumnsAreNull();
        }
    }

    protected List<String> getEdgeUrisWithScheme() {
        return AbstractFileGraphConfig.addSchemeIfNotPresent(this.getEdgeUris());
    }

    protected List<String> getVertexUrisWithScheme() {
        return AbstractFileGraphConfig.addSchemeIfNotPresent(this.getVertexUris());
    }

    private void validateIsFileFormat() {
        if (!this.isFileFormat()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_FILE_FORMAT", (Object[])new Object[]{this.getFormat()}));
        }
    }

    private boolean formatRequiresSeparator() {
        return this.getFormat() != Format.PGB && this.getFormat() != Format.GRAPHML && this.getFormat() != Format.CSV;
    }

    private void validateHasSeparator() {
        if (this.formatRequiresSeparator() && this.getSeparator() != null && this.getSeparator().isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{FileGraphConfig.Field.SEPARATOR.toKey()}));
        }
    }

    private void validateUriLists() {
        if (this.isEmptyList(this.getVertexUris())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{FileGraphConfig.Field.VERTEX_URIS.toKey()}));
        }
        if (this.hasVerticesAndEdgesSeparatedFileFormat() && this.isEmptyList(this.getEdgeUris())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{FileGraphConfig.Field.EDGE_URIS.toKey()}));
        }
    }

    private void validateVectorComponentDelimiter() {
        String separator = this.getSeparator();
        if (separator == null) {
            separator = this.getFormat() == Format.CSV ? "," : "\t ";
        }
        ConfigUtils.validateVectorComponentDelimiter(this.formatRequiresSeparator(), separator, this.getVectorComponentDelimiter());
    }

    private boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private void validateColumns() {
        this.validateColumn(this.getVertexIdColumn(), "vertex id");
        if (this.isVertexLabelsLoadingEnabled()) {
            this.validateColumn(this.getVertexLabelsColumn(), "vertex labels");
        }
        if (this.isLoadEdgeKeys()) {
            this.validateColumn(this.getEdgeIdColumn(), "edge id");
        }
        this.validateColumn(this.getEdgeSourceColumn(), "edge source");
        this.validateColumn(this.getEdgeDestinationColumn(), "edge destination");
        if (this.isEdgeLabelLoadingEnabled()) {
            this.validateColumn(this.getEdgeLabelColumn(), "edge label");
        }
        this.validateProperties(this.getVertexProps());
        this.validateProperties(this.getEdgeProps());
        if (!this.isHeader().booleanValue()) {
            this.validateNoneOrAllColumnIndices();
        }
    }

    private void validateProperties(List<GraphPropertyConfig> props) {
        for (GraphPropertyConfig prop : props) {
            if (prop.getColumn() == null) continue;
            this.validateColumn(prop.getColumn(), "property \"" + prop.getName() + "\"");
        }
    }

    private void validateColumn(Object column, String errorMsg) {
        if (column == null && this.isHeader().booleanValue()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_UNSPECIFIED_COLUMN", (Object[])new Object[]{errorMsg, "graph configuration"}));
        }
        if (!this.isHeader().booleanValue() && column != null) {
            try {
                int columnIndex = Integer.parseInt(column.toString());
                if (columnIndex < 1) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_INVALID_COLUMN_INDEX", (Object[])new Object[]{columnIndex}));
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_COLUMN_NAME_WITHOUT_HEADER", (Object[])new Object[]{errorMsg, "graph"}), e);
            }
        }
    }

    private void validateNoneOrAllColumnIndices() {
        boolean firstColumnIsPresent;
        boolean bl = firstColumnIsPresent = this.getVertexIdColumn() != null;
        if (this.isVertexLabelsLoadingEnabled() && this.getVertexLabelsColumn() != null != firstColumnIsPresent || this.isLoadEdgeKeys() && this.getEdgeIdColumn() != null != firstColumnIsPresent || this.getEdgeSourceColumn() != null != firstColumnIsPresent || this.getEdgeDestinationColumn() != null != firstColumnIsPresent || this.isEdgeLabelLoadingEnabled() && this.getEdgeLabelColumn() != null != firstColumnIsPresent || this.getVertexProps().stream().anyMatch(prop -> prop.getColumn() != null != firstColumnIsPresent) || this.getEdgeProps().stream().anyMatch(prop -> prop.getColumn() != null != firstColumnIsPresent)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CSV_PARTIAL_COLUMN_INDICES", (Object[])new Object[]{"graph"}));
        }
    }

    private void validateColumnsAreNull() {
        this.checkColumnIsNull(this.getVertexIdColumn(), "vertex id");
        this.checkColumnIsNull(this.getVertexLabelsColumn(), "vertex labels");
        this.checkColumnIsNull(this.getEdgeIdColumn(), "edge id");
        this.checkColumnIsNull(this.getEdgeSourceColumn(), "edge source");
        this.checkColumnIsNull(this.getEdgeDestinationColumn(), "edge destination");
        this.checkColumnIsNull(this.getEdgeLabelColumn(), "edge label");
        for (GraphPropertyConfig prop : this.getVertexProps()) {
            this.checkColumnIsNull(prop.getColumn(), "property \"" + prop.getName() + "\"");
        }
        for (GraphPropertyConfig prop : this.getEdgeProps()) {
            this.checkColumnIsNull(prop.getColumn(), "property \"" + prop.getName() + "\"");
        }
    }

    private void checkColumnIsNull(Object column, String errorMsg) {
        if (column != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"COLUMNS_NOT_SUPPORTED_FOR_FORMAT", (Object[])new Object[]{errorMsg, this.getName()}));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileGraphConfig that = (AbstractFileGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.isHeader(), that.isHeader())) {
            return false;
        }
        if (!Objects.equals(this.getSeparator(), that.getSeparator())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), that.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.getStoring(), that.getStoring())) {
            return false;
        }
        if (!Objects.equals(this.isDetectGzip(), that.isDetectGzip())) {
            return false;
        }
        if (!Objects.equals(AbstractFileGraphConfig.addSchemeIfNotPresent(this.getVertexUris()), AbstractFileGraphConfig.addSchemeIfNotPresent(that.getVertexUris()))) {
            return false;
        }
        if (!Objects.equals(AbstractFileGraphConfig.addSchemeIfNotPresent(this.getEdgeUris()), AbstractFileGraphConfig.addSchemeIfNotPresent(that.getEdgeUris()))) {
            return false;
        }
        if (!Objects.equals(this.getVertexIdColumn(), that.getVertexIdColumn())) {
            return false;
        }
        if (!Objects.equals(this.getVertexLabelsColumn(), that.getVertexLabelsColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeIdColumn(), that.getEdgeIdColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeLabelColumn(), that.getEdgeLabelColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeSourceColumn(), that.getEdgeSourceColumn())) {
            return false;
        }
        return Objects.equals(this.getEdgeDestinationColumn(), that.getEdgeDestinationColumn());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code += this.isHeader().hashCode();
        code += this.getSeparator() == null ? 0 : this.getSeparator().hashCode();
        code += this.getAttributes().hashCode();
        code += this.getStoring().hashCode();
        code += this.isDetectGzip().hashCode();
        code += AbstractFileGraphConfig.addSchemeIfNotPresent(this.getVertexUris()).hashCode();
        code += AbstractFileGraphConfig.addSchemeIfNotPresent(this.getEdgeUris()).hashCode();
        code += this.getVertexIdColumn() == null ? 0 : this.getVertexIdColumn().hashCode();
        code += this.getVertexLabelsColumn() == null ? 0 : this.getVertexLabelsColumn().hashCode();
        code += this.getEdgeIdColumn() == null ? 0 : this.getEdgeIdColumn().hashCode();
        code += this.getEdgeLabelColumn() == null ? 0 : this.getEdgeLabelColumn().hashCode();
        code += this.getEdgeSourceColumn() == null ? 0 : this.getEdgeSourceColumn().hashCode();
        return code += this.getEdgeDestinationColumn() == null ? 0 : this.getEdgeDestinationColumn().hashCode();
    }

    protected static List<String> addSchemeIfNotPresent(List<String> uriList) {
        ArrayList<String> list = new ArrayList<String>(uriList.size());
        for (String uri : uriList) {
            list.add(AbstractFileGraphConfig.addSchemeIfNotPresent(uri));
        }
        return list;
    }

    protected static String addSchemeIfNotPresent(String uri) {
        return UriParser.extractScheme((String)uri) == null ? "file://" + uri : uri;
    }
}

