/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.AbstractPgGraphConfig;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.Format;
import oracle.pgx.config.PgRdbmsGraphConfig;

public abstract class AbstractPgGraphConfigBuilder<T extends AbstractPgGraphConfigBuilder<T, GC>, GC extends AbstractPgGraphConfig>
extends AbstractGraphConfigBuilder<T, GC> {
    @Override
    public T copyFrom(GC graphConfig) {
        super.copyFrom(graphConfig);
        this.setDbEngine(((AbstractPgGraphConfig)graphConfig).getDbEngine());
        this.setName(graphConfig.getName());
        this.setMaxNumConnections(((AbstractPgGraphConfig)graphConfig).getMaxNumConnections());
        return (T)((AbstractPgGraphConfigBuilder)this.getThis());
    }

    public AbstractPgGraphConfigBuilder() {
        this.values.put(PgRdbmsGraphConfig.Field.FORMAT.toKey(), Format.PG.toString());
        this.setVertexIdType(IdType.LONG);
    }

    @Override
    public T setVertexIdType(IdType vertexIdType) {
        if (vertexIdType != IdType.LONG) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_NODE_KEY_TYPE", (Object[])new Object[]{vertexIdType}));
        }
        return (T)((AbstractPgGraphConfigBuilder)this.getThis());
    }

    protected final T setDbEngine(DbEngine engine) {
        this.values.put(PgRdbmsGraphConfig.Field.DB_ENGINE.toKey(), engine.toString());
        return (T)((AbstractPgGraphConfigBuilder)this.getThis());
    }

    public T setName(String name) {
        this.values.put(PgRdbmsGraphConfig.Field.NAME.toKey(), name);
        return (T)((AbstractPgGraphConfigBuilder)this.getThis());
    }

    public T setMaxNumConnections(int c) {
        this.values.put(PgRdbmsGraphConfig.Field.MAX_NUM_CONNECTIONS.toKey(), c);
        return (T)((AbstractPgGraphConfigBuilder)this.getThis());
    }
}

