/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AnalysisTaskConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class EnterpriseSchedulerConfig
extends AbstractConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static EnterpriseSchedulerConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return EnterpriseSchedulerConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static EnterpriseSchedulerConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return EnterpriseSchedulerConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static EnterpriseSchedulerConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new EnterpriseSchedulerConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static EnterpriseSchedulerConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new EnterpriseSchedulerConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static EnterpriseSchedulerConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new EnterpriseSchedulerConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected EnterpriseSchedulerConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public Integer getNumIoThreadsPerTask() {
        return (Integer)this.values.get(Field.NUM_IO_THREADS_PER_TASK);
    }

    public Integer getMaxNumConcurrentIoTasks() {
        return (Integer)this.values.get(Field.MAX_NUM_CONCURRENT_IO_TASKS);
    }

    public AnalysisTaskConfig getAnalysisTaskConfig() {
        return (AnalysisTaskConfig)this.values.get(Field.ANALYSIS_TASK_CONFIG);
    }

    public AnalysisTaskConfig getFastAnalysisTaskConfig() {
        return (AnalysisTaskConfig)this.values.get(Field.FAST_ANALYSIS_TASK_CONFIG);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnterpriseSchedulerConfig other = (EnterpriseSchedulerConfig)obj;
        if (!Objects.equals(this.getNumIoThreadsPerTask(), other.getNumIoThreadsPerTask())) {
            return false;
        }
        if (!Objects.equals(this.getMaxNumConcurrentIoTasks(), other.getMaxNumConcurrentIoTasks())) {
            return false;
        }
        if (!Objects.equals(this.getAnalysisTaskConfig(), other.getAnalysisTaskConfig())) {
            return false;
        }
        return Objects.equals(this.getFastAnalysisTaskConfig(), other.getFastAnalysisTaskConfig());
    }

    public static enum Field implements ConfigField
    {
        NUM_IO_THREADS_PER_TASK(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<no-of-CPUs>", false, false, false, false),
        MAX_NUM_CONCURRENT_IO_TASKS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 3, false, false, false, false),
        ANALYSIS_TASK_CONFIG(Collections.emptyList(), Collections.emptyList(), AnalysisTaskConfig.class, false, AbstractConfig.constructMap("weight", "<no-of-CPUs>", "priority", "medium", "max_threads", "<no-of-CPUs>"), false, false, false, false),
        FAST_ANALYSIS_TASK_CONFIG(Collections.emptyList(), Collections.emptyList(), AnalysisTaskConfig.class, false, AbstractConfig.constructMap("weight", 1, "priority", "high", "max_threads", "<no-of-CPUs>"), false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("enterprise.scheduler.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

