/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractEntityProviderConfigFactory;
import oracle.pgx.config.EsEntityProviderConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.ProviderLoadingConfig;

public class EsEntityProviderConfigFactory
extends AbstractEntityProviderConfigFactory<EsEntityProviderConfig> {
    private final boolean strict;

    public EsEntityProviderConfigFactory(boolean strict) {
        this.strict = strict;
    }

    EsEntityProviderConfigFactory(boolean strict, boolean parseHiddenValues) {
        super(parseHiddenValues);
        this.strict = strict;
    }

    @Override
    protected final boolean supports(ProviderFormat type) {
        return type == ProviderFormat.ES;
    }

    @Override
    protected EsEntityProviderConfig fromMap(Map<String, Object> raw, String parent) throws IOException {
        this.addDefaultIdTypeIfMissing(raw);
        this.addDefaultCreateIndexMappingIfMissing(raw);
        return EsEntityProviderConfig.parse(raw, this.strict, parent, this.parseHiddenValues);
    }

    @Override
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        Function<String, Object> valGetter = raw::get;
        if (!this.hasValue(EsEntityProviderConfig.Field.KEY_TYPE, valGetter)) {
            boolean isEdgeTable = this.hasValue(EsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(EsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
            IdType defaultKeyType = isEdgeTable ? IdType.LONG : IdType.INTEGER;
            raw.put(EsEntityProviderConfig.Field.KEY_TYPE.toKey(), defaultKeyType);
        }
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        boolean createIndexMapping;
        Function<String, Object> valGetter = raw::get;
        boolean isEdgeTable = this.hasValue(EsEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER, valGetter) && this.hasValue(EsEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER, valGetter);
        boolean bl = createIndexMapping = !isEdgeTable;
        if (!this.hasValue(EsEntityProviderConfig.Field.LOADING, valGetter)) {
            raw.put(EsEntityProviderConfig.Field.LOADING.toKey(), new LinkedHashMap());
        }
        Object loadingSectionObject = valGetter.apply(EsEntityProviderConfig.Field.LOADING.toKey());
        Map loadingSection = (Map)loadingSectionObject;
        loadingSection.putIfAbsent(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), createIndexMapping);
    }
}

