/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.AbstractPgGraphConfigBuilder;
import oracle.pgx.config.DbEngine;
import oracle.pgx.config.PgHbaseGraphConfig;
import oracle.pgx.config.PgHbaseGraphConfigFactory;

public class PgHbaseGraphConfigBuilder
extends AbstractPgGraphConfigBuilder<PgHbaseGraphConfigBuilder, PgHbaseGraphConfig> {
    public PgHbaseGraphConfigBuilder() {
        this.setDbEngine(DbEngine.HBASE);
    }

    @Override
    protected AbstractGraphConfigFactory<PgHbaseGraphConfig> getFactory() {
        return new PgHbaseGraphConfigFactory(true, true);
    }

    @Override
    public PgHbaseGraphConfigBuilder copyFrom(PgHbaseGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setZkQuorum(graphConfig.getZkQuorum());
        this.setZkClientPort(graphConfig.getZkClientPort());
        this.setZkSessionTimeout(graphConfig.getZkSessionTimeout());
        this.setZkNodeParent(graphConfig.getZkNodeParent());
        this.setInitialVertexNumRegions(graphConfig.getInitialVertexNumRegions());
        this.setInitialEdgeNumRegions(graphConfig.getInitialEdgeNumRegions());
        this.setBlockCacheSize(graphConfig.getBlockCacheSize());
        this.setSplitsPerRegion(graphConfig.getSplitsPerRegion());
        this.setHbaseSecAuth(graphConfig.getHbaseSecAuth());
        this.setHadoopSecAuth(graphConfig.getHadoopSecAuth());
        this.setHmKerberosPrincipal(graphConfig.getHmKerberosPrincipal());
        this.setRsKerberosPrincipal(graphConfig.getRsKerberosPrincipal());
        this.setUserPrincipal(graphConfig.getUserPrincipal());
        this.setKeytab(graphConfig.getKeytab());
        this.setCompression(graphConfig.getCompression());
        this.setDataBlockEncoding(graphConfig.getDataBlockEncoding());
        return (PgHbaseGraphConfigBuilder)this.getThis();
    }

    public PgHbaseGraphConfigBuilder setZkQuorum(String quorum) {
        this.values.put(PgHbaseGraphConfig.Field.ZK_QUORUM.toKey(), quorum);
        return this;
    }

    public PgHbaseGraphConfigBuilder setZkClientPort(int port) {
        this.values.put(PgHbaseGraphConfig.Field.ZK_CLIENT_PORT.toKey(), port);
        return this;
    }

    public PgHbaseGraphConfigBuilder setZkSessionTimeout(int to) {
        this.values.put(PgHbaseGraphConfig.Field.ZK_SESSION_TIMEOUT.toKey(), to);
        return this;
    }

    public PgHbaseGraphConfigBuilder setZkNodeParent(String nodeParent) {
        this.values.put(PgHbaseGraphConfig.Field.ZK_NODE_PARENT.toKey(), nodeParent);
        return this;
    }

    public PgHbaseGraphConfigBuilder setInitialVertexNumRegions(int inr) {
        this.values.put(PgHbaseGraphConfig.Field.INITIAL_VERTEX_NUM_REGIONS.toKey(), inr);
        return this;
    }

    public PgHbaseGraphConfigBuilder setInitialEdgeNumRegions(int inr) {
        this.values.put(PgHbaseGraphConfig.Field.INITIAL_EDGE_NUM_REGIONS.toKey(), inr);
        return this;
    }

    public PgHbaseGraphConfigBuilder setBlockCacheSize(int bcs) {
        this.values.put(PgHbaseGraphConfig.Field.BLOCK_CACHE_SIZE.toKey(), bcs);
        return this;
    }

    public PgHbaseGraphConfigBuilder setSplitsPerRegion(int spr) {
        this.values.put(PgHbaseGraphConfig.Field.SPLITS_PER_REGION.toKey(), spr);
        return this;
    }

    public PgHbaseGraphConfigBuilder setHbaseSecAuth(String s) {
        this.values.put(PgHbaseGraphConfig.Field.HBASE_SEC_AUTH.toKey(), s);
        return this;
    }

    public PgHbaseGraphConfigBuilder setHadoopSecAuth(String s) {
        this.values.put(PgHbaseGraphConfig.Field.HADOOP_SEC_AUTH.toKey(), s);
        return this;
    }

    public PgHbaseGraphConfigBuilder setHmKerberosPrincipal(String s) {
        this.values.put(PgHbaseGraphConfig.Field.HM_KERBEROS_PRINCIPAL.toKey(), s);
        return this;
    }

    public PgHbaseGraphConfigBuilder setRsKerberosPrincipal(String s) {
        this.values.put(PgHbaseGraphConfig.Field.RS_KERBEROS_PRINCIPAL.toKey(), s);
        return this;
    }

    public PgHbaseGraphConfigBuilder setUserPrincipal(String s) {
        this.values.put(PgHbaseGraphConfig.Field.USER_PRINCIPAL.toKey(), s);
        return this;
    }

    public PgHbaseGraphConfigBuilder setKeytab(String s) {
        this.values.put(PgHbaseGraphConfig.Field.KEYTAB.toKey(), s);
        return this;
    }

    public PgHbaseGraphConfigBuilder setCompression(String compression) {
        this.values.put(PgHbaseGraphConfig.Field.COMPRESSION.toKey(), compression);
        return this;
    }

    public PgHbaseGraphConfigBuilder setDataBlockEncoding(String enc) {
        this.values.put(PgHbaseGraphConfig.Field.DATA_BLOCK_ENCODING.toKey(), enc);
        return this;
    }
}

