/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractPgxConfig;
import oracle.pgx.config.AuthorizationEntityConfig;
import oracle.pgx.config.AuthorizationLocationConfig;
import oracle.pgx.config.BasicSchedulerConfig;
import oracle.pgx.config.Compiler;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.DataMemoryLimitsConfig;
import oracle.pgx.config.EnterpriseSchedulerConfig;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfig;
import oracle.pgx.config.FrontierTypeStrategy;
import oracle.pgx.config.GraphSharingOption;
import oracle.pgx.config.GraphValidationLevel;
import oracle.pgx.config.MemoryAllocationStrategy;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PreloadGraphConfig;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.RandomGeneratorStrategy;
import oracle.pgx.config.ReachabilityIndexCreationMode;
import oracle.pgx.config.RealmConfig;
import oracle.pgx.config.SchedulerStrategy;
import oracle.pgx.config.StringPoolingStrategy;
import oracle.pgx.config.UpdateConsistencyModel;

public class PgxConfig
extends AbstractPgxConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static PgxConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return PgxConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static PgxConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return PgxConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static PgxConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new PgxConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static PgxConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new PgxConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static PgxConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new PgxConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected PgxConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    @Override
    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public Boolean isEnableGraphLoadingCache() {
        return (Boolean)this.values.get(Field.ENABLE_GRAPH_LOADING_CACHE);
    }

    public BasicSchedulerConfig getBasicSchedulerConfig() {
        return (BasicSchedulerConfig)this.values.get(Field.BASIC_SCHEDULER_CONFIG);
    }

    public EnterpriseSchedulerConfig getEnterpriseSchedulerConfig() {
        return (EnterpriseSchedulerConfig)this.values.get(Field.ENTERPRISE_SCHEDULER_CONFIG);
    }

    public Integer getMinFetchIntervalSec() {
        return (Integer)this.values.get(Field.MIN_FETCH_INTERVAL_SEC);
    }

    public Integer getMinUpdateIntervalSec() {
        return (Integer)this.values.get(Field.MIN_UPDATE_INTERVAL_SEC);
    }

    public UpdateConsistencyModel getInPlaceUpdateConsistencyModel() {
        return (UpdateConsistencyModel)((Object)this.values.get(Field.IN_PLACE_UPDATE_CONSISTENCY_MODEL));
    }

    public Double getMinArrayCompactionThreshold() {
        return (Double)this.values.get(Field.MIN_ARRAY_COMPACTION_THRESHOLD);
    }

    public Integer getMaxSnapshotCount() {
        return (Integer)this.values.get(Field.MAX_SNAPSHOT_COUNT);
    }

    public String getJavaHomeDir() {
        return (String)this.values.get(Field.JAVA_HOME_DIR);
    }

    public Boolean isEnableGmCompiler() {
        return (Boolean)this.values.get(Field.ENABLE_GM_COMPILER);
    }

    public Compiler getGraphAlgorithmLanguage() {
        return (Compiler)((Object)this.values.get(Field.GRAPH_ALGORITHM_LANGUAGE));
    }

    public Boolean isUnsafeAllowForeignSyntax() {
        return (Boolean)this.values.get(Field.UNSAFE_ALLOW_FOREIGN_SYNTAX);
    }

    public Boolean isAllowUserAutoRefresh() {
        return (Boolean)this.values.get(Field.ALLOW_USER_AUTO_REFRESH);
    }

    public Boolean isIgnoreIncompatibleBackendOperations() {
        return (Boolean)this.values.get(Field.IGNORE_INCOMPATIBLE_BACKEND_OPERATIONS);
    }

    public Boolean isAllowOverrideSchedulingInformation() {
        return (Boolean)this.values.get(Field.ALLOW_OVERRIDE_SCHEDULING_INFORMATION);
    }

    @Override
    public String getUdfConfigDirectory() {
        return (String)this.values.get(Field.UDF_CONFIG_DIRECTORY);
    }

    public List<String> getHostnames() {
        return (List)this.values.get(Field.HOSTNAMES);
    }

    public List<String> getExistingHostnames() {
        return (List)this.values.get(Field.EXISTING_HOSTNAMES);
    }

    public String getExecutablePath() {
        return (String)this.values.get(Field.EXECUTABLE_PATH);
    }

    public String getBuiltinsPath() {
        return (String)this.values.get(Field.BUILTINS_PATH);
    }

    public String getLogConfigure() {
        return (String)this.values.get(Field.LOG_CONFIGURE);
    }

    public String getCommonLogConfigure() {
        return (String)this.values.get(Field.COMMON_LOG_CONFIGURE);
    }

    public String getLogStdRedirect() {
        return (String)this.values.get(Field.LOG_STD_REDIRECT);
    }

    public Integer getMaximumCommandBuffersPostedPerRemote() {
        return (Integer)this.values.get(Field.MAXIMUM_COMMAND_BUFFERS_POSTED_PER_REMOTE);
    }

    public Integer getMaximumReceivedMessagesBuffer() {
        return (Integer)this.values.get(Field.MAXIMUM_RECEIVED_MESSAGES_BUFFER);
    }

    public Integer getMaximumSendBuffersInFlight() {
        return (Integer)this.values.get(Field.MAXIMUM_SEND_BUFFERS_IN_FLIGHT);
    }

    public Integer getMaximumSharedBuffersPosted() {
        return (Integer)this.values.get(Field.MAXIMUM_SHARED_BUFFERS_POSTED);
    }

    public Integer getNetworkCredits() {
        return (Integer)this.values.get(Field.NETWORK_CREDITS);
    }

    public Integer getNewFollowerConnectionTimeoutSecs() {
        return (Integer)this.values.get(Field.NEW_FOLLOWER_CONNECTION_TIMEOUT_SECS);
    }

    public Integer getPgqlMaximumNumBuffers() {
        return (Integer)this.values.get(Field.PGQL_MAXIMUM_NUM_BUFFERS);
    }

    public Integer getOnHoldJobTimeoutSecs() {
        return (Integer)this.values.get(Field.ON_HOLD_JOB_TIMEOUT_SECS);
    }

    public Integer getEngineConnectionTimeoutSecs() {
        return (Integer)this.values.get(Field.ENGINE_CONNECTION_TIMEOUT_SECS);
    }

    public String getMaximumAttainableMemory() {
        return (String)this.values.get(Field.MAXIMUM_ATTAINABLE_MEMORY);
    }

    public Integer getLivenessCheckDelaySecs() {
        return (Integer)this.values.get(Field.LIVENESS_CHECK_DELAY_SECS);
    }

    public Integer getLivenessCheckTimeoutSecs() {
        return (Integer)this.values.get(Field.LIVENESS_CHECK_TIMEOUT_SECS);
    }

    public Integer getSystemIdleDelayBeforeIdlingMsecs() {
        return (Integer)this.values.get(Field.SYSTEM_IDLE_DELAY_BEFORE_IDLING_MSECS);
    }

    public Integer getSystemIdleSleepIncrementMsecs() {
        return (Integer)this.values.get(Field.SYSTEM_IDLE_SLEEP_INCREMENT_MSECS);
    }

    public Integer getSystemIdleSleepIncrementIntervalMsecs() {
        return (Integer)this.values.get(Field.SYSTEM_IDLE_SLEEP_INCREMENT_INTERVAL_MSECS);
    }

    public Integer getSystemIdleSleepMaxMsecs() {
        return (Integer)this.values.get(Field.SYSTEM_IDLE_SLEEP_MAX_MSECS);
    }

    public String getJavaClassPath() {
        return (String)this.values.get(Field.JAVA_CLASS_PATH);
    }

    public Boolean useInfiniband() {
        return (Boolean)this.values.get(Field.USE_INFINIBAND);
    }

    public String getIfInfiniband() {
        return (String)this.values.get(Field.IF_INFINIBAND);
    }

    public String getIfEthernet() {
        return (String)this.values.get(Field.IF_ETHERNET);
    }

    public Integer getLargeBufCount() {
        return (Integer)this.values.get(Field.LARGE_BUF_COUNT);
    }

    public Integer getLargeBufSizeKb() {
        return (Integer)this.values.get(Field.LARGE_BUF_SIZE_KB);
    }

    public Boolean isPartitioningShuffleVertices() {
        return (Boolean)this.values.get(Field.PARTITIONING_SHUFFLE_VERTICES);
    }

    public String getPartitioningStrategy() {
        return (String)this.values.get(Field.PARTITIONING_STRATEGY);
    }

    public Integer getProcId() {
        return (Integer)this.values.get(Field.PROC_ID);
    }

    public Integer getResourceMonitor() {
        return (Integer)this.values.get(Field.RESOURCE_MONITOR);
    }

    public String getDebugServer() {
        return (String)this.values.get(Field.DEBUG_SERVER);
    }

    public String getInstanceName() {
        return (String)this.values.get(Field.INSTANCE_NAME);
    }

    public Boolean isEnableEngineTls() {
        return (Boolean)this.values.get(Field.ENABLE_ENGINE_TLS);
    }

    public String getEngineTlsKeystore() {
        return (String)this.values.get(Field.ENGINE_TLS_KEYSTORE);
    }

    public String getEngineTlsTruststore() {
        return (String)this.values.get(Field.ENGINE_TLS_TRUSTSTORE);
    }

    public String getEngineTlsCipher() {
        return (String)this.values.get(Field.ENGINE_TLS_CIPHER);
    }

    public Boolean isEngineTlsVerifyHostname() {
        return (Boolean)this.values.get(Field.ENGINE_TLS_VERIFY_HOSTNAME);
    }

    public String getEngineTlsExpectedDn() {
        return (String)this.values.get(Field.ENGINE_TLS_EXPECTED_DN);
    }

    public String getBackendWrapper() {
        return (String)this.values.get(Field.BACKEND_WRAPPER);
    }

    public Integer getHandshakePort() {
        return (Integer)this.values.get(Field.HANDSHAKE_PORT);
    }

    @Override
    public Boolean isEnableCsrfTokenChecks() {
        return (Boolean)this.values.get(Field.ENABLE_CSRF_TOKEN_CHECKS);
    }

    @Override
    public String getTmpDir() {
        return (String)this.values.get(Field.TMP_DIR);
    }

    @Override
    public List<String> getAllowedRemoteLoadingLocations() {
        return (List)this.values.get(Field.ALLOWED_REMOTE_LOADING_LOCATIONS);
    }

    public Boolean isInitPgqlOnStartup() {
        return (Boolean)this.values.get(Field.INIT_PGQL_ON_STARTUP);
    }

    @Override
    public Long getMaxHttpClientRequestSize() {
        return (Long)this.values.get(Field.MAX_HTTP_CLIENT_REQUEST_SIZE);
    }

    public RealmConfig getPgxRealm() {
        return (RealmConfig)this.values.get(Field.PGX_REALM);
    }

    @Override
    public List<AuthorizationLocationConfig> getFileLocations() {
        return (List)this.values.get(Field.FILE_LOCATIONS);
    }

    public Boolean isAuthorizationSessionCreateAllowAll() {
        return (Boolean)this.values.get(Field.AUTHORIZATION_SESSION_CREATE_ALLOW_ALL);
    }

    @Override
    public List<AuthorizationEntityConfig> getAuthorization() {
        return (List)this.values.get(Field.AUTHORIZATION);
    }

    public Boolean isEnableMemoryLimitsChecks() {
        return (Boolean)this.values.get(Field.ENABLE_MEMORY_LIMITS_CHECKS);
    }

    @Override
    public DataMemoryLimitsConfig getDataMemoryLimits() {
        return (DataMemoryLimitsConfig)this.values.get(Field.DATA_MEMORY_LIMITS);
    }

    public Boolean isEnableShutdownCleanupHook() {
        return (Boolean)this.values.get(Field.ENABLE_SHUTDOWN_CLEANUP_HOOK);
    }

    public Integer getSessionIdleTimeoutSecs() {
        return (Integer)this.values.get(Field.SESSION_IDLE_TIMEOUT_SECS);
    }

    public Integer getSessionTaskTimeoutSecs() {
        return (Integer)this.values.get(Field.SESSION_TASK_TIMEOUT_SECS);
    }

    public Boolean isAllowIdleTimeoutOverwrite() {
        return (Boolean)this.values.get(Field.ALLOW_IDLE_TIMEOUT_OVERWRITE);
    }

    public Boolean isAllowTaskTimeoutOverwrite() {
        return (Boolean)this.values.get(Field.ALLOW_TASK_TIMEOUT_OVERWRITE);
    }

    public Integer getMaxActiveSessions() {
        return (Integer)this.values.get(Field.MAX_ACTIVE_SESSIONS);
    }

    public Integer getMaxQueueSizePerSession() {
        return (Integer)this.values.get(Field.MAX_QUEUE_SIZE_PER_SESSION);
    }

    @Override
    public Integer getIntervalToPollMax() {
        return (Integer)this.values.get(Field.INTERVAL_TO_POLL_MAX);
    }

    @Override
    public Integer getAdminRequestCacheTimeout() {
        return (Integer)this.values.get(Field.ADMIN_REQUEST_CACHE_TIMEOUT);
    }

    public Boolean isLaunchWatchdogs() {
        return (Boolean)this.values.get(Field.LAUNCH_WATCHDOGS);
    }

    public Boolean isStrictMode() {
        return (Boolean)this.values.get(Field.STRICT_MODE);
    }

    @Override
    public List<PreloadGraphConfig> getPreloadGraphs() {
        return (List)this.values.get(Field.PRELOAD_GRAPHS);
    }

    public Integer getMemoryCleanupInterval() {
        return (Integer)this.values.get(Field.MEMORY_CLEANUP_INTERVAL);
    }

    public Double getReleaseMemoryThreshold() {
        return (Double)this.values.get(Field.RELEASE_MEMORY_THRESHOLD);
    }

    public Double getReadinessMemoryUsageRatio() {
        return (Double)this.values.get(Field.READINESS_MEMORY_USAGE_RATIO);
    }

    public Double getRunningMemoryUsageRatio() {
        return (Double)this.values.get(Field.RUNNING_MEMORY_USAGE_RATIO);
    }

    public String getPgxServerBaseUrl() {
        return (String)this.values.get(Field.PGX_SERVER_BASE_URL);
    }

    public Integer getPermissionChecksInterval() {
        return (Integer)this.values.get(Field.PERMISSION_CHECKS_INTERVAL);
    }

    public GraphSharingOption getGraphSharingOption() {
        return (GraphSharingOption)((Object)this.values.get(Field.GRAPH_SHARING_OPTION));
    }

    public Boolean isEnableSnapshotPropertiesPublishStatePropagation() {
        return (Boolean)this.values.get(Field.ENABLE_SNAPSHOT_PROPERTIES_PUBLISH_STATE_PROPAGATION);
    }

    public Integer getNumSpinLocks() {
        return (Integer)this.values.get(Field.NUM_SPIN_LOCKS);
    }

    public Boolean isExplicitSpinLocks() {
        return (Boolean)this.values.get(Field.EXPLICIT_SPIN_LOCKS);
    }

    public SchedulerStrategy getScheduler() {
        return (SchedulerStrategy)this.values.get(Field.SCHEDULER);
    }

    public Integer getTaskLength() {
        return (Integer)this.values.get(Field.TASK_LENGTH);
    }

    public Integer getSmallTaskLength() {
        return (Integer)this.values.get(Field.SMALL_TASK_LENGTH);
    }

    public FrontierTypeStrategy getMsBfsFrontierTypeStrategy() {
        return (FrontierTypeStrategy)((Object)this.values.get(Field.MS_BFS_FRONTIER_TYPE_STRATEGY));
    }

    public Integer getBfsThresholdSingleThreaded() {
        return (Integer)this.values.get(Field.BFS_THRESHOLD_SINGLE_THREADED);
    }

    public Integer getBfsThresholdReadBased() {
        return (Integer)this.values.get(Field.BFS_THRESHOLD_READ_BASED);
    }

    public Integer getBfsIterateQueTaskSize() {
        return (Integer)this.values.get(Field.BFS_ITERATE_QUE_TASK_SIZE);
    }

    public Double getBfsThresholdParentReadBased() {
        return (Double)this.values.get(Field.BFS_THRESHOLD_PARENT_READ_BASED);
    }

    public Integer getDfsThresholdLarge() {
        return (Integer)this.values.get(Field.DFS_THRESHOLD_LARGE);
    }

    public Integer getCniStopRecursionDefault() {
        return (Integer)this.values.get(Field.CNI_STOP_RECURSION_DEFAULT);
    }

    public Integer getCniSmallDefault() {
        return (Integer)this.values.get(Field.CNI_SMALL_DEFAULT);
    }

    public Integer getCniDiffFactorDefault() {
        return (Integer)this.values.get(Field.CNI_DIFF_FACTOR_DEFAULT);
    }

    public Integer getLargeArrayThreshold() {
        return (Integer)this.values.get(Field.LARGE_ARRAY_THRESHOLD);
    }

    public Integer getMaxOffHeapSize() {
        return (Integer)this.values.get(Field.MAX_OFF_HEAP_SIZE);
    }

    public String getCharacterSet() {
        return (String)this.values.get(Field.CHARACTER_SET);
    }

    public Integer getParallelism() {
        return (Integer)this.values.get(Field.PARALLELISM);
    }

    public RandomGeneratorStrategy getRandomGeneratorStrategy() {
        return (RandomGeneratorStrategy)((Object)this.values.get(Field.RANDOM_GENERATOR_STRATEGY));
    }

    public Long getRandomSeed() {
        return (Long)this.values.get(Field.RANDOM_SEED);
    }

    public Integer getPatternMatchingSupernodeCacheThreshold() {
        return (Integer)this.values.get(Field.PATTERN_MATCHING_SUPERNODE_CACHE_THRESHOLD);
    }

    public ReachabilityIndexCreationMode getUseIndexForReachabilityQueries() {
        return (ReachabilityIndexCreationMode)((Object)this.values.get(Field.USE_INDEX_FOR_REACHABILITY_QUERIES));
    }

    public Integer getRevisitThreshold() {
        return (Integer)this.values.get(Field.REVISIT_THRESHOLD);
    }

    public EnterpriseSchedulerFlagsConfig getEnterpriseSchedulerFlags() {
        return (EnterpriseSchedulerFlagsConfig)this.values.get(Field.ENTERPRISE_SCHEDULER_FLAGS);
    }

    public MemoryAllocationStrategy getMemoryAllocator() {
        return (MemoryAllocationStrategy)((Object)this.values.get(Field.MEMORY_ALLOCATOR));
    }

    public Integer getMaxDistinctStringsPerPool() {
        return (Integer)this.values.get(Field.MAX_DISTINCT_STRINGS_PER_POOL);
    }

    public StringPoolingStrategy getStringPoolingStrategy() {
        return (StringPoolingStrategy)((Object)this.values.get(Field.STRING_POOLING_STRATEGY));
    }

    public Boolean useMemoryMapperForStoringPgb() {
        return (Boolean)this.values.get(Field.USE_MEMORY_MAPPER_FOR_STORING_PGB);
    }

    public Boolean useMemoryMapperForReadingPgb() {
        return (Boolean)this.values.get(Field.USE_MEMORY_MAPPER_FOR_READING_PGB);
    }

    public Double getPoolingFactor() {
        return (Double)this.values.get(Field.POOLING_FACTOR);
    }

    public GraphValidationLevel getGraphValidationLevel() {
        return (GraphValidationLevel)((Object)this.values.get(Field.GRAPH_VALIDATION_LEVEL));
    }

    public List<Field> getBackendFields() {
        return Arrays.asList(Field.HOSTNAMES, Field.EXISTING_HOSTNAMES, Field.BUILTINS_PATH, Field.LOG_CONFIGURE, Field.COMMON_LOG_CONFIGURE, Field.LOG_STD_REDIRECT, Field.MAXIMUM_COMMAND_BUFFERS_POSTED_PER_REMOTE, Field.MAXIMUM_RECEIVED_MESSAGES_BUFFER, Field.MAXIMUM_SEND_BUFFERS_IN_FLIGHT, Field.MAXIMUM_SHARED_BUFFERS_POSTED, Field.NETWORK_CREDITS, Field.NEW_FOLLOWER_CONNECTION_TIMEOUT_SECS, Field.PGQL_MAXIMUM_NUM_BUFFERS, Field.ON_HOLD_JOB_TIMEOUT_SECS, Field.ENGINE_CONNECTION_TIMEOUT_SECS, Field.MAXIMUM_ATTAINABLE_MEMORY, Field.SYSTEM_IDLE_DELAY_BEFORE_IDLING_MSECS, Field.SYSTEM_IDLE_SLEEP_INCREMENT_MSECS, Field.SYSTEM_IDLE_SLEEP_INCREMENT_INTERVAL_MSECS, Field.SYSTEM_IDLE_SLEEP_MAX_MSECS, Field.JAVA_CLASS_PATH, Field.USE_INFINIBAND, Field.IF_INFINIBAND, Field.IF_ETHERNET, Field.LARGE_BUF_COUNT, Field.LARGE_BUF_SIZE_KB, Field.PARTITIONING_SHUFFLE_VERTICES, Field.PARTITIONING_STRATEGY, Field.PROC_ID, Field.RESOURCE_MONITOR, Field.DEBUG_SERVER, Field.INSTANCE_NAME, Field.ENABLE_ENGINE_TLS, Field.ENGINE_TLS_KEYSTORE, Field.ENGINE_TLS_TRUSTSTORE, Field.ENGINE_TLS_CIPHER, Field.ENGINE_TLS_VERIFY_HOSTNAME, Field.ENGINE_TLS_EXPECTED_DN, Field.HANDSHAKE_PORT, Field.TMP_DIR, Field.PGX_REALM, Field.ENABLE_MEMORY_LIMITS_CHECKS, Field.MEMORY_CLEANUP_INTERVAL, Field.RELEASE_MEMORY_THRESHOLD);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgxConfig other = (PgxConfig)obj;
        if (!Objects.equals(this.isEnableGraphLoadingCache(), other.isEnableGraphLoadingCache())) {
            return false;
        }
        if (!Objects.equals(this.getBasicSchedulerConfig(), other.getBasicSchedulerConfig())) {
            return false;
        }
        if (!Objects.equals(this.getEnterpriseSchedulerConfig(), other.getEnterpriseSchedulerConfig())) {
            return false;
        }
        if (!Objects.equals(this.getMinFetchIntervalSec(), other.getMinFetchIntervalSec())) {
            return false;
        }
        if (!Objects.equals(this.getMinUpdateIntervalSec(), other.getMinUpdateIntervalSec())) {
            return false;
        }
        if (!Objects.equals((Object)this.getInPlaceUpdateConsistencyModel(), (Object)other.getInPlaceUpdateConsistencyModel())) {
            return false;
        }
        if (!Objects.equals(this.getMinArrayCompactionThreshold(), other.getMinArrayCompactionThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getMaxSnapshotCount(), other.getMaxSnapshotCount())) {
            return false;
        }
        if (!Objects.equals(this.getJavaHomeDir(), other.getJavaHomeDir())) {
            return false;
        }
        if (!Objects.equals(this.isEnableGmCompiler(), other.isEnableGmCompiler())) {
            return false;
        }
        if (!Objects.equals((Object)this.getGraphAlgorithmLanguage(), (Object)other.getGraphAlgorithmLanguage())) {
            return false;
        }
        if (!Objects.equals(this.isUnsafeAllowForeignSyntax(), other.isUnsafeAllowForeignSyntax())) {
            return false;
        }
        if (!Objects.equals(this.isAllowUserAutoRefresh(), other.isAllowUserAutoRefresh())) {
            return false;
        }
        if (!Objects.equals(this.isIgnoreIncompatibleBackendOperations(), other.isIgnoreIncompatibleBackendOperations())) {
            return false;
        }
        if (!Objects.equals(this.isAllowOverrideSchedulingInformation(), other.isAllowOverrideSchedulingInformation())) {
            return false;
        }
        if (!Objects.equals(this.getUdfConfigDirectory(), other.getUdfConfigDirectory())) {
            return false;
        }
        if (!Objects.equals(this.getHostnames(), other.getHostnames())) {
            return false;
        }
        if (!Objects.equals(this.getExistingHostnames(), other.getExistingHostnames())) {
            return false;
        }
        if (!Objects.equals(this.getExecutablePath(), other.getExecutablePath())) {
            return false;
        }
        if (!Objects.equals(this.getBuiltinsPath(), other.getBuiltinsPath())) {
            return false;
        }
        if (!Objects.equals(this.getLogConfigure(), other.getLogConfigure())) {
            return false;
        }
        if (!Objects.equals(this.getCommonLogConfigure(), other.getCommonLogConfigure())) {
            return false;
        }
        if (!Objects.equals(this.getLogStdRedirect(), other.getLogStdRedirect())) {
            return false;
        }
        if (!Objects.equals(this.getMaximumCommandBuffersPostedPerRemote(), other.getMaximumCommandBuffersPostedPerRemote())) {
            return false;
        }
        if (!Objects.equals(this.getMaximumReceivedMessagesBuffer(), other.getMaximumReceivedMessagesBuffer())) {
            return false;
        }
        if (!Objects.equals(this.getMaximumSendBuffersInFlight(), other.getMaximumSendBuffersInFlight())) {
            return false;
        }
        if (!Objects.equals(this.getMaximumSharedBuffersPosted(), other.getMaximumSharedBuffersPosted())) {
            return false;
        }
        if (!Objects.equals(this.getNetworkCredits(), other.getNetworkCredits())) {
            return false;
        }
        if (!Objects.equals(this.getNewFollowerConnectionTimeoutSecs(), other.getNewFollowerConnectionTimeoutSecs())) {
            return false;
        }
        if (!Objects.equals(this.getPgqlMaximumNumBuffers(), other.getPgqlMaximumNumBuffers())) {
            return false;
        }
        if (!Objects.equals(this.getOnHoldJobTimeoutSecs(), other.getOnHoldJobTimeoutSecs())) {
            return false;
        }
        if (!Objects.equals(this.getEngineConnectionTimeoutSecs(), other.getEngineConnectionTimeoutSecs())) {
            return false;
        }
        if (!Objects.equals(this.getMaximumAttainableMemory(), other.getMaximumAttainableMemory())) {
            return false;
        }
        if (!Objects.equals(this.getLivenessCheckDelaySecs(), other.getLivenessCheckDelaySecs())) {
            return false;
        }
        if (!Objects.equals(this.getLivenessCheckTimeoutSecs(), other.getLivenessCheckTimeoutSecs())) {
            return false;
        }
        if (!Objects.equals(this.getSystemIdleDelayBeforeIdlingMsecs(), other.getSystemIdleDelayBeforeIdlingMsecs())) {
            return false;
        }
        if (!Objects.equals(this.getSystemIdleSleepIncrementMsecs(), other.getSystemIdleSleepIncrementMsecs())) {
            return false;
        }
        if (!Objects.equals(this.getSystemIdleSleepIncrementIntervalMsecs(), other.getSystemIdleSleepIncrementIntervalMsecs())) {
            return false;
        }
        if (!Objects.equals(this.getSystemIdleSleepMaxMsecs(), other.getSystemIdleSleepMaxMsecs())) {
            return false;
        }
        if (!Objects.equals(this.getJavaClassPath(), other.getJavaClassPath())) {
            return false;
        }
        if (!Objects.equals(this.useInfiniband(), other.useInfiniband())) {
            return false;
        }
        if (!Objects.equals(this.getIfInfiniband(), other.getIfInfiniband())) {
            return false;
        }
        if (!Objects.equals(this.getIfEthernet(), other.getIfEthernet())) {
            return false;
        }
        if (!Objects.equals(this.getLargeBufCount(), other.getLargeBufCount())) {
            return false;
        }
        if (!Objects.equals(this.getLargeBufSizeKb(), other.getLargeBufSizeKb())) {
            return false;
        }
        if (!Objects.equals(this.isPartitioningShuffleVertices(), other.isPartitioningShuffleVertices())) {
            return false;
        }
        if (!Objects.equals(this.getPartitioningStrategy(), other.getPartitioningStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getProcId(), other.getProcId())) {
            return false;
        }
        if (!Objects.equals(this.getResourceMonitor(), other.getResourceMonitor())) {
            return false;
        }
        if (!Objects.equals(this.getDebugServer(), other.getDebugServer())) {
            return false;
        }
        if (!Objects.equals(this.getInstanceName(), other.getInstanceName())) {
            return false;
        }
        if (!Objects.equals(this.isEnableEngineTls(), other.isEnableEngineTls())) {
            return false;
        }
        if (!Objects.equals(this.getEngineTlsKeystore(), other.getEngineTlsKeystore())) {
            return false;
        }
        if (!Objects.equals(this.getEngineTlsTruststore(), other.getEngineTlsTruststore())) {
            return false;
        }
        if (!Objects.equals(this.getEngineTlsCipher(), other.getEngineTlsCipher())) {
            return false;
        }
        if (!Objects.equals(this.isEngineTlsVerifyHostname(), other.isEngineTlsVerifyHostname())) {
            return false;
        }
        if (!Objects.equals(this.getEngineTlsExpectedDn(), other.getEngineTlsExpectedDn())) {
            return false;
        }
        if (!Objects.equals(this.getBackendWrapper(), other.getBackendWrapper())) {
            return false;
        }
        if (!Objects.equals(this.getHandshakePort(), other.getHandshakePort())) {
            return false;
        }
        if (!Objects.equals(this.isEnableCsrfTokenChecks(), other.isEnableCsrfTokenChecks())) {
            return false;
        }
        if (!Objects.equals(this.getTmpDir(), other.getTmpDir())) {
            return false;
        }
        if (!Objects.equals(this.getAllowedRemoteLoadingLocations(), other.getAllowedRemoteLoadingLocations())) {
            return false;
        }
        if (!Objects.equals(this.isInitPgqlOnStartup(), other.isInitPgqlOnStartup())) {
            return false;
        }
        if (!Objects.equals(this.getMaxHttpClientRequestSize(), other.getMaxHttpClientRequestSize())) {
            return false;
        }
        if (!Objects.equals(this.getPgxRealm(), other.getPgxRealm())) {
            return false;
        }
        if (!Objects.equals(this.getFileLocations(), other.getFileLocations())) {
            return false;
        }
        if (!Objects.equals(this.isAuthorizationSessionCreateAllowAll(), other.isAuthorizationSessionCreateAllowAll())) {
            return false;
        }
        if (!Objects.equals(this.getAuthorization(), other.getAuthorization())) {
            return false;
        }
        if (!Objects.equals(this.isEnableMemoryLimitsChecks(), other.isEnableMemoryLimitsChecks())) {
            return false;
        }
        if (!Objects.equals(this.getDataMemoryLimits(), other.getDataMemoryLimits())) {
            return false;
        }
        if (!Objects.equals(this.isEnableShutdownCleanupHook(), other.isEnableShutdownCleanupHook())) {
            return false;
        }
        if (!Objects.equals(this.getSessionIdleTimeoutSecs(), other.getSessionIdleTimeoutSecs())) {
            return false;
        }
        if (!Objects.equals(this.getSessionTaskTimeoutSecs(), other.getSessionTaskTimeoutSecs())) {
            return false;
        }
        if (!Objects.equals(this.isAllowIdleTimeoutOverwrite(), other.isAllowIdleTimeoutOverwrite())) {
            return false;
        }
        if (!Objects.equals(this.isAllowTaskTimeoutOverwrite(), other.isAllowTaskTimeoutOverwrite())) {
            return false;
        }
        if (!Objects.equals(this.getMaxActiveSessions(), other.getMaxActiveSessions())) {
            return false;
        }
        if (!Objects.equals(this.getMaxQueueSizePerSession(), other.getMaxQueueSizePerSession())) {
            return false;
        }
        if (!Objects.equals(this.getIntervalToPollMax(), other.getIntervalToPollMax())) {
            return false;
        }
        if (!Objects.equals(this.getAdminRequestCacheTimeout(), other.getAdminRequestCacheTimeout())) {
            return false;
        }
        if (!Objects.equals(this.isLaunchWatchdogs(), other.isLaunchWatchdogs())) {
            return false;
        }
        if (!Objects.equals(this.isStrictMode(), other.isStrictMode())) {
            return false;
        }
        if (!Objects.equals(this.getPreloadGraphs(), other.getPreloadGraphs())) {
            return false;
        }
        if (!Objects.equals(this.getMemoryCleanupInterval(), other.getMemoryCleanupInterval())) {
            return false;
        }
        if (!Objects.equals(this.getReleaseMemoryThreshold(), other.getReleaseMemoryThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getReadinessMemoryUsageRatio(), other.getReadinessMemoryUsageRatio())) {
            return false;
        }
        if (!Objects.equals(this.getRunningMemoryUsageRatio(), other.getRunningMemoryUsageRatio())) {
            return false;
        }
        if (!Objects.equals(this.getPgxServerBaseUrl(), other.getPgxServerBaseUrl())) {
            return false;
        }
        if (!Objects.equals(this.getPermissionChecksInterval(), other.getPermissionChecksInterval())) {
            return false;
        }
        if (!Objects.equals((Object)this.getGraphSharingOption(), (Object)other.getGraphSharingOption())) {
            return false;
        }
        if (!Objects.equals(this.isEnableSnapshotPropertiesPublishStatePropagation(), other.isEnableSnapshotPropertiesPublishStatePropagation())) {
            return false;
        }
        if (!Objects.equals(this.getNumSpinLocks(), other.getNumSpinLocks())) {
            return false;
        }
        if (!Objects.equals(this.isExplicitSpinLocks(), other.isExplicitSpinLocks())) {
            return false;
        }
        if (!Objects.equals(this.getScheduler(), other.getScheduler())) {
            return false;
        }
        if (!Objects.equals(this.getTaskLength(), other.getTaskLength())) {
            return false;
        }
        if (!Objects.equals(this.getSmallTaskLength(), other.getSmallTaskLength())) {
            return false;
        }
        if (!Objects.equals((Object)this.getMsBfsFrontierTypeStrategy(), (Object)other.getMsBfsFrontierTypeStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getBfsThresholdSingleThreaded(), other.getBfsThresholdSingleThreaded())) {
            return false;
        }
        if (!Objects.equals(this.getBfsThresholdReadBased(), other.getBfsThresholdReadBased())) {
            return false;
        }
        if (!Objects.equals(this.getBfsIterateQueTaskSize(), other.getBfsIterateQueTaskSize())) {
            return false;
        }
        if (!Objects.equals(this.getBfsThresholdParentReadBased(), other.getBfsThresholdParentReadBased())) {
            return false;
        }
        if (!Objects.equals(this.getDfsThresholdLarge(), other.getDfsThresholdLarge())) {
            return false;
        }
        if (!Objects.equals(this.getCniStopRecursionDefault(), other.getCniStopRecursionDefault())) {
            return false;
        }
        if (!Objects.equals(this.getCniSmallDefault(), other.getCniSmallDefault())) {
            return false;
        }
        if (!Objects.equals(this.getCniDiffFactorDefault(), other.getCniDiffFactorDefault())) {
            return false;
        }
        if (!Objects.equals(this.getLargeArrayThreshold(), other.getLargeArrayThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getMaxOffHeapSize(), other.getMaxOffHeapSize())) {
            return false;
        }
        if (!Objects.equals(this.getCharacterSet(), other.getCharacterSet())) {
            return false;
        }
        if (!Objects.equals(this.getParallelism(), other.getParallelism())) {
            return false;
        }
        if (!Objects.equals((Object)this.getRandomGeneratorStrategy(), (Object)other.getRandomGeneratorStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getRandomSeed(), other.getRandomSeed())) {
            return false;
        }
        if (!Objects.equals(this.getPatternMatchingSupernodeCacheThreshold(), other.getPatternMatchingSupernodeCacheThreshold())) {
            return false;
        }
        if (!Objects.equals((Object)this.getUseIndexForReachabilityQueries(), (Object)other.getUseIndexForReachabilityQueries())) {
            return false;
        }
        if (!Objects.equals(this.getRevisitThreshold(), other.getRevisitThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getEnterpriseSchedulerFlags(), other.getEnterpriseSchedulerFlags())) {
            return false;
        }
        if (!Objects.equals((Object)this.getMemoryAllocator(), (Object)other.getMemoryAllocator())) {
            return false;
        }
        if (!Objects.equals(this.getMaxDistinctStringsPerPool(), other.getMaxDistinctStringsPerPool())) {
            return false;
        }
        if (!Objects.equals((Object)this.getStringPoolingStrategy(), (Object)other.getStringPoolingStrategy())) {
            return false;
        }
        if (!Objects.equals(this.useMemoryMapperForStoringPgb(), other.useMemoryMapperForStoringPgb())) {
            return false;
        }
        if (!Objects.equals(this.useMemoryMapperForReadingPgb(), other.useMemoryMapperForReadingPgb())) {
            return false;
        }
        if (!Objects.equals(this.getPoolingFactor(), other.getPoolingFactor())) {
            return false;
        }
        return Objects.equals((Object)this.getGraphValidationLevel(), (Object)other.getGraphValidationLevel());
    }

    public static enum Field implements ConfigField
    {
        ENABLE_GRAPH_LOADING_CACHE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        BASIC_SCHEDULER_CONFIG(Collections.emptyList(), Collections.emptyList(), BasicSchedulerConfig.class, false, Collections.emptyMap(), false, false, false, false),
        ENTERPRISE_SCHEDULER_CONFIG(Collections.emptyList(), Collections.emptyList(), EnterpriseSchedulerConfig.class, false, Collections.emptyMap(), false, false, false, false),
        MIN_FETCH_INTERVAL_SEC(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 2, false, false, false, false),
        MIN_UPDATE_INTERVAL_SEC(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 2, false, false, false, false),
        IN_PLACE_UPDATE_CONSISTENCY_MODEL(Collections.emptyList(), Collections.emptyList(), UpdateConsistencyModel.class, false, (Object)((Object)UpdateConsistencyModel.ALLOW_INCONSISTENCIES), false, false, false, false),
        MIN_ARRAY_COMPACTION_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.2, false, false, false, false),
        MAX_SNAPSHOT_COUNT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        JAVA_HOME_DIR(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        ENABLE_GM_COMPILER(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        GRAPH_ALGORITHM_LANGUAGE(Collections.emptyList(), Collections.emptyList(), Compiler.class, false, (Object)((Object)Compiler.JAVA), false, false, false, false),
        UNSAFE_ALLOW_FOREIGN_SYNTAX(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        ALLOW_USER_AUTO_REFRESH(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        IGNORE_INCOMPATIBLE_BACKEND_OPERATIONS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        ALLOW_OVERRIDE_SCHEDULING_INFORMATION(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        UDF_CONFIG_DIRECTORY(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        HOSTNAMES(Collections.emptyList(), Collections.emptyList(), String.class, false, Collections.emptyList(), true, false, false, false),
        EXISTING_HOSTNAMES(Collections.emptyList(), Collections.emptyList(), String.class, false, Collections.emptyList(), true, false, false, false),
        EXECUTABLE_PATH(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        BUILTINS_PATH(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        LOG_CONFIGURE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        COMMON_LOG_CONFIGURE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        LOG_STD_REDIRECT(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        MAXIMUM_COMMAND_BUFFERS_POSTED_PER_REMOTE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 16, false, false, false, false),
        MAXIMUM_RECEIVED_MESSAGES_BUFFER(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1024, false, false, false, false),
        MAXIMUM_SEND_BUFFERS_IN_FLIGHT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 2048, false, false, false, false),
        MAXIMUM_SHARED_BUFFERS_POSTED(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 16384, false, false, false, false),
        NETWORK_CREDITS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 16383, false, false, false, false),
        NEW_FOLLOWER_CONNECTION_TIMEOUT_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 180, false, false, false, false),
        PGQL_MAXIMUM_NUM_BUFFERS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        ON_HOLD_JOB_TIMEOUT_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 300, false, false, false, false),
        ENGINE_CONNECTION_TIMEOUT_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 120, false, false, false, false),
        MAXIMUM_ATTAINABLE_MEMORY(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        LIVENESS_CHECK_DELAY_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 180, false, false, false, false),
        LIVENESS_CHECK_TIMEOUT_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 60, false, false, false, false),
        SYSTEM_IDLE_DELAY_BEFORE_IDLING_MSECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 10000, false, false, false, false),
        SYSTEM_IDLE_SLEEP_INCREMENT_MSECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 50, false, false, false, false),
        SYSTEM_IDLE_SLEEP_INCREMENT_INTERVAL_MSECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 5000, false, false, false, false),
        SYSTEM_IDLE_SLEEP_MAX_MSECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 500, false, false, false, false),
        JAVA_CLASS_PATH(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        USE_INFINIBAND(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        IF_INFINIBAND(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        IF_ETHERNET(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        LARGE_BUF_COUNT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 65536, false, false, false, false),
        LARGE_BUF_SIZE_KB(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 256, false, false, false, false),
        PARTITIONING_SHUFFLE_VERTICES(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        PARTITIONING_STRATEGY(Collections.emptyList(), Collections.emptyList(), String.class, false, "out_in", false, false, false, false),
        PROC_ID(Collections.emptyList(), Collections.emptyList(), Integer.class, false, null, false, false, false, false),
        RESOURCE_MONITOR(Collections.emptyList(), Collections.emptyList(), Integer.class, false, null, false, false, false, false),
        DEBUG_SERVER(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        INSTANCE_NAME(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        ENABLE_ENGINE_TLS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        ENGINE_TLS_KEYSTORE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        ENGINE_TLS_TRUSTSTORE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        ENGINE_TLS_CIPHER(Collections.emptyList(), Collections.emptyList(), String.class, false, "TLS_AES_256_GCM_SHA384", false, false, false, false),
        ENGINE_TLS_VERIFY_HOSTNAME(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        ENGINE_TLS_EXPECTED_DN(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        BACKEND_WRAPPER(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        HANDSHAKE_PORT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 7777, false, false, false, false),
        ENABLE_CSRF_TOKEN_CHECKS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        TMP_DIR(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, true, false, false),
        ALLOWED_REMOTE_LOADING_LOCATIONS(Arrays.asList("allow_remote_loading_locations"), Collections.emptyList(), String.class, false, Collections.emptyList(), true, false, false, false),
        INIT_PGQL_ON_STARTUP(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        MAX_HTTP_CLIENT_REQUEST_SIZE(Collections.emptyList(), Collections.emptyList(), Long.class, false, 0xA00000L, false, false, false, false),
        PGX_REALM(Collections.emptyList(), Collections.emptyList(), RealmConfig.class, false, Collections.emptyMap(), false, false, false, false),
        FILE_LOCATIONS(Collections.emptyList(), Collections.emptyList(), AuthorizationLocationConfig.class, false, Collections.emptyList(), true, false, false, false),
        AUTHORIZATION_SESSION_CREATE_ALLOW_ALL(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        AUTHORIZATION(Collections.emptyList(), Collections.emptyList(), AuthorizationEntityConfig.class, false, Collections.emptyList(), true, false, false, false),
        ENABLE_MEMORY_LIMITS_CHECKS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        DATA_MEMORY_LIMITS(Collections.emptyList(), Collections.emptyList(), DataMemoryLimitsConfig.class, false, Collections.emptyMap(), false, false, false, false),
        ENABLE_SHUTDOWN_CLEANUP_HOOK(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        SESSION_IDLE_TIMEOUT_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        SESSION_TASK_TIMEOUT_SECS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0, false, false, false, false),
        ALLOW_IDLE_TIMEOUT_OVERWRITE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        ALLOW_TASK_TIMEOUT_OVERWRITE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        MAX_ACTIVE_SESSIONS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1024, false, false, false, false),
        MAX_QUEUE_SIZE_PER_SESSION(Collections.emptyList(), Collections.emptyList(), Integer.class, false, -1, false, false, false, false),
        INTERVAL_TO_POLL_MAX(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1000, false, false, false, false),
        ADMIN_REQUEST_CACHE_TIMEOUT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 60, false, false, false, false),
        LAUNCH_WATCHDOGS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        STRICT_MODE(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        PRELOAD_GRAPHS(Collections.emptyList(), Collections.emptyList(), PreloadGraphConfig.class, false, Collections.emptyList(), true, false, false, false),
        MEMORY_CLEANUP_INTERVAL(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 600, false, false, false, false),
        RELEASE_MEMORY_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.85, false, false, false, false),
        READINESS_MEMORY_USAGE_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false),
        RUNNING_MEMORY_USAGE_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false),
        PGX_SERVER_BASE_URL(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        PERMISSION_CHECKS_INTERVAL(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 60, false, false, false, false),
        GRAPH_SHARING_OPTION(Collections.emptyList(), Collections.emptyList(), GraphSharingOption.class, false, (Object)((Object)GraphSharingOption.ALLOW_DATA_SHARING), false, false, false, false),
        ENABLE_SNAPSHOT_PROPERTIES_PUBLISH_STATE_PROPAGATION(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        NUM_SPIN_LOCKS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1024, false, false, false, false),
        EXPLICIT_SPIN_LOCKS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        SCHEDULER(Collections.emptyList(), Collections.emptyList(), SchedulerStrategy.class, false, SchedulerStrategy.ENTERPRISE_SCHEDULER, false, false, false, false),
        TASK_LENGTH(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        SMALL_TASK_LENGTH(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        MS_BFS_FRONTIER_TYPE_STRATEGY(Collections.emptyList(), Collections.emptyList(), FrontierTypeStrategy.class, false, (Object)((Object)FrontierTypeStrategy.AUTO_GROW), false, false, false, false),
        BFS_THRESHOLD_SINGLE_THREADED(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        BFS_THRESHOLD_READ_BASED(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1024, false, false, false, false),
        BFS_ITERATE_QUE_TASK_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        BFS_THRESHOLD_PARENT_READ_BASED(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.05, false, false, false, false),
        DFS_THRESHOLD_LARGE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        CNI_STOP_RECURSION_DEFAULT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 96, false, false, false, false),
        CNI_SMALL_DEFAULT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        CNI_DIFF_FACTOR_DEFAULT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 8, false, false, false, false),
        LARGE_ARRAY_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0x7FFFFFFC, false, false, false, false),
        MAX_OFF_HEAP_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<available-physical-memory>", false, false, false, false),
        CHARACTER_SET(Collections.emptyList(), Collections.emptyList(), String.class, false, "UTF-8", false, false, false, false),
        PARALLELISM(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<no-of-CPUs>", false, false, false, false),
        RANDOM_GENERATOR_STRATEGY(Collections.emptyList(), Collections.emptyList(), RandomGeneratorStrategy.class, false, (Object)((Object)RandomGeneratorStrategy.NON_DETERMINISTIC), false, false, false, false),
        RANDOM_SEED(Collections.emptyList(), Collections.emptyList(), Long.class, false, -24466691093057031L, false, false, false, false),
        PATTERN_MATCHING_SUPERNODE_CACHE_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1000, false, false, false, false),
        USE_INDEX_FOR_REACHABILITY_QUERIES(Collections.emptyList(), Collections.emptyList(), ReachabilityIndexCreationMode.class, false, (Object)((Object)ReachabilityIndexCreationMode.AUTO), false, false, false, false),
        REVISIT_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        ENTERPRISE_SCHEDULER_FLAGS(Collections.emptyList(), Collections.emptyList(), EnterpriseSchedulerFlagsConfig.class, false, Collections.emptyMap(), false, false, false, false),
        MEMORY_ALLOCATOR(Collections.emptyList(), Collections.emptyList(), MemoryAllocationStrategy.class, false, (Object)((Object)MemoryAllocationStrategy.BASIC_ALLOCATOR), false, false, false, false),
        MAX_DISTINCT_STRINGS_PER_POOL(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 65536, false, false, false, false),
        STRING_POOLING_STRATEGY(Collections.emptyList(), Collections.emptyList(), StringPoolingStrategy.class, false, (Object)((Object)StringPoolingStrategy.ON_HEAP), false, false, false, false),
        USE_MEMORY_MAPPER_FOR_STORING_PGB(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        USE_MEMORY_MAPPER_FOR_READING_PGB(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        POOLING_FACTOR(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.25, false, false, false, false),
        GRAPH_VALIDATION_LEVEL(Collections.emptyList(), Collections.emptyList(), GraphValidationLevel.class, false, (Object)((Object)GraphValidationLevel.LOW), false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("pgx.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

