/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.auth.PgxGeneralPermission;
import oracle.pgx.common.auth.PgxResourcePermission;
import oracle.pgx.common.util.ErrorMessages;

public enum PgxConfigPermission {
    READ,
    WRITE,
    EXPORT,
    MANAGE,
    PGX_SESSION_CREATE,
    PGX_SESSION_NEW_GRAPH,
    PGX_SESSION_GET_PUBLISHED_GRAPH,
    PGX_SESSION_ADD_PUBLISHED_GRAPH,
    PGX_SESSION_COMPILE_ALGORITHM,
    PGX_SERVER_GET_INFO,
    PGX_SERVER_MANAGE,
    PGX_SESSION_READ_MODEL,
    PGX_SESSION_MODIFY_MODEL;


    boolean isGeneralPermission() {
        switch (this) {
            case PGX_SESSION_CREATE: 
            case PGX_SESSION_NEW_GRAPH: 
            case PGX_SESSION_GET_PUBLISHED_GRAPH: 
            case PGX_SESSION_ADD_PUBLISHED_GRAPH: 
            case PGX_SESSION_COMPILE_ALGORITHM: 
            case PGX_SERVER_GET_INFO: 
            case PGX_SERVER_MANAGE: 
            case PGX_SESSION_READ_MODEL: 
            case PGX_SESSION_MODIFY_MODEL: {
                return true;
            }
        }
        return false;
    }

    PgxGeneralPermission toGeneralPermission() {
        switch (this) {
            case PGX_SESSION_CREATE: {
                return PgxGeneralPermission.SESSION_CREATE;
            }
            case PGX_SESSION_NEW_GRAPH: {
                return PgxGeneralPermission.SESSION_NEW_GRAPH;
            }
            case PGX_SESSION_GET_PUBLISHED_GRAPH: {
                return PgxGeneralPermission.SESSION_GET_PUBLISHED_GRAPH;
            }
            case PGX_SESSION_ADD_PUBLISHED_GRAPH: {
                return PgxGeneralPermission.SESSION_ADD_PUBLISHED_GRAPH;
            }
            case PGX_SESSION_COMPILE_ALGORITHM: {
                return PgxGeneralPermission.SESSION_COMPILE_ALGORITHM;
            }
            case PGX_SERVER_GET_INFO: {
                return PgxGeneralPermission.SERVER_GET_INFO;
            }
            case PGX_SERVER_MANAGE: {
                return PgxGeneralPermission.SERVER_MANAGE;
            }
            case PGX_SESSION_READ_MODEL: {
                return PgxGeneralPermission.SESSION_READ_MODEL;
            }
            case PGX_SESSION_MODIFY_MODEL: {
                return PgxGeneralPermission.SESSION_MODIFY_MODEL;
            }
        }
        throw new IllegalEnumConstantException((Enum)this);
    }

    PgxResourcePermission toObjectPermission() {
        switch (this) {
            case READ: {
                return PgxResourcePermission.READ;
            }
            case WRITE: {
                return PgxResourcePermission.WRITE;
            }
            case EXPORT: {
                return PgxResourcePermission.EXPORT;
            }
            case MANAGE: {
                return PgxResourcePermission.MANAGE;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ILLEGAL_PERMISSION_CONVERSION_GENERAL_TO_RESOURCE", (Object[])new Object[0]));
    }
}

