/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.PreloadGraphConfig;

public final class PreloadGraphConfigBuilder {
    private final Map<PreloadGraphConfig.Field, Object> values = new HashMap<PreloadGraphConfig.Field, Object>();

    public static PreloadGraphConfig buildPreloadGraphConfig(Consumer<PreloadGraphConfigBuilder> builderSetup) {
        PreloadGraphConfigBuilder builder = new PreloadGraphConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PreloadGraphConfigBuilder() {
    }

    public PreloadGraphConfigBuilder(Map<PreloadGraphConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PreloadGraphConfigBuilder(PreloadGraphConfig config) {
        this.putAll(config);
    }

    public PreloadGraphConfigBuilder(PreloadGraphConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PreloadGraphConfigBuilder putAll(Map<PreloadGraphConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PreloadGraphConfigBuilder putAll(PreloadGraphConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PreloadGraphConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PreloadGraphConfig build(String parentPath) {
        try {
            return PreloadGraphConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PreloadGraphConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PreloadGraphConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PreloadGraphConfigBuilder" + this.values;
    }

    public PreloadGraphConfigBuilder setPath(String path) {
        this.values.put(PreloadGraphConfig.Field.PATH, path);
        return this;
    }

    public PreloadGraphConfigBuilder setName(String name) {
        this.values.put(PreloadGraphConfig.Field.NAME, name);
        return this;
    }

    public PreloadGraphConfigBuilder setLoadAtServerInitialization(boolean loadAtServerInitialization) {
        this.values.put(PreloadGraphConfig.Field.LOAD_AT_SERVER_INITIALIZATION, loadAtServerInitialization);
        return this;
    }

    public PreloadGraphConfigBuilder setPublish(boolean publish) {
        this.values.put(PreloadGraphConfig.Field.PUBLISH, publish);
        return this;
    }

    public PreloadGraphConfigBuilder setPublishWithSnapshots(boolean publishWithSnapshots) {
        this.values.put(PreloadGraphConfig.Field.PUBLISH_WITH_SNAPSHOTS, publishWithSnapshots);
        return this;
    }
}

