/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.AbstractConfigParser;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;

public class PropertiesConfigParser<F extends ConfigField>
extends AbstractConfigParser<F> {
    private final Properties props;

    public static <F extends ConfigField> ParseResult<F> parse(Properties props, F[] fields, boolean strict) {
        return new PropertiesConfigParser(props, fields, strict).parse();
    }

    private PropertiesConfigParser(Properties props, F[] fields, boolean strict) {
        super(fields, strict);
        this.props = props;
    }

    public ParseResult<F> parse() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        for (ConfigField field : this.fields) {
            Object value = this.parse(field);
            if (value == null) continue;
            raw.put(field.toKey(), value);
        }
        return ConfigParser.parse(raw, (ConfigField[])this.fields, (boolean)this.strict, null);
    }

    private Object parse(F field) {
        if (field.isPrimitive() || field.isEnum()) {
            return this.parsePrimitive(field);
        }
        return this.parseComplex(field);
    }

    private Object parsePrimitive(F field) {
        if (!field.isArray()) {
            return this.parsePrimitiveScalar(field);
        }
        return this.parsePrimitiveArray(field);
    }

    private Object parsePrimitiveScalar(F field) {
        String value = this.props.getProperty(field.toKey());
        if (value != null) {
            return this.parsePrimitiveScalar(field, value);
        }
        return null;
    }

    private Object parsePrimitiveArray(F field) {
        String value;
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 1;
        while ((value = this.props.getProperty(field.toKey() + "." + i)) != null) {
            list.add(this.parsePrimitiveScalar(field, value));
            ++i;
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    private Object parsePrimitiveScalar(F field, String value) {
        assert (value != null);
        if (field.isEnum() || field.getType() == String.class) {
            return value;
        }
        if (field.getType() == Integer.class) {
            return Integer.valueOf(value);
        }
        if (field.getType() == Long.class) {
            return Long.decode(value);
        }
        if (field.getType() == Double.class) {
            return Double.parseDouble(value);
        }
        if (field.getType() == Boolean.class) {
            return PropertyType.parseBoolean((String)value);
        }
        throw this.criticalError("UNSUPPORTED_PRIMITIVE_TYPE", field.getType());
    }

    private Object parseComplex(F field) {
        if (!field.isArray()) {
            return this.parseComplexScalar(field);
        }
        return this.parseComplexArray(field);
    }

    private Object parseComplexScalar(F field) {
        return this.parseComplexScalar(field, field.toKey(), true);
    }

    private Object parseComplexScalar(F field, String prefix, boolean parseEmptyObject) {
        if (field.getType().isAssignableFrom(Map.class)) {
            return null;
        }
        Properties subProps = new Properties();
        Enumeration<?> propertyNames = this.props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!key.startsWith(prefix)) continue;
            String value = this.props.getProperty(key);
            assert (value != null);
            String subKey = key.substring((prefix + ".").length());
            subProps.setProperty(subKey, value);
        }
        if (subProps.isEmpty() && !parseEmptyObject) {
            return null;
        }
        try {
            Method parse = field.getType().getDeclaredMethod("parse", Properties.class, Boolean.TYPE);
            return parse.invoke(null, subProps, this.strict);
        }
        catch (InvocationTargetException e) {
            this.error(e.getCause().getMessage(), e.getCause(), new Object[0]);
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            throw this.criticalError("UNSUPPORTED_COMPLEX_TYPE", field.getType());
        }
    }

    private Object parseComplexArray(F field) {
        Object value;
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 1;
        while ((value = this.parseComplexScalar(field, field.toKey() + "." + i, false)) != null) {
            list.add(value);
            ++i;
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }
}

