/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Collection;
import java.util.Objects;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.OnMissingVertex;

public interface ReadGraphOption {
    public static final OptimizedForOption OPTIMIZED_FOR_UPDATES = ReadGraphOption.optimizeFor(GraphOptimizedFor.UPDATES);
    public static final OptimizedForOption OPTIMIZED_FOR_READ = ReadGraphOption.optimizeFor(GraphOptimizedFor.READ);
    public static final SynchronizableOptionReadGraphOption SYNCHRONIZABLE = ReadGraphOption.synchronizable();
    public static final OnMissingVertexOption ON_MISSING_VERTEX_IGNORE_EDGE = ReadGraphOption.onMissingVertex(OnMissingVertex.IGNORE_EDGE);
    public static final OnMissingVertexOption ON_MISSING_VERTEX_IGNORE_EDGE_LOG = ReadGraphOption.onMissingVertex(OnMissingVertex.IGNORE_EDGE_LOG);
    public static final OnMissingVertexOption ON_MISSING_VERTEX_IGNORE_EDGE_LOG_ONCE = ReadGraphOption.onMissingVertex(OnMissingVertex.IGNORE_EDGE_LOG_ONCE);
    public static final OnMissingVertexOption ON_MISSING_VERTEX_ERROR = ReadGraphOption.onMissingVertex(OnMissingVertex.ERROR);

    public static <T extends ReadGraphOption> void validateUnique(Collection<ReadGraphOption> options, Class<T> clazz, String errorMessage) {
        if (options != null && options.stream().filter(option -> clazz.isInstance(option)).distinct().count() > 1L) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static OptimizedForOption optimizeFor(GraphOptimizedFor optimizedFor) {
        return new OptimizedForOption(optimizedFor);
    }

    public static OnMissingVertexOption onMissingVertex(OnMissingVertex onMissingVertex) {
        if (onMissingVertex == OnMissingVertex.CREATE_VERTEX || onMissingVertex == OnMissingVertex.CREATE_VERTEX_LOG || onMissingVertex == OnMissingVertex.CREATE_VERTEX_LOG_ONCE) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"READ_GRAPH_OPTION_UNSUPPORTED", (Object[])new Object[]{onMissingVertex}));
        }
        return new OnMissingVertexOption(onMissingVertex);
    }

    public static ParallelHintDegreeReadGraphOption withParallelHintDegree(int parallelHintDegree) {
        return new ParallelHintDegreeReadGraphOption(parallelHintDegree);
    }

    public static SynchronizableOptionReadGraphOption synchronizable() {
        return new SynchronizableOptionReadGraphOption();
    }

    public void apply(ReadGraphOptionDataBuilder var1);

    public static class ReadGraphOptionDataBuilder {
        private GraphOptimizedFor optimizedFor = null;
        private OnMissingVertex onMissingVertex = null;
        private boolean synchronizable = false;
        private Integer parallelHintDegree = null;

        private void setOptimizedFor(GraphOptimizedFor optimizedFor) {
            this.optimizedFor = optimizedFor;
        }

        private void setOnMissingVertex(OnMissingVertex onMissingVertex) {
            this.onMissingVertex = onMissingVertex;
        }

        private void setSynchronizable(boolean synchronizable) {
            this.synchronizable = true;
        }

        private void setParallelHintDegree(int parallelHintDegree) {
            this.parallelHintDegree = parallelHintDegree;
        }

        public GraphOptimizedFor getOptimizedFor() {
            return this.optimizedFor;
        }

        public OnMissingVertex getOnMissingVertex() {
            return this.onMissingVertex;
        }

        public boolean isSynchronizable() {
            return this.synchronizable;
        }

        public Integer getParallelHintDegree() {
            return this.parallelHintDegree;
        }
    }

    public static class ParallelHintDegreeReadGraphOption
    implements ReadGraphOption {
        private int parallelHintDegree;

        public ParallelHintDegreeReadGraphOption(int parallelHintDegree) {
            this.parallelHintDegree = parallelHintDegree;
        }

        public int getParallelHintDegree() {
            return this.parallelHintDegree;
        }

        @Override
        public void apply(ReadGraphOptionDataBuilder holder) {
            holder.setParallelHintDegree(this.parallelHintDegree);
        }

        public int hashCode() {
            return Objects.hash(this.parallelHintDegree);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ParallelHintDegreeReadGraphOption that = (ParallelHintDegreeReadGraphOption)obj;
            return this.parallelHintDegree == that.parallelHintDegree;
        }
    }

    public static class SynchronizableOptionReadGraphOption
    implements ReadGraphOption {
        @Override
        public void apply(ReadGraphOptionDataBuilder holder) {
            holder.setSynchronizable(true);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o.getClass() == this.getClass();
        }
    }

    public static class OnMissingVertexOption
    implements ReadGraphOption {
        private OnMissingVertex onMissingVertex;

        public OnMissingVertexOption(OnMissingVertex optimizedFor) {
            this.onMissingVertex = optimizedFor;
        }

        public OnMissingVertex getOnMissingVertex() {
            return this.onMissingVertex;
        }

        @Override
        public void apply(ReadGraphOptionDataBuilder holder) {
            holder.setOnMissingVertex(this.onMissingVertex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OnMissingVertexOption that = (OnMissingVertexOption)o;
            return this.onMissingVertex == that.onMissingVertex;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.onMissingVertex});
        }
    }

    public static class OptimizedForOption
    implements ReadGraphOption {
        private GraphOptimizedFor optimizedFor;

        public OptimizedForOption(GraphOptimizedFor optimizedFor) {
            this.optimizedFor = optimizedFor;
        }

        public GraphOptimizedFor getOptimizedFor() {
            return this.optimizedFor;
        }

        @Override
        public void apply(ReadGraphOptionDataBuilder holder) {
            holder.setOptimizedFor(this.optimizedFor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptimizedForOption that = (OptimizedForOption)o;
            return this.optimizedFor == that.optimizedFor;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.optimizedFor});
        }
    }
}

