/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.GraphWiseDominantLayerConfig;
import oracle.pgx.config.mllib.GraphWiseEmbeddingConfig;

public class EmbeddingConfigDeserializer
extends JsonDeserializer<GraphWiseEmbeddingConfig> {
    public GraphWiseEmbeddingConfig deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode embeddingTypeNode = jsonNode.get("embeddingType");
        GraphWiseEmbeddingConfig.EmbeddingType embeddingType = ConfigJsonUtil.fromJsonNode(embeddingTypeNode, GraphWiseEmbeddingConfig.EmbeddingType.class);
        switch (embeddingType) {
            case DGI: {
                return ConfigJsonUtil.fromJsonNode(jsonNode, GraphWiseDgiLayerConfig.class);
            }
            case DOMINANT: {
                return ConfigJsonUtil.fromJsonNode(jsonNode, GraphWiseDominantLayerConfig.class);
            }
        }
        throw new IllegalEnumConstantException((Enum)embeddingType);
    }
}

