/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractEngineConfig;
import oracle.pgx.config.AbstractFileEntityProviderConfig;
import oracle.pgx.config.AbstractFileGraphConfig;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.apache.commons.vfs2.provider.UriParser;

public class PathSanitizerUtils {
    private static final VirtualFileManager VFM;

    private static void addUrisIfTableIsBackedByFile(List<String> uris, EntityProviderConfig tableConfig) {
        if (tableConfig instanceof AbstractFileEntityProviderConfig) {
            AbstractFileEntityProviderConfig fileTableConfig = (AbstractFileEntityProviderConfig)tableConfig;
            uris.addAll(fileTableConfig.getUris());
        }
    }

    public static List<String> getUris(PartitionedGraphConfig config) {
        ArrayList<String> uris = new ArrayList<String>();
        config.getVertexProviders().forEach(tableConfig -> PathSanitizerUtils.addUrisIfTableIsBackedByFile(uris, tableConfig));
        config.getEdgeProviders().forEach(tableConfig -> PathSanitizerUtils.addUrisIfTableIsBackedByFile(uris, tableConfig));
        return uris;
    }

    public static List<String> getUris(AbstractFileGraphConfig config) {
        ArrayList<String> uris = new ArrayList<String>();
        if (config.isFileFormat()) {
            uris.addAll(config.getVertexUris());
            if (config.hasVerticesAndEdgesSeparatedFileFormat()) {
                uris.addAll(config.getEdgeUris());
            }
        }
        return uris;
    }

    public static Optional<IllegalArgumentException> checkIfUsesInvalidFileSystem(AbstractEngineConfig pgxConfig, String uri, UserContext userContext) {
        return PathSanitizerUtils.checkIfUsesInvalidFileSystem(pgxConfig, Collections.singletonList(uri), userContext);
    }

    public static Optional<IllegalArgumentException> checkIfUsesInvalidFileSystem(AbstractEngineConfig pgxConfig, Collection<String> uris, UserContext userContext) {
        return PathSanitizerUtils.checkIfFileSystemAllowsRemoteLoading(pgxConfig, uris);
    }

    private static boolean isRemoteLoadingGloballyAllowed(List<String> allowedRemoteSchemes) {
        return allowedRemoteSchemes.size() == 1 && allowedRemoteSchemes.get(0).equals("*");
    }

    private static Collection<String> extractNestedUris(Collection<String> uris) {
        ArrayList<String> allUris = new ArrayList<String>();
        String[] schemes = VFM.getSupportedSchemes();
        Iterator<String> iterator = uris.iterator();
        while (iterator.hasNext()) {
            String scheme;
            String uri;
            String subUri = uri = iterator.next();
            allUris.add(subUri);
            do {
                if ((scheme = UriParser.extractScheme((String[])schemes, (String)subUri)) == null) continue;
                if (subUri != uri) {
                    allUris.add(subUri);
                }
                int schemeLength = scheme.length() + 1;
                if (subUri.length() > schemeLength + 1 && subUri.charAt(schemeLength) == '/' && subUri.charAt(schemeLength + 1) == '/') {
                    schemeLength += 2;
                }
                subUri = subUri.substring(schemeLength);
            } while (scheme != null);
        }
        return allUris;
    }

    public static Optional<IllegalArgumentException> checkIfFileSystemAllowsRemoteLoading(AbstractEngineConfig pgxConfig, String uri) {
        return PathSanitizerUtils.checkIfFileSystemAllowsRemoteLoading(pgxConfig, Collections.singleton(uri));
    }

    public static Optional<IllegalArgumentException> checkIfFileSystemAllowsRemoteLoading(AbstractEngineConfig pgxConfig, Collection<String> uris) {
        List<String> allowedRemoteSchemes = pgxConfig.getAllowedRemoteLoadingLocations();
        if (PathSanitizerUtils.isRemoteLoadingGloballyAllowed(allowedRemoteSchemes)) {
            return Optional.empty();
        }
        Stream<String> remoteLoadingSchemes = PathSanitizerUtils.extractNestedUris(uris).stream().map(arg_0 -> ((VirtualFileManager)VFM).getRemoteLoadingScheme(arg_0)).filter(Objects::nonNull);
        if (remoteLoadingSchemes.anyMatch(s -> !allowedRemoteSchemes.contains(s))) {
            return Optional.of(new IllegalArgumentException(ErrorMessages.getMessage((String)"REMOTE_FILESYSTEMS_NOT_ALLOWED", (Object[])new Object[0])));
        }
        return Optional.empty();
    }

    static {
        StaticConfig.get().isEnablePluginVersionChecks();
        VFM = VirtualFileManagerFactory.getInstance();
    }
}

