/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public abstract class ElementTable {
    private SchemaQualifiedName tableName;
    private String tableAlias;
    Key key;
    private List<Label> labels;

    protected ElementTable(Key key, SchemaQualifiedName tableName, String tableAlias, List<Label> labels) {
        this.key = key;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
        this.labels = labels;
    }

    public SchemaQualifiedName getTableName() {
        return this.tableName;
    }

    public void setTableName(SchemaQualifiedName tableName) {
        this.tableName = tableName;
    }

    public String getTableAlias() {
        return this.tableAlias == null ? this.tableName.getName() : this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    protected String printAlias(String indentation) {
        if (this.tableAlias == null || this.tableAlias.equals(this.tableName.getName())) {
            return "";
        }
        return indentation + "AS " + PgqlUtils.printIdentifier(this.tableAlias);
    }

    protected String printKey(String indentation) {
        return this.key == null ? "" : indentation + "KEY " + this.key;
    }

    protected String printLabels(String indentation) {
        if (this.labels.size() == 1) {
            Label label = this.labels.get(0);
            if (label.getName().equals(this.getTableAlias())) {
                return indentation + label.printProperties();
            }
            return indentation + label.toString();
        }
        return indentation + this.labels.stream().map(x -> x.toString()).collect(Collectors.joining(indentation));
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementTable other = (ElementTable)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
            return false;
        }
        if (this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName)) {
            return false;
        }
        return !(this.tableAlias == null ? other.tableAlias != null : !this.tableAlias.equals(other.tableAlias));
    }
}

