/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir.modify;

import java.util.List;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.modify.AbstractInsertion;
import oracle.pgql.lang.ir.modify.InsertionType;
import oracle.pgql.lang.ir.modify.SetPropertyExpression;

public class EdgeInsertion
extends AbstractInsertion {
    private QueryEdge edge;

    public EdgeInsertion(QueryEdge edge, List<QueryExpression> labels, List<SetPropertyExpression> properties) {
        super(labels, properties);
        this.edge = edge;
    }

    public QueryEdge getEdge() {
        return this.edge;
    }

    public void setEdge(QueryEdge edge) {
        this.edge = edge;
    }

    @Override
    public InsertionType getInsertionType() {
        return InsertionType.EDGE_INSERTION;
    }

    public String toString() {
        return "EDGE " + PgqlUtils.printIdentifier(this.edge.getName(), false) + " BETWEEN " + PgqlUtils.printIdentifier(this.edge.getSrc().getName(), false) + " AND " + PgqlUtils.printIdentifier(this.edge.getDst().getName(), false) + this.printLabels() + this.printProperties();
    }

    @Override
    public int hashCode() {
        return 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EdgeInsertion other = (EdgeInsertion)obj;
        return !(this.edge == null ? other.edge != null : !this.edge.equals(other.edge));
    }

    @Override
    public void accept(QueryExpressionVisitor v) {
        v.visit(this);
    }
}

