/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import oracle.datastudio.graphviz.formatter.DataStudioFormatter;
import oracle.pg.rdbms.RdbmsDriver;
import oracle.pg.rdbms.sqlpgq.SqlPgqEnhancedResultSet;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadataUtils;
import oracle.pg.rdbms.sqlpgq.exception.SqlPgqVisualizationException;
import oracle.pgql.lang.PgqlException;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.GraphName;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Result;

public class SqlPgqDriver
extends RdbmsDriver {
    public SqlPgqDriver(Map<String, Object> properties) throws SQLException {
        super(properties);
    }

    public EnhancedResultSet query(@Nonnull String query, String graphName, @Nullable String schema, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public String modify(@Nonnull String pgqlQuery, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection<GraphName> getGraphs(Map<String, Object> properties) throws SQLException {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            Set<GraphName> graphs;
            Set<GraphName> set = graphs = SqlPgqMetadataUtils.getGraphNames(conn);
            return set;
        }
    }

    @Nonnull
    public GraphInformation getGraph(@Nullable String schemaName, @Nonnull String name, Map<String, Object> properties) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectedSupported() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleIterations() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Result> execute(String query, String schema, String graphName, Map<String, Object> properties) {
        DataSource ods = (DataSource)properties.get("datasource");
        try (Connection conn = ods.getConnection();){
            Optional<Result> result;
            SqlPgqEnhancedResultSet resultSet = new SqlPgqEnhancedResultSet(query, conn, properties);
            DataStudioFormatter formatter = new DataStudioFormatter();
            Optional<Result> optional = result = Optional.of(formatter.format((EnhancedResultSet)resultSet, properties));
            return optional;
        }
        catch (IOException | SQLException ex) {
            throw new SqlPgqVisualizationException(ex);
        }
    }

    public Future<Optional<Result>> executeAsync(String query, String schema, String graphName, Map<String, Object> properties) {
        CompletableFuture<Optional<Result>> queryExecution = CompletableFuture.supplyAsync(() -> this.execute(query, schema, graphName, properties));
        return queryExecution;
    }
}

