/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.sqlpgq.EdgeTable;
import oracle.pg.rdbms.sqlpgq.SqlPgqProperty;
import oracle.pg.rdbms.sqlpgq.VertexTable;
import oracle.pgx.graphviz.driver.GraphName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlPgqMetadataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqMetadataUtils.class);
    private final String graphName;
    private final String graphOwner;
    private final Connection conn;
    private Set<String> allVertexProperties = new HashSet<String>();
    private Set<String> allEdgeProperties = new HashSet<String>();
    private Map<String, EdgeTable> edgeTables = new HashMap<String, EdgeTable>();
    private Map<String, VertexTable> vertexTables = new HashMap<String, VertexTable>();

    public SqlPgqMetadataUtils(String graphName, String graphOwner, Connection conn) throws SQLException {
        this.graphName = graphName;
        this.graphOwner = graphOwner;
        this.conn = conn;
        this.fillMetadata();
    }

    private void fillMetadata() throws SQLException {
        this.fillVertexObjects();
        this.fillEdgeObjects();
    }

    private void fetchVertexColumnsIds() throws SQLException {
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT ELEMENTS.OBJECT_NAME, KEYS.COLUMN_NAME, ELEMENTS.ELEMENT_NAME FROM SYS.ALL_PG_KEYS KEYS INNER JOIN SYS.ALL_PG_ELEMENTS ELEMENTS ON ELEMENTS.ELEMENT_NAME = KEYS.ELEMENT_NAME WHERE ELEMENT_KIND = ? AND KEYS.GRAPH_NAME = ? AND ELEMENTS.OWNER = ?");){
            preparedStatement.setString(1, "VERTEX");
            preparedStatement.setString(2, this.graphName);
            preparedStatement.setString(3, this.graphOwner);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    String columnName = rs.getString(2);
                    if (tableName == null || columnName == null) continue;
                    LOG.debug("Column ID name {} for table {}", (Object)columnName, (Object)tableName);
                    VertexTable vertexTable = this.vertexTables.get(tableName);
                    if (vertexTable == null) continue;
                    vertexTable.getColumnIds().add(columnName);
                }
            }
        }
    }

    private void fetchEdgeColumnsIds() throws SQLException {
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT ELEMENTS.OBJECT_NAME, KEYS.COLUMN_NAME, ELEMENTS.ELEMENT_NAME FROM SYS.ALL_PG_KEYS KEYS INNER JOIN SYS.ALL_PG_ELEMENTS ELEMENTS ON ELEMENTS.ELEMENT_NAME = KEYS.ELEMENT_NAME WHERE ELEMENT_KIND = ? AND KEYS.GRAPH_NAME = ? AND ELEMENTS.OWNER = ?");){
            preparedStatement.setString(1, "EDGE");
            preparedStatement.setString(2, this.graphName);
            preparedStatement.setString(3, this.graphOwner);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    String tableAlias = rs.getString(3);
                    String columnName = rs.getString(2);
                    if (tableAlias == null || columnName == null || !this.edgeTables.keySet().contains(tableAlias)) continue;
                    this.edgeTables.get(tableAlias).getColumnIds().add(columnName);
                }
            }
        }
    }

    private void fillVertexObjects() throws SQLException {
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT ELEM_LABELS.ELEMENT_NAME, ELEM_LABELS.LABEL_NAME, ELEMENTS.OBJECT_NAME, LABEL_PROPERTIES.PROPERTY_NAME, PROP_DEFINITIONS.COLUMN_EXPR FROM SYS.ALL_PG_ELEMENTS ELEMENTS INNER JOIN SYS.ALL_PG_ELEMENT_LABELS ELEM_LABELS ON ELEMENTS.ELEMENT_NAME = ELEM_LABELS.ELEMENT_NAME INNER JOIN SYS.ALL_PG_LABEL_PROPERTIES LABEL_PROPERTIES ON ELEM_LABELS.LABEL_NAME = LABEL_PROPERTIES.LABEL_NAME INNER JOIN SYS.ALL_PG_PROP_DEFINITIONS PROP_DEFINITIONS ON PROP_DEFINITIONS.PROPERTY_NAME = LABEL_PROPERTIES.PROPERTY_NAME WHERE ELEMENTS.ELEMENT_KIND = 'VERTEX' AND ELEMENTS.GRAPH_NAME = ? AND ELEMENTS.OWNER = ? AND ( ELEMENTS.OWNER = ELEM_LABELS.OWNER AND ELEMENTS.GRAPH_NAME = ELEM_LABELS.GRAPH_NAME AND ELEMENTS.ELEMENT_NAME = ELEM_LABELS.ELEMENT_NAME ) AND ( ELEM_LABELS.OWNER = LABEL_PROPERTIES.OWNER AND ELEM_LABELS.GRAPH_NAME = LABEL_PROPERTIES.GRAPH_NAME)");){
            preparedStatement.setString(1, this.graphName);
            preparedStatement.setString(2, this.graphOwner);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    VertexTable vertexTable;
                    String tableAlias = rs.getString(1);
                    String labelName = rs.getString(2);
                    String objectName = rs.getString(3);
                    String property = rs.getString(4);
                    String columnExpression = rs.getString(5);
                    if (tableAlias == null || labelName == null || property == null || objectName == null) continue;
                    LOG.debug("Property {} for label {}", (Object)property, (Object)labelName);
                    SqlPgqProperty sqlPgqProperty = new SqlPgqProperty(property);
                    if (columnExpression != null) {
                        sqlPgqProperty.setColumnExpression(columnExpression);
                    }
                    if ((vertexTable = this.vertexTables.get(objectName)) != null) {
                        Set<SqlPgqProperty> properties = vertexTable.getProperties();
                        if (!properties.contains(sqlPgqProperty)) {
                            properties.add(sqlPgqProperty);
                        }
                    } else {
                        VertexTable newVertexTable = new VertexTable(labelName, tableAlias);
                        newVertexTable.getProperties().add(sqlPgqProperty);
                        this.vertexTables.put(objectName, newVertexTable);
                    }
                    this.allVertexProperties.add(property);
                }
            }
        }
        this.fetchVertexColumnsIds();
    }

    private void fetchSourceAndDestinationTableAndColumnNames() throws SQLException {
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT EDGE_TAB_NAME, EDGE_END, EDGE_COL_NAME, VERTEX_COL_NAME, ELEMENTS.OBJECT_NAME FROM SYS.ALL_PG_EDGE_RELATIONSHIPS RELATIONSHIPS INNER JOIN SYS.ALL_PG_ELEMENTS ELEMENTS ON RELATIONSHIPS.VERTEX_TAB_NAME = ELEMENTS.ELEMENT_NAME WHERE RELATIONSHIPS.GRAPH_NAME = ?");){
            preparedStatement.setString(1, this.graphName);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    String edgeTableName = rs.getString(1);
                    String type = rs.getString(2);
                    String edgeColumnName = rs.getString(3);
                    String vertexColumnName = rs.getString(4);
                    String tableName = rs.getString(5);
                    EdgeTable edgeTable = this.edgeTables.get(edgeTableName);
                    if (type.equals("SOURCE")) {
                        edgeTable.setVertexSourceId(vertexColumnName);
                        edgeTable.setVertexSourceTable(tableName);
                        edgeTable.setEdgeColumnNameSource(edgeColumnName);
                    } else {
                        edgeTable.setVertexDestinationId(vertexColumnName);
                        edgeTable.setVertexDestinationTable(tableName);
                        edgeTable.setEdgeColumnNameDestination(edgeColumnName);
                    }
                    this.edgeTables.put(edgeTableName, edgeTable);
                }
            }
        }
    }

    private void fetchEdgeProperties() throws SQLException {
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT DISTINCT ELEMENT_LABELS.ELEMENT_NAME, LABEL_PROPERTIES.PROPERTY_NAME FROM SYS.ALL_PG_ELEMENTS ELEMENTS INNER JOIN SYS.ALL_PG_ELEMENT_LABELS ELEMENT_LABELS ON ELEMENTS.ELEMENT_NAME = ELEMENT_LABELS.ELEMENT_NAME INNER JOIN SYS.ALL_PG_LABEL_PROPERTIES LABEL_PROPERTIES ON ELEMENT_LABELS.LABEL_NAME = LABEL_PROPERTIES.LABEL_NAME WHERE ELEMENTS.ELEMENT_KIND = 'EDGE' AND ELEMENTS.GRAPH_NAME = ? AND ELEMENTS.OWNER = ?");){
            preparedStatement.setString(1, this.graphName);
            preparedStatement.setString(2, this.graphOwner);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    String edgeTableName = rs.getString(1);
                    String property = rs.getString(2);
                    EdgeTable edgeTable = this.edgeTables.get(edgeTableName);
                    edgeTable.addProperty(property);
                    this.allEdgeProperties.add(property);
                }
            }
        }
    }

    private void fillEdgeObjects() throws SQLException {
        try (PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT ELEMENTS.ELEMENT_NAME, ELEMENTS.OBJECT_NAME, LABEL_NAME FROM SYS.ALL_PG_ELEMENTS ELEMENTS INNER JOIN SYS.ALL_PG_ELEMENT_LABELS ELEMENTS_LABELS ON ELEMENTS.ELEMENT_NAME = ELEMENTS_LABELS.ELEMENT_NAME WHERE ELEMENTS.ELEMENT_KIND = 'EDGE' AND ELEMENTS_LABELS.GRAPH_NAME = ? AND ELEMENTS.OBJECT_OWNER = ?");){
            preparedStatement.setString(1, this.graphName);
            preparedStatement.setString(2, this.graphOwner);
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    String edgeTableAlias = rs.getString(1);
                    String edgeTableName = rs.getString(2);
                    String edgeLabelName = rs.getString(3);
                    EdgeTable edgeTable = new EdgeTable(edgeTableName, edgeLabelName);
                    this.edgeTables.put(edgeTableAlias, edgeTable);
                }
            }
        }
        this.fetchSourceAndDestinationTableAndColumnNames();
        this.fetchEdgeColumnsIds();
        this.fetchEdgeProperties();
    }

    /*
     * Exception decompiling
     */
    public static Set<GraphName> getGraphNames(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, VertexTable> getVertexTables() {
        return this.vertexTables;
    }

    public Set<String> getAllVertexProperties() {
        return this.allVertexProperties;
    }

    public Map<String, EdgeTable> getEdgeTables() {
        return this.edgeTables;
    }

    public Set<String> getAllEdgeProperties() {
        return this.allEdgeProperties;
    }
}

