/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.config.LinkTemplate;

public class Vertex
extends Entity {
    @JsonCreator
    public Vertex(@JsonProperty(value="graphId") PgxId graphId, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="idType") IdType keyType, @JsonProperty(value="key") Object key) {
        super(graphId, tableName, keyType, key);
    }

    public Vertex(PgxId graphId, IdType idType, Object localId) {
        this(graphId, "V", idType, localId);
    }

    public Vertex(IdType idType, Object id) {
        this(null, idType, id);
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.VERTEX;
    }

    @Override
    public void injectLinks() {
        if (Objects.equals("V", this.tableName)) {
            Link selfLink = new Link(LinkRel.SELF, LinkTemplate.VERTEX_SELF.generateLink(new Object[0]));
            Link labelLink = new Link(LinkRel.RELATED, LinkTemplate.VERTEX_LABEL_SELF.generateLink(new Object[0]));
            Link neighborsLink = new Link(LinkRel.RELATED, LinkTemplate.VERTEX_NEIGHBORS.generateLink(new Object[0]));
            Link connectedEdgesLink = new Link(LinkRel.RELATED, LinkTemplate.CONNECTED_EDGES.generateLink(new Object[0]));
            this.addLinks(new Link[]{selfLink, labelLink, neighborsLink, connectedEdgesLink});
        } else {
            Link selfInTableLink = new Link(LinkRel.SELF, LinkTemplate.VERTEX_IN_TABLE_SELF.generateLink(new Object[0]));
            this.addLinks(new Link[]{selfInTableLink});
        }
    }

    @Override
    public final boolean isFromDefaultTable() {
        return Objects.equals("V", this.getTableName());
    }
}

