/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;

public class ChangeTrackingMap<K, V>
implements Iterable<ChangeSetEntry<K, V>> {
    private final Map<K, ChangeSetEntry<K, V>> changes = new HashMap<K, ChangeSetEntry<K, V>>();
    private int numAddedValues = 0;
    private int numModifiedValues = 0;
    private int numRemovedValues = 0;

    public Collection<ChangeSetEntry<K, V>> getChanges() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public Stream<ChangeSetEntry<K, V>> entriesStream() {
        return this.getChanges().stream();
    }

    public boolean canAdd(K key) {
        return !this.changes.containsKey(key);
    }

    public boolean canRemove(K key) {
        return this.isOfChangeType(key, ChangeType.REMOVE);
    }

    public boolean canModify(K key) {
        return this.isOfChangeType(key, ChangeType.ADD, ChangeType.MODIFY);
    }

    public Optional<V> trackChange(ChangeType type, K key, V value) {
        switch (type) {
            case ADD: {
                this.trackAdd(key, value);
                return Optional.empty();
            }
            case REMOVE: {
                this.trackRemove(key, value);
                return Optional.empty();
            }
            case MODIFY: {
                return Optional.of(value == null ? this.trackModify(key) : this.trackModify(key, value));
            }
        }
        throw new IllegalEnumConstantException((Enum)type);
    }

    public void trackAdd(K key, V value) {
        if (!this.canAdd(key)) {
            ChangeType changeType = this.changes.get(key).getChangeType();
            throw new ChangeTrackingException(ErrorMessages.getMessage((String)"CHANGE_TRACKING_MAP_COLLISION", (Object[])new Object[]{key, changeType}), changeType);
        }
        if (this.changes.put(key, new ChangeSetEntry<K, V>(ChangeType.ADD, key, value)) == null) {
            ++this.numAddedValues;
        }
    }

    public void trackRemove(K key) {
        this.trackRemove(key, null);
    }

    public void trackRemove(K key, V value) {
        if (!this.canRemove(key)) {
            ChangeType changeType = this.getChangeType(key);
            throw new ChangeTrackingException(ErrorMessages.getMessage((String)"CHANGE_TRACKING_MAP_COLLISION", (Object[])new Object[]{key, changeType}), changeType);
        }
        if (this.changes.put(key, new ChangeSetEntry<K, V>(ChangeType.REMOVE, key, value)) == null) {
            ++this.numRemovedValues;
        }
    }

    public V trackModify(K key) {
        if (!this.changes.containsKey(key)) {
            throw new IllegalArgumentException("No modify entry found for: " + key.toString());
        }
        if (!this.canModify(key)) {
            ChangeType changeType = this.getChangeType(key);
            throw new ChangeTrackingException(ErrorMessages.getMessage((String)"CHANGE_TRACKING_MAP_COLLISION", (Object[])new Object[]{key, changeType}), changeType);
        }
        return this.changes.get(key).getValue();
    }

    public V trackModify(K key, Supplier<V> defaultValueSupplier) {
        if (!this.changes.containsKey(key) && this.changes.put(key, new ChangeSetEntry<K, V>(ChangeType.MODIFY, key, defaultValueSupplier.get())) == null) {
            ++this.numModifiedValues;
        }
        return this.trackModify(key);
    }

    public V trackModify(K key, V defaultValue) {
        return (V)this.trackModify(key, (V)((Supplier<Object>)() -> defaultValue));
    }

    public boolean hasChangeFor(K key) {
        return this.changes.containsKey(key);
    }

    public ChangeSetEntry<K, V> reset(K key) {
        ChangeSetEntry<K, V> removedEntry = this.changes.remove(key);
        if (removedEntry != null) {
            this.updateCountForRemovedValue(removedEntry);
        }
        return removedEntry;
    }

    private void updateCountForRemovedValue(ChangeSetEntry<K, V> removedEntry) {
        switch (removedEntry.getChangeType()) {
            case ADD: {
                --this.numAddedValues;
                break;
            }
            case REMOVE: {
                --this.numRemovedValues;
                break;
            }
            case MODIFY: {
                --this.numModifiedValues;
                break;
            }
            default: {
                throw new IllegalArgumentException(removedEntry.getChangeType().toString());
            }
        }
    }

    public ChangeSetEntry<K, V> getChange(K key) {
        return this.changes.get(key);
    }

    public int getNumAddedValues() {
        return this.numAddedValues;
    }

    public int getNumModifiedValues() {
        return this.numModifiedValues;
    }

    public int getNumRemovedValues() {
        return this.numRemovedValues;
    }

    public ChangeType getChangeType(K key) {
        ChangeSetEntry<K, V> change = this.changes.get(key);
        return change == null ? null : change.getChangeType();
    }

    public V getValue(K key) {
        ChangeSetEntry<K, V> changeSetEntry = this.changes.get(key);
        return changeSetEntry == null ? null : (V)changeSetEntry.getValue();
    }

    public List<ChangeSetEntry<K, V>> getChangesByType(ChangeType type) {
        return this.entriesStream().filter(entry -> entry.getChangeType() == type).collect(Collectors.toList());
    }

    public int size() {
        return this.changes.size();
    }

    private boolean isOfChangeType(K key, ChangeType ... changeTypes) {
        ChangeType changeType;
        List<ChangeType> changeTypesList;
        return !this.changes.containsKey(key) || (changeTypesList = Arrays.asList(changeTypes)).contains(changeType = this.getChangeType(key));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeTrackingMap that = (ChangeTrackingMap)o;
        return Objects.equals(this.changes, that.changes);
    }

    public int hashCode() {
        return Objects.hash(this.changes);
    }

    public String toString() {
        return this.changes.toString();
    }

    @Override
    public Iterator<ChangeSetEntry<K, V>> iterator() {
        return this.getChanges().iterator();
    }

    public void forEachEntry(ChangeConsumer<K, V> consumer) {
        this.forEach(entry -> consumer.accept(((ChangeSetEntry)entry).changeType, ((ChangeSetEntry)entry).key, ((ChangeSetEntry)entry).value));
    }

    public static final class ChangeSetEntry<K, V> {
        private ChangeType changeType;
        private K key;
        private V value;

        private ChangeSetEntry() {
        }

        public ChangeSetEntry(ChangeType changeType, K key, V value) {
            this.changeType = changeType;
            this.key = key;
            this.value = value;
        }

        public ChangeType getChangeType() {
            return this.changeType;
        }

        public V getValue() {
            return this.value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        private void setChangeType(ChangeType changeType) {
            this.changeType = changeType;
        }

        private void setValue(V value) {
            this.value = value;
        }

        public void fixKey(Class<?> expectedKeyClass) throws IOException {
            if (this.key == null) {
                return;
            }
            if (this.key.getClass() != expectedKeyClass) {
                this.key = JsonUtil.reparseObject(this.key, expectedKeyClass);
            }
        }

        public String toString() {
            return "ChangeSetEntry{changeType=" + this.changeType + ", key=" + this.key + ", value=" + this.value + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeSetEntry that = (ChangeSetEntry)o;
            return this.changeType == that.changeType && Objects.equals(this.value, that.value) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.changeType, this.value, this.key);
        }
    }

    public static class ChangeTrackingException
    extends RuntimeException {
        private final ChangeType currentChangeType;

        public ChangeTrackingException(ChangeType currentChangeType) {
            this.currentChangeType = currentChangeType;
        }

        public ChangeTrackingException(String message, ChangeType currentChangeType) {
            super(message);
            this.currentChangeType = currentChangeType;
        }

        public ChangeType getCurrentChangeType() {
            return this.currentChangeType;
        }
    }

    public static interface ChangeConsumer<K, V> {
        public void accept(ChangeType var1, K var2, V var3);
    }
}

