/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.loaders.location.FileGraphLocation;
import oracle.pgx.loaders.location.GraphLocation;
import oracle.pgx.loaders.location.PgSqlGraphLocation;
import oracle.pgx.loaders.location.PgViewGraphLocation;

class GraphLocationModule
extends SimpleModule {
    GraphLocationModule() {
        super("GraphLocationModule", Version.unknownVersion());
        this.addDeserializer(GraphLocation.class, new GraphLocationDeserializer());
    }

    public static class GraphLocationDeserializer
    extends JsonDeserializer<GraphLocation> {
        public GraphLocation deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode rootNode = (JsonNode)p.readValueAsTree();
            JsonNode typeNode = rootNode.get("@type");
            GraphLocation.GraphLocationType graphLocationType = GraphLocation.GraphLocationType.fromTypeId(typeNode.asText());
            switch (graphLocationType) {
                case FILE_GRAPH_LOCATION: {
                    return JsonUtil.treeToValue((TreeNode)rootNode, FileGraphLocation.class);
                }
                case PG_VIEW_LOCATION: {
                    return JsonUtil.treeToValue((TreeNode)rootNode, PgViewGraphLocation.class);
                }
                case PG_SQL_LOCATION: {
                    return JsonUtil.treeToValue((TreeNode)rootNode, PgSqlGraphLocation.class);
                }
            }
            throw new IllegalEnumConstantException((Enum)graphLocationType);
        }
    }
}

