/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.shell.aargparse.impl;

import oracle.pgx.shell.aargparse.Argument;
import oracle.pgx.shell.aargparse.ArgumentAction;
import oracle.pgx.shell.aargparse.ArgumentConverter;
import oracle.pgx.shell.aargparse.impl.ArgumentParserImpl;

public class ArgumentImpl
implements Argument {
    private final String dest;
    private String helpString;
    private ArgumentAction action;
    private ArgumentConverter<?> converter;
    private Object defaultValue;
    private String shortForm;
    private String longForm;
    private String positionalForm;
    private int minArgs = 0;
    private int maxArgs = 1;

    public ArgumentImpl(ArgumentParserImpl parser, String ... flags) {
        this.dest = this.extractDest(flags);
        parser.doAdd(this);
    }

    private String extractDest(String ... flags) {
        if (flags == null || flags.length == 0) {
            throw new IllegalArgumentException("no flags provided");
        }
        for (String flag : flags) {
            if (flag == null) {
                throw new IllegalArgumentException("provided flag is null");
            }
            if (flag.indexOf(61) != -1 || flag.indexOf(45) >= 2) {
                throw new IllegalArgumentException("provided flags contains illegal character: " + flag);
            }
            if (flag.charAt(0) == '-') {
                if (flag.charAt(1) == '-') {
                    if (this.longForm != null) {
                        throw new IllegalStateException("another long form was given: " + this.longForm);
                    }
                    this.longForm = flag.substring(2);
                    continue;
                }
                if (this.shortForm != null) {
                    throw new IllegalStateException("another short form was given: " + this.shortForm);
                }
                this.shortForm = flag.substring(1);
                continue;
            }
            if (this.positionalForm != null) {
                throw new IllegalStateException("another positional form was given: " + this.positionalForm);
            }
            this.positionalForm = flag;
        }
        if (this.positionalForm != null) {
            return this.positionalForm;
        }
        if (this.longForm != null) {
            return this.longForm;
        }
        return this.shortForm;
    }

    @Override
    public String getDest() {
        return this.dest;
    }

    @Override
    public String getShortForm() {
        return this.shortForm;
    }

    @Override
    public String getLongForm() {
        return this.longForm;
    }

    @Override
    public String getPositionalForm() {
        return this.positionalForm;
    }

    @Override
    public int getMinArgs() {
        return this.minArgs;
    }

    @Override
    public int getMaxArgs() {
        return this.maxArgs;
    }

    public ArgumentConverter<?> getConverter() {
        return this.converter;
    }

    public ArgumentAction getAction() {
        return this.action;
    }

    @Override
    public Argument help(String helpString) {
        this.helpString = helpString;
        return this;
    }

    public String getHelp() {
        return this.helpString;
    }

    @Override
    public Argument action(ArgumentAction argumentAction) {
        this.action = argumentAction;
        return this;
    }

    @Override
    public <T> Argument type(ArgumentConverter<T> converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public Argument setDefault(Object defVal) {
        this.defaultValue = defVal;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Argument nargs(String pattern) {
        if ("?".equals(pattern)) {
            this.minArgs = 0;
            this.maxArgs = 1;
        } else if ("+".equals(pattern)) {
            this.minArgs = 1;
            this.maxArgs = Integer.MAX_VALUE;
        } else if ("*".equals(pattern)) {
            this.minArgs = 0;
            this.maxArgs = Integer.MAX_VALUE;
        } else {
            throw new IllegalArgumentException("unrecognized nargs pattern" + pattern);
        }
        return this;
    }
}

