/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Formatter;
import oracle.pgx.graphviz.library.PgqlParser;
import oracle.pgx.graphviz.library.QueryEnhancerUtils;
import oracle.pgx.graphviz.library.StringResultSet;
import oracle.pgx.graphviz.library.enhancer.Enhancer;
import oracle.pgx.graphviz.library.misc.MalformedQueryException;

public class QueryEnhancer<T> {
    public static final String QUERY_ENHANCER = "query-enhancer";
    public static final String QUERY_ENHANCEMENT = "enhancement";
    public static final String SIZE = "size";
    public static final String START = "start";
    @Nonnull
    protected Driver driver;
    @Nonnull
    private final Formatter<T> formatter;

    public QueryEnhancer(@Nonnull Driver driver, @Nonnull Formatter<T> formatter) throws PgqlException {
        this.driver = driver;
        this.formatter = formatter;
    }

    public void setDriver(@Nonnull Driver driver) {
        this.driver = driver;
    }

    @Nonnull
    public Driver getDriver() {
        return this.driver;
    }

    @Nonnull
    public Formatter<T> getFormatter() {
        return this.formatter;
    }

    protected T query(@Nonnull GraphQuery graphQuery, Map<String, Object> properties) throws PgqlException, IOException, SQLException {
        Enhancer enhancer = this.createEnhancer(graphQuery, properties);
        properties.put("enhancer", enhancer);
        EnhancedResultSet enhancedResultSet = this.driver.query(enhancer.getQuery().toString(), enhancer.getQuery().getGraphName().getName(), enhancer.getQuery().getGraphName().getSchemaName(), properties);
        return (T)this.formatter.format(enhancedResultSet, properties);
    }

    public Optional<T> execute(@Nonnull String queryString, String schema, String graphName, Map<String, Object> properties) throws IOException, SQLException, PgqlException {
        Optional<T> result;
        PgqlResult parseResult = PgqlParser.getParser().parse(queryString);
        if (!parseResult.isQueryValid()) {
            throw new MalformedQueryException(parseResult);
        }
        if (parseResult.getPgqlStatement().getStatementType() == StatementType.CREATE_PROPERTY_GRAPH) {
            return Optional.of(this.create(parseResult.getPgqlStatement(), properties));
        }
        if (parseResult.getPgqlStatement().getStatementType() == StatementType.DROP_PROPERTY_GRAPH) {
            return Optional.of(this.drop(parseResult.getPgqlStatement(), properties));
        }
        GraphQuery graphQuery = QueryEnhancerUtils.parseQuery(queryString, schema, graphName);
        switch (graphQuery.getQueryType()) {
            case SELECT: {
                result = Optional.of(this.query(graphQuery, properties));
                break;
            }
            case MODIFY: {
                result = Optional.of(this.modify(graphQuery, properties));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown query type: " + graphQuery.getQueryType().toString());
            }
        }
        return result;
    }

    public T create(@Nonnull PgqlStatement pgqlStatement, Map<String, Object> properties) throws PgqlException, SQLException, IOException {
        String ddlString = pgqlStatement.toString();
        return (T)this.formatter.format((EnhancedResultSet)new StringResultSet(this.driver.create(ddlString, properties)), properties);
    }

    public T drop(@Nonnull PgqlStatement pgqlStatement, Map<String, Object> properties) throws PgqlException, SQLException, IOException {
        String ddlString = pgqlStatement.toString();
        return (T)this.formatter.format((EnhancedResultSet)new StringResultSet(this.driver.drop(ddlString, properties)), properties);
    }

    public T modify(@Nonnull GraphQuery query, Map<String, Object> properties) throws PgqlException, SQLException, IOException {
        return (T)this.formatter.format((EnhancedResultSet)new StringResultSet(this.modify(query, null, properties)), properties);
    }

    public String modify(@Nonnull GraphQuery query, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        String queryString = query.toString();
        graphName = query.getGraphName().getName();
        return this.driver.modify(queryString, graphName, properties);
    }

    public Enhancer createEnhancer(@Nonnull String query, String schema, String graphName, Map<String, Object> properties) throws PgqlException, SQLException {
        GraphQuery graphQuery = QueryEnhancerUtils.parseQuery(query, schema, graphName);
        return this.createEnhancer(graphQuery, properties);
    }

    public Enhancer createEnhancer(@Nonnull GraphQuery query, Map<String, Object> properties) throws SQLException, PgqlException {
        String schema = query.getGraphName().getSchemaName();
        String graphName = query.getGraphName().getName().toString();
        return new Enhancer(query, this.driver.getGraph(schema, graphName, properties), this.driver.isDirectedSupported(), this.driver.supportsOneRowPerStep());
    }

    public void cleanUp() {
    }
}

