/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.api.PgqlResultSet;
import oracle.pgx.graphviz.driver.ResultSetCache;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Graph;
import oracle.pgx.graphviz.formatter.Table;
import oracle.pgx.graphviz.library.table.ResultSetTable;

public class TableOnlyResultSet
implements EnhancedResultSet {
    @Nonnull
    final ResultSet resultSet;
    @Nonnull
    private final String graphName;
    @Nullable
    private final String schema;
    @Nonnull
    private final List<String> header;
    @Nonnull
    private final String resultSetId;
    final int numResults;

    public TableOnlyResultSet(@Nonnull ResultSet resultSet, @Nonnull String graphName, @Nullable String schema, @Nonnull List<String> header, boolean supportsMultipleIterations) throws PgqlException {
        this.graphName = graphName;
        this.schema = schema;
        if (resultSet instanceof PgqlResultSet) {
            this.resultSet = resultSet;
            PgqlResultSet pgqlResultSet = (PgqlResultSet)this.resultSet;
            this.numResults = (int)pgqlResultSet.getNumResults();
            this.resultSetId = pgqlResultSet.getId();
        } else {
            ResultSetCache resultSetCache = (ResultSetCache)resultSet;
            this.resultSet = resultSetCache;
            this.numResults = resultSetCache.getNumResults();
            this.resultSetId = "";
        }
        this.header = header;
    }

    @Nullable
    public Graph createGraphRepresentation(int start, int size) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Graph createGraphRepresentation() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Table createTableRepresentation() {
        return new ResultSetTable(this.resultSet, this.header);
    }

    @Nonnull
    public String getGraphName() {
        return this.graphName;
    }

    @Nullable
    public String getGraphSchemaName() {
        return this.schema;
    }

    public boolean hasGraph() {
        return false;
    }

    public long getNumResults() {
        return this.numResults;
    }

    public String getResultSetId() {
        return this.resultSetId;
    }

    @Nonnull
    public ResultSet getResult() {
        return this.resultSet;
    }
}

