/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.autocompletion;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.editor.completion.PgqlCompletionContext;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompletionContext
implements PgqlCompletionContext {
    private static final Logger LOG = LoggerFactory.getLogger(CompletionContext.class);
    private final Driver driver;
    private final Map<String, Object> properties;
    private String graphName;

    CompletionContext(Driver driver, Map<String, Object> properties) {
        this.driver = driver;
        this.properties = properties;
        this.graphName = null;
    }

    CompletionContext(Driver driver, String graphName, Map<String, Object> properties) {
        this.driver = driver;
        this.graphName = graphName;
        this.properties = properties;
    }

    public List<String> getGraphNames() {
        try {
            return new ArrayList<String>(this.driver.getGraphs(this.properties).stream().map(g -> g.getGraphName()).collect(Collectors.toList()));
        }
        catch (SQLException | PgqlException e) {
            LOG.warn("could not retrieve graph names information", e);
            return Collections.emptyList();
        }
    }

    public List<String> getVertexProperties(String graphName) {
        if (graphName == null) {
            graphName = this.graphName;
        }
        try {
            return this.getPropertyNames(graphName, GraphInformation::getVertexProperties);
        }
        catch (SQLException | PgqlException e) {
            LOG.warn("could not retrieve vertex properties information", e);
            return Collections.emptyList();
        }
    }

    public List<String> getEdgeProperties(String graphName) {
        if (graphName == null) {
            graphName = this.graphName;
        }
        try {
            return this.getPropertyNames(graphName, GraphInformation::getEdgeProperties);
        }
        catch (SQLException | PgqlException e) {
            LOG.warn("could not retrieve edge properties information", e);
            return Collections.emptyList();
        }
    }

    private List<String> getPropertyNames(String graphName, Function<GraphInformation, Set<Property>> getter) throws SQLException, PgqlException {
        if (graphName == null) {
            graphName = this.graphName;
        }
        return getter.apply(this.driver.getGraph(null, graphName, this.properties)).stream().map(Property::getName).collect(Collectors.toList());
    }

    public List<String> getEdgeLabels(String graphName) {
        if (graphName == null) {
            graphName = this.graphName;
        }
        try {
            return this.driver.getGraph(null, graphName, this.properties).getEdgeLabels().stream().collect(Collectors.toList());
        }
        catch (SQLException | PgqlException e) {
            LOG.warn("could not retrieve edge labels information", e);
            return Collections.emptyList();
        }
    }

    public List<String> getVertexLabels(String graphName) {
        if (graphName == null) {
            graphName = this.graphName;
        }
        try {
            return this.driver.getGraph(null, graphName, this.properties).getVertexLabels().stream().collect(Collectors.toList());
        }
        catch (SQLException | PgqlException e) {
            LOG.warn("could not retrieve vertex labels information", e);
            return Collections.emptyList();
        }
    }
}

