/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyContext {
    private static Logger ms_log = LoggerFactory.getLogger(ModifyContext.class);
    private final boolean[] booleanOptionValues = new boolean[BooleanOption.values().length];
    private final String[] stringOptionValues = new String[StringOption.values().length];
    private final PgqlConnection pgqlConn;

    private ModifyContext(PgqlConnection pgqlConn) {
        this.pgqlConn = pgqlConn;
    }

    public static ModifyContext getModifyContext(PgqlConnection pgqlConn) {
        return new ModifyContext(pgqlConn);
    }

    public void resetOptions() {
        int i;
        for (i = 0; i < this.booleanOptionValues.length; ++i) {
            this.booleanOptionValues[i] = BooleanOption.values()[i].getDefaultValue(this.pgqlConn);
        }
        for (i = 0; i < this.stringOptionValues.length; ++i) {
            this.stringOptionValues[i] = StringOption.values()[i].getDefaultValue();
        }
    }

    public boolean getOption(BooleanOption option) {
        return this.booleanOptionValues[option.ordinal()];
    }

    public String getOption(StringOption option) {
        return this.stringOptionValues[option.ordinal()];
    }

    public void setOption(BooleanOption option, boolean value) {
        this.booleanOptionValues[option.ordinal()] = value;
    }

    public void setOption(StringOption option, String value) {
        this.stringOptionValues[option.ordinal()] = value;
    }

    public void setOptionsFromSystemProperties() {
        String val;
        String propName;
        int i;
        for (i = 0; i < this.booleanOptionValues.length; ++i) {
            block6: {
                propName = BooleanOption.values()[i].getSystemProperty();
                val = null;
                try {
                    val = System.getProperty(propName);
                }
                catch (Exception ex) {
                    if (!ms_log.isDebugEnabled()) break block6;
                    ms_log.debug("Error extracting system property [" + propName + "] " + ex.getMessage());
                }
            }
            if (val == null) continue;
            this.booleanOptionValues[i] = Boolean.parseBoolean(val);
        }
        for (i = 0; i < this.stringOptionValues.length; ++i) {
            block7: {
                propName = StringOption.values()[i].getSystemProperty();
                val = null;
                try {
                    val = System.getProperty(propName);
                }
                catch (Exception ex) {
                    if (!ms_log.isDebugEnabled()) break block7;
                    ms_log.debug("Error extracting system property [" + propName + "] " + ex.getMessage());
                }
            }
            if (val == null) continue;
            this.stringOptionValues[i] = val;
        }
    }

    public void setOptionsFromString(String optionsString) {
        String optionName;
        int i;
        for (i = 0; i < this.booleanOptionValues.length; ++i) {
            optionName = BooleanOption.values()[i].getName();
            if (optionsString.contains(optionName + "=T")) {
                this.booleanOptionValues[i] = true;
            }
            if (!optionsString.contains(optionName + "=F")) continue;
            this.booleanOptionValues[i] = false;
        }
        for (i = 0; i < this.stringOptionValues.length; ++i) {
            optionName = StringOption.values()[i].getName();
            Pattern pattern = Pattern.compile(".*" + optionName + "=\\{([^\\}]*)\\}.*");
            Matcher matcher = pattern.matcher(optionsString);
            if (!matcher.matches()) continue;
            this.stringOptionValues[i] = matcher.group(1);
        }
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer("");
        for (i = 0; i < this.booleanOptionValues.length; ++i) {
            s.append((Object)BooleanOption.values()[i]).append("=[").append(this.booleanOptionValues[i]).append("]\n");
        }
        for (i = 0; i < this.stringOptionValues.length; ++i) {
            s.append((Object)StringOption.values()[i]).append("=[").append(this.stringOptionValues[i]).append("]\n");
        }
        return s.toString();
    }

    public static enum StringOption {
        CREATE_PG_OPTIONS("CREATE_PG_OPTIONS", null, "oracle.pg.rdbms.pgql.createPgOptions");

        private final String name;
        private final String defaultValue;
        private final String systemProperty;

        private StringOption(String name, String defaultValue, String systemProperty) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.systemProperty = systemProperty;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getSystemProperty() {
            return this.systemProperty;
        }
    }

    public static enum BooleanOption {
        AUTO_COMMIT("AUTO_COMMIT", true, "oracle.pg.rdbms.pgql.autoCommit"),
        STREAMING("STREAMING", false, "oracle.pg.rdbms.pgql.streaming"),
        DELETE_CASCADE("DELETE_CASCADE", true, "oracle.pg.rdbms.pgql.deleteCascade"),
        CHECK_NULL_PROPS("CHECK_NULL_PROPS", true, "oracle.pg.rdbms.pgql.checkNullProps");

        private final String name;
        private final boolean defaultValue;
        private final String systemProperty;

        private BooleanOption(String name, boolean defaultValue, String systemProperty) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.systemProperty = systemProperty;
        }

        public String getName() {
            return this.name;
        }

        public boolean getDefaultValue(PgqlConnection pgqlConn) {
            switch (this) {
                case AUTO_COMMIT: {
                    try {
                        return !pgqlConn.getJdbcConnection().getAutoCommit();
                    }
                    catch (SQLException ex) {
                        throw new PgqlToSqlException(ex);
                    }
                }
            }
            return this.defaultValue;
        }

        public String getSystemProperty() {
            return this.systemProperty;
        }
    }
}

