/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.util.List;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.MetadataProvider;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlExecuteCallStatement;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlDropTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgsql.PgSqlQueryTranslator;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.metadata.PgViewMetadataCache;
import oracle.pg.rdbms.pgql.pgview.translation.ModifyTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.QueryTranslator;
import oracle.pgql.lang.Pgql;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.ddl.CallStatement;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.CreateSuperPropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.DropPropertyGraph;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.StatementType;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.Modification;
import oracle.pgql.lang.ir.modify.ModificationType;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.metadata.AbstractMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlTranslator {
    private static final Logger ms_log;
    private static Pgql pgql;
    public static final String MATCH_TABLE_NAME = "ORA$PTT_MATCH_QUERY";
    private final int queryBlockId;
    private final QueryContext ctx;
    private GraphQuery qg;
    private PgqlStatement stmt;
    private StringBuffer sqlBuff;
    private BindValueInfo bvInfo;
    public static final String GRAPH_NOT_SET_ERROR = "Graph name is not set for this PgqlStatement. Use setGraph method in PgqlConnection or specify a graph name in the query";
    private static PgViewMetadataCache metadataCache;
    protected boolean isCallStatement = false;

    private PgqlTranslator() {
        this.ctx = null;
        this.queryBlockId = -1;
    }

    private PgqlTranslator(QueryContext ctx) {
        this.ctx = ctx;
        this.queryBlockId = this.ctx.getNextQbId();
        this.qg = null;
        this.sqlBuff = new StringBuffer();
        this.isCallStatement = false;
        PgqlTranslator.initMetadataCache();
    }

    public static PgqlTranslator getPgqlTranslator(QueryContext ctx) {
        return new PgqlTranslator(ctx);
    }

    public static void initParser() {
        new PgqlTranslator();
    }

    private PgqlSqlQueryTrans buildPgViewSqlQueryTrans() {
        if (this.ctx.useIso) {
            throw new PgqlToSqlException("Isomorphism is not supported for PG views");
        }
        SelectQuery select = (SelectQuery)this.stmt;
        MetadataConnector metadataConnector = (MetadataConnector)PgqlTranslator.metadataCache.getGraphMetadata((PgqlConnection)this.ctx.pgqlConn, (String)this.ctx.schemaName, (String)this.ctx.graphName).first;
        String sqlQuery = QueryTranslator.translateQuery((GraphQuery)select, metadataConnector, this.ctx).prettyPrint();
        this.sqlBuff = new StringBuffer(sqlQuery);
        if (this.queryBlockId == 0) {
            this.processBindVariables();
        }
        return new PgqlSqlQueryTransImpl(this.sqlBuff, this.bvInfo.getSqlBvList(0));
    }

    private PgViewModifyTrans buildPgViewSqlModifyTrans() {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Generating Modify translations...");
        }
        if (this.ctx.useIso) {
            throw new PgqlToSqlException("Isomorphism is not supported for PG views");
        }
        MetadataConnector metadataConnector = (MetadataConnector)PgqlTranslator.metadataCache.getGraphMetadata((PgqlConnection)this.ctx.pgqlConn, (String)this.ctx.schemaName, (String)this.ctx.graphName).first;
        return ModifyTranslator.translateModify((ModifyQuery)this.qg, metadataConnector, this.bvInfo, this.ctx);
    }

    private PgqlSqlQueryTrans buildPgSqlSqlQueryTrans() {
        String sqlQuery = PgSqlQueryTranslator.translateQuery((GraphQuery)((SelectQuery)this.stmt), this.ctx, null, null);
        this.sqlBuff = new StringBuffer(sqlQuery);
        return new PgqlSqlQueryTransImpl(this.sqlBuff, this.bvInfo.getSqlBvList(0));
    }

    public void prepareTranslation(String pgqlStr, PgqlStatement stmt, BindValueInfo bvInfo) throws PgqlException, PgqlToSqlException {
        if (pgqlStr != null && stmt != null) {
            throw new PgqlToSqlException("Invalid input to translateQuery(): both pgqlStr and stmt are non-null");
        }
        this.clearDataStructures();
        this.parseStatement(pgqlStr, stmt);
        boolean pgmCreated = false;
        switch (this.stmt.getStatementType()) {
            case SELECT: 
            case GRAPH_MODIFY: {
                this.qg = (GraphQuery)this.stmt;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nGraph Query:\n" + this.qg.toString());
                }
                pgmCreated = this.updateGraphInfo(this.qg);
                this.setBvInfo(bvInfo);
                break;
            }
            case CREATE_PROPERTY_GRAPH: {
                CreatePropertyGraph cpg = (CreatePropertyGraph)this.stmt;
                pgmCreated = this.updateGraphInfo(cpg.getGraphName(), PgqlTranslator.getCreateType(cpg));
                break;
            }
            case CREATE_SUPER_PROPERTY_GRAPH: {
                CreateSuperPropertyGraph cspg = (CreateSuperPropertyGraph)this.stmt;
                pgmCreated = this.updateGraphInfo(cspg.getGraphName(), PgqlTranslator.getCreateType((CreatePropertyGraph)cspg));
                break;
            }
            case DROP_PROPERTY_GRAPH: {
                pgmCreated = this.updateGraphInfo(((DropPropertyGraph)this.stmt).getGraphName(), null);
                break;
            }
            case CALL: {
                this.isCallStatement = true;
            }
        }
        if (pgmCreated) {
            this.parseStatement(pgqlStr, stmt);
        }
        if (this.stmt.getStatementType() == StatementType.GRAPH_MODIFY && !this.ctx.isModifySupported()) {
            throw new PgqlToSqlException("INSERT/UPDATE/DELETE is only available for 18C and later versions");
        }
    }

    public PgqlSqlTrans buildTranslation() {
        switch (this.stmt.getStatementType()) {
            case SELECT: {
                if (this.ctx.graphType == GraphType.PG_VIEWS) {
                    return this.buildPgViewSqlQueryTrans();
                }
                if (this.ctx.graphType != GraphType.PG_SQL) break;
                return this.buildPgSqlSqlQueryTrans();
            }
            case GRAPH_MODIFY: {
                if (this.ctx.graphType != GraphType.PG_VIEWS) break;
                return this.buildPgViewSqlModifyTrans();
            }
            case CREATE_PROPERTY_GRAPH: {
                CreatePropertyGraph cpg = (CreatePropertyGraph)this.stmt;
                GraphType graphType = PgqlTranslator.getCreateType(cpg);
                if (graphType == GraphType.PG_VIEWS || graphType == GraphType.PG_SQL) {
                    return new PgqlSqlCreateTransImpl(cpg.getGraphName().getSchemaName(), cpg.getGraphName().getName(), new Object[]{cpg});
                }
            }
            case CREATE_SUPER_PROPERTY_GRAPH: {
                CreateSuperPropertyGraph cspg = (CreateSuperPropertyGraph)this.stmt;
                if (PgqlTranslator.getCreateType((CreatePropertyGraph)cspg) != GraphType.PG_VIEWS) {
                    throw new PgqlToSqlException("BASE GRAPHS clause can only be used in combination with OPTIONS (PG_VIEW)");
                }
                return new PgqlSqlCreateTransImpl(cspg.getGraphName().getSchemaName(), cspg.getGraphName().getName(), new Object[]{cspg});
            }
            case DROP_PROPERTY_GRAPH: {
                DropPropertyGraph dpg = (DropPropertyGraph)this.stmt;
                return new PgqlSqlDropTransImpl(dpg.getGraphName().getSchemaName(), dpg.getGraphName().getName(), null);
            }
            case CALL: {
                return new PgqlExecuteCallStatement(this.ctx.pgqlConn, (CallStatement)this.stmt);
            }
        }
        throw new PgqlToSqlException("Unsupported statement type:" + this.stmt.getStatementType());
    }

    private boolean updateGraphInfo(GraphQuery graphQuery) {
        SchemaQualifiedName graphName = graphQuery.getGraphName();
        if (graphQuery.getStatementType() == StatementType.GRAPH_MODIFY) {
            for (Modification m : ((ModifyQuery)graphQuery).getModifications()) {
                SchemaQualifiedName insertGraphName;
                if (m.getModificationType() != ModificationType.INSERT || (insertGraphName = ((InsertClause)m).getGraphName()) == null) continue;
                if (graphQuery.getGraphPattern() != null && !insertGraphName.equals((Object)graphName)) {
                    throw new PgqlToSqlException("Graph specified in INTO clause and MATCH ON clause should be the same");
                }
                graphName = insertGraphName;
            }
        }
        return this.updateGraphInfo(graphName, null);
    }

    private boolean updateGraphInfo(SchemaQualifiedName sqGraphName, GraphType createType) {
        String graphName;
        String schemaName = sqGraphName == null || sqGraphName.getSchemaName() == null ? this.ctx.pgqlConn.getSchema() : sqGraphName.getSchemaName();
        if (sqGraphName == null || sqGraphName.getName() == null) {
            if (this.ctx.pgqlConn.getGraph() == null) {
                throw new PgqlToSqlException(GRAPH_NOT_SET_ERROR);
            }
            graphName = this.ctx.pgqlConn.getGraph();
        } else {
            graphName = sqGraphName.getName();
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Updating graph info:\n    schemaName=[" + schemaName + "]\n     graphName=[" + graphName + "]\n");
        }
        return this.ctx.updateGraphInfo(schemaName, graphName, createType);
    }

    private void clearDataStructures() {
        this.stmt = null;
        this.qg = null;
        this.sqlBuff = new StringBuffer();
        this.bvInfo = null;
    }

    private void parseStatement(String pgqlStr, PgqlStatement stmt) throws PgqlException, PgqlToSqlException {
        if (pgqlStr != null && stmt != null) {
            throw new PgqlToSqlException("Invalid input to parseStatement(): both pgqlStr and stmt are non-null");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nPGQL Query String:\n" + pgqlStr);
        }
        if (pgqlStr != null) {
            PgqlResult res;
            String errorMsgs;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nObtaining PgqlStatement from PGQL string");
            }
            if ((errorMsgs = (res = pgql.parse(pgqlStr, (AbstractMetadataProvider)new MetadataProvider(this.ctx.pgqlConn, metadataCache))).getErrorMessages()) != null && errorMsgs.length() > 0 && !res.isQueryValid()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("\nErrors:\n" + errorMsgs);
                }
                throw new PgqlToSqlException(errorMsgs);
            }
            this.stmt = res.getPgqlStatement();
        } else {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("\nUsing passed-in Statement");
            }
            this.stmt = stmt;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("\nPGQL PgqlStatement:\n" + this.stmt);
        }
    }

    private void setBvInfo(BindValueInfo bvInfo) {
        this.bvInfo = bvInfo;
    }

    private void processBindVariables() {
        this.sqlBuff = new StringBuffer(this.bvInfo.processBindVariables(this.sqlBuff.toString(), 0));
    }

    private static GraphType getCreateType(CreatePropertyGraph cpg) {
        String option;
        List options = cpg.getOptions();
        if (options == null) {
            throw new PgqlToSqlException("Graph type missing. Please provide a graph type in the OPTIONS clause, for example: CREATE PROPERTY GRAPH ... OPTIONS ( PG_VIEW )");
        }
        if (options.size() != 1) {
            throw new PgqlToSqlException("Only allowed options are one of {PG_PGQL, PG_SQL})");
        }
        switch (option = ((String)options.get(0)).toUpperCase()) {
            case "PG_SCHEMA": {
                throw new PgqlToSqlException("PG_SCHEMA graphs are no longer supported");
            }
            case "PG_VIEW": 
            case "PG_PGQL": {
                return GraphType.PG_VIEWS;
            }
            case "PG_SQL": {
                return GraphType.PG_SQL;
            }
        }
        throw new PgqlToSqlException("Unknown option in CREATE PROPERTY GRAPH: " + option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initMetadataCache() {
        if (metadataCache != null) return;
        Class<PgViewMetadataCache> clazz = PgViewMetadataCache.class;
        synchronized (PgViewMetadataCache.class) {
            if (metadataCache != null) return;
            metadataCache = new PgViewMetadataCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void clearGraphMetadataCache(PgqlConnection pgqlConn) {
        PgqlTranslator.initMetadataCache();
        metadataCache.clear(pgqlConn.getJdbcConnection());
    }

    static void disableGraphMetadataCache(PgqlConnection pgqlConn) {
        PgqlTranslator.initMetadataCache();
        metadataCache.disable(pgqlConn.getJdbcConnection());
    }

    static void enableGraphMetadataCache(PgqlConnection pgqlConn) {
        PgqlTranslator.initMetadataCache();
        metadataCache.enable(pgqlConn.getJdbcConnection());
    }

    static void setGraphMetadataCacheMaxCapacity(PgqlConnection pgqlConn, int maxCapacity) {
        PgqlTranslator.initMetadataCache();
        metadataCache.setMaxCapacity(pgqlConn.getJdbcConnection(), maxCapacity);
    }

    static void deleteGraphMetadata(Connection conn, String graphSchema, String graphName) {
        PgqlTranslator.initMetadataCache();
        metadataCache.deleteGraphMetadata(conn, graphSchema, graphName);
    }

    public static boolean containsGraphMetadata(Connection conn, String graphSchema, String graphName) {
        PgqlTranslator.initMetadataCache();
        boolean inCache = metadataCache.containsKey(conn, graphSchema, graphName);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Graph is " + (inCache ? "" : "not ") + "in cache");
        }
        return inCache;
    }

    static {
        block2: {
            ms_log = LoggerFactory.getLogger(PgqlTranslator.class);
            pgql = null;
            try {
                pgql = new Pgql();
            }
            catch (PgqlException ex) {
                if (!ms_log.isDebugEnabled()) break block2;
                ms_log.debug("\nFailed to initialize Pgql instance");
            }
        }
    }
}

