/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.pgview.translation.expression.ElementInsertion;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;

public class InsertionBlock
extends TableExpression {
    public boolean hasMatchTable;
    private final Set<String> declaredVariables;
    private final List<String> selectVariables;
    private final List<String> declareVariables;
    private final List<ElementInsertion> insertions;
    private final Map<String, Integer> insertionsVariables;

    public InsertionBlock(boolean hasMatchTable) {
        this.hasMatchTable = hasMatchTable;
        this.declaredVariables = new HashSet<String>();
        this.declareVariables = new ArrayList<String>();
        this.selectVariables = new ArrayList<String>();
        this.insertions = new ArrayList<ElementInsertion>();
        this.insertionsVariables = new HashMap<String, Integer>();
    }

    public void addVariable(String variableName, String tableName, String column, boolean isMatchVariable) {
        if (isMatchVariable) {
            this.selectVariables.add(variableName);
        }
        if (!this.declaredVariables.contains(variableName)) {
            this.declareVariables.add("  " + variableName + "  " + tableName + "." + column + "%type;\n");
            this.declaredVariables.add(variableName);
        }
    }

    public void addInsert(ElementInsertion insert) {
        this.insertions.add(insert);
        this.insertionsVariables.put(insert.getVariableName(), this.insertions.size() - 1);
        insert.addVariablesToBlock(this);
    }

    public ElementInsertion checkDuplicate(String variableName) {
        ElementInsertion duplicate = null;
        if (this.insertionsVariables.containsKey(variableName)) {
            duplicate = this.insertions.get(this.insertionsVariables.get(variableName));
            duplicate.setDuplicate();
        }
        return duplicate;
    }

    @Override
    public String prettyPrint() {
        String inserts = this.insertions.stream().map(ElementInsertion::prettyPrint).collect(Collectors.joining());
        String declares = String.join((CharSequence)"", this.declareVariables);
        if (this.hasMatchTable) {
            String selectProperties = String.join((CharSequence)", ", this.selectVariables);
            return "DECLARE\n  curs  SYS_REFCURSOR;\n  cnt   NUMBER := 0;\n" + declares + "BEGIN\n  open curs for\n    " + DbmsUtils.escapeAndEnquoteLiteral("SELECT " + selectProperties + "\n     FROM " + "ORA$PTT_MATCH_QUERY", false) + ";\n  fetch curs into " + selectProperties + ";\n  while curs%FOUND loop\n" + inserts + "    fetch curs into " + selectProperties + ";\n  end loop;\n  close curs;\n  ? := cnt;\nEND;\n";
        }
        return "DECLARE\n  cnt   NUMBER := 0;\n" + declares + "BEGIN\n" + inserts + "  ? := cnt;\nEND;\n";
    }
}

