/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import oracle.ons.ConfigurationException;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;

public class ConfigurationFactory {
    private final Map<String, ONSConfiguration.NodeList> nodes = new HashMap<String, ONSConfiguration.NodeList>();
    private String wallet = null;
    private char[] walletPassword = null;
    private int configurationKey = 0;
    private boolean isLocal = false;
    private int port = 0;
    private String formFactorPath = null;
    private String formFactorFile = null;

    public ConfigurationFactory addNode(String hostname, int port, String list) {
        this.nodes.computeIfAbsent((String)list, (Function<String, ONSConfiguration.NodeList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Loracle/ons/ONSConfiguration$NodeList;)()).nodeList.add(new NodeAddress(hostname, port));
        return this;
    }

    public ConfigurationFactory addNode(String hostname, int port) {
        this.addNode(hostname, port, "default");
        return this;
    }

    public ConfigurationFactory setMaxConnections(String list, int value) {
        this.nodes.computeIfAbsent((String)list, (Function<String, ONSConfiguration.NodeList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Loracle/ons/ONSConfiguration$NodeList;)()).maxConnections = value;
        return this;
    }

    public ConfigurationFactory setDefaultMaxConnections(int value) {
        return this.setMaxConnections("default", value);
    }

    public ConfigurationFactory setStandbyList(String list) {
        this.nodes.computeIfAbsent((String)list, (Function<String, ONSConfiguration.NodeList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Loracle/ons/ONSConfiguration$NodeList;)()).active = false;
        return this;
    }

    public ConfigurationFactory setWallet(String wallet) {
        this.wallet = wallet;
        return this;
    }

    public ConfigurationFactory setWalletPassword(char[] walletPassword) {
        this.walletPassword = walletPassword;
        return this;
    }

    public ConfigurationFactory setConfigurationKey(int configurationKey) {
        this.configurationKey = configurationKey;
        return this;
    }

    public ConfigurationFactory setLocal(boolean isLocal) {
        this.isLocal = isLocal;
        return this;
    }

    public ConfigurationFactory setLocalPort(int port) {
        this.isLocal = port != 0;
        this.port = port;
        return this;
    }

    @Deprecated
    public ConfigurationFactory setFormFactor(String formFactor) {
        return this;
    }

    public ConfigurationFactory setFormFactorPath(String formFactorPath) {
        this.formFactorPath = formFactorPath;
        return this;
    }

    public ConfigurationFactory setFormFactorFile(String formFactorFile) {
        this.formFactorFile = formFactorFile;
        return this;
    }

    public ONSConfiguration createConfig() throws IOException {
        ONSConfiguration configuration = new ONSConfiguration();
        if (this.isLocal) {
            configuration.securityScheme = 3;
            if (this.formFactorFile == null && this.formFactorPath == null) {
                throw new ConfigurationException("FormFactor file required for local configuration");
            }
            if (this.port == 0) {
                throw new ConfigurationException("Local port required for local configuration");
            }
            ONSConfiguration.NodeList localConfig = new ONSConfiguration.NodeList("local");
            localConfig.active = true;
            localConfig.nodeList.add(new NodeAddress("localhost", this.port));
            localConfig.maxConnections = 1;
            configuration.nodes.put(localConfig.publicId, localConfig);
            configuration.ignoreScan = true;
        } else {
            for (Map.Entry<String, ONSConfiguration.NodeList> nodelist : this.nodes.entrySet()) {
                ONSConfiguration.NodeList copy = new ONSConfiguration.NodeList(nodelist.getKey());
                copy.nodeList.addAll(nodelist.getValue().nodeList);
                copy.maxConnections = nodelist.getValue().maxConnections;
                copy.active = nodelist.getValue().active;
                copy.publicId = nodelist.getKey();
                configuration.nodes.put(copy.publicId, copy);
            }
            if (this.wallet != null) {
                configuration.securityScheme = 1;
                configuration.keyFile = this.wallet;
                configuration.keyFilePassword = this.walletPassword;
                this.walletPassword = null;
            }
            configuration.updateSSLSocketFactory();
        }
        configuration.setConfigurationUniqueKey(this.configurationKey);
        return configuration;
    }

    public NotificationNetwork createNetwork() throws IOException {
        return this.createConfig().getNetwork();
    }
}

