/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.jdbc.OracleConnection;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcHintClause;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsPreparedStatement;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsStatement;

public class PgqlJdbcRdbmsConnection
implements Connection {
    private OracleConnection oraConn;
    private PgqlConnection pgqlConn;
    private boolean isAutoCommit = false;

    public PgqlJdbcRdbmsConnection(OracleConnection oraConn) {
        if (oraConn == null) {
            throw new IllegalArgumentException("OracleConnection oraConn must not be null");
        }
        try {
            oraConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.oraConn = oraConn;
        this.pgqlConn = PgqlConnection.getConnection((Connection)oraConn);
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("connection is already closed");
        }
    }

    public OracleConnection getOraConnection() {
        return this.oraConn;
    }

    public PgqlConnection getPgqlConnection() {
        return this.pgqlConn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new PgqlJdbcRdbmsStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String pgql) throws SQLException {
        this.checkClosed();
        PgqlJdbcHintClause hintClause = PgqlJdbcHintClause.parse(pgql);
        if (hintClause.getIsSql()) {
            return this.oraConn.prepareStatement(pgql);
        }
        return new PgqlJdbcRdbmsPreparedStatement(this, pgql, hintClause);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        return this.oraConn.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return this.oraConn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        this.isAutoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.isAutoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.oraConn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.oraConn.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.oraConn.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.oraConn == null || this.oraConn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.oraConn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.oraConn.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.oraConn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.oraConn.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.oraConn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        this.oraConn.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.oraConn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.oraConn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.oraConn.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.oraConn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return this.oraConn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        this.oraConn.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        this.oraConn.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.oraConn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return this.oraConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        return this.oraConn.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.oraConn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.oraConn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return this.oraConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return this.oraConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return this.oraConn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return this.oraConn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkClosed();
        return this.oraConn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.oraConn != null) {
            this.oraConn.setClientInfo(name, value);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.oraConn != null) {
            this.oraConn.setClientInfo(properties);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return this.oraConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this.oraConn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return this.oraConn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        return this.oraConn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.oraConn.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.oraConn.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkClosed();
        this.oraConn.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        this.oraConn.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        return this.oraConn.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        return (T)this.oraConn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return this.oraConn.isWrapperFor(iface);
    }
}

