/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsConnection;

public class PgqlJdbcRdbmsDataSource
implements DataSource {
    private final OracleDataSource oracleDs = new OracleDataSource();

    @Override
    public Connection getConnection() throws SQLException {
        OracleConnection conn = (OracleConnection)this.oracleDs.getConnection();
        return new PgqlJdbcRdbmsConnection(conn);
    }

    public synchronized void setURL(String url) {
        String oracleJdbcUrl = url.replace(":pgql:@", ":thin:@");
        this.oracleDs.setURL(oracleJdbcUrl);
    }

    public synchronized void setUser(String userName) {
        this.oracleDs.setUser(userName);
    }

    public synchronized void setPassword(String password) {
        this.oracleDs.setPassword(password);
    }

    public synchronized String getURL() throws SQLException {
        return this.oracleDs.getURL();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.oracleDs.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.oracleDs.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.oracleDs.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        OracleConnection conn = (OracleConnection)this.oracleDs.getConnection(username, password);
        return new PgqlJdbcRdbmsConnection(conn);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.oracleDs.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.oracleDs.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.oracleDs.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.oracleDs.getLoginTimeout();
    }
}

