/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import oracle.pgx.common.types.IdType;

public class PartitionedId {
    private final String provider;
    private final String key;

    public PartitionedId(String provider, String key) {
        this.provider = provider;
        this.key = key;
    }

    public String getTableName() {
        return this.provider;
    }

    public Object getKey(IdType type) {
        switch (type) {
            case LONG: {
                return Long.parseLong(this.key);
            }
            case INTEGER: {
                return Integer.parseInt(this.key);
            }
            case STRING: {
                return this.key;
            }
        }
        throw new UnsupportedOperationException("unsupported id type " + type);
    }

    public static String createPartitionedId(String tableName, Object ... keyValues) {
        if (keyValues.length == 1) {
            return PartitionedId.escapeIdPart(tableName) + '(' + PartitionedId.escapeIdPart(keyValues[0].toString()) + ')';
        }
        throw new UnsupportedOperationException("composite keys unsupported");
    }

    private static String escapeIdPart(String s) {
        if (s.contains("\"") || s.contains("(") || s.contains(",") || s.contains(")")) {
            return '\"' + s.replace("\"", "\"\"") + '\"';
        }
        return s;
    }

    public static PartitionedId parse(String partitionedId) {
        int length = partitionedId.length();
        String providerName = PartitionedId.parseValue(partitionedId, 0, length);
        if (providerName == null || length == 0) {
            return null;
        }
        int providerNameLength = providerName.length() + (partitionedId.charAt(0) == '\"' ? 2 + PartitionedId.numDoubleQuotes(providerName) : 0);
        if (providerNameLength == length || partitionedId.charAt(providerNameLength) != '(' || partitionedId.charAt(length - 1) != ')') {
            return null;
        }
        int startOfKey = providerNameLength + 1;
        String key = PartitionedId.parseValue(partitionedId, startOfKey, length);
        if (key == null) {
            return null;
        }
        int keyLength = key.length() + (partitionedId.charAt(startOfKey) == '\"' ? 2 + PartitionedId.numDoubleQuotes(key) : 0);
        if (providerNameLength + keyLength + 2 != length) {
            return null;
        }
        return new PartitionedId(providerName, key);
    }

    private static String parseValue(String partitionedId, int begin, int length) {
        if (length == 0) {
            return "";
        }
        char c = partitionedId.charAt(begin);
        if (c == '\"') {
            int i = begin + 1;
            boolean done = false;
            while (!done && i < length) {
                if (partitionedId.charAt(i) == '\"') {
                    if (++i < length && partitionedId.charAt(i) == '\"') {
                        ++i;
                        continue;
                    }
                    done = true;
                    continue;
                }
                ++i;
            }
            if (partitionedId.charAt(i - 1) != '\"' || begin == i - 1) {
                return null;
            }
            String value = partitionedId.substring(begin + 1, i - 1).replace("\"\"", "\"");
            if (!(value.contains("\"") || value.contains("(") || value.contains(",") || value.contains(")"))) {
                return null;
            }
            return value;
        }
        int i = begin;
        while (c != '\"' && c != '(' && c != ',' && c != ')' && ++i != length) {
            c = partitionedId.charAt(i);
        }
        return partitionedId.substring(begin, i);
    }

    private static int numDoubleQuotes(String value) {
        return (int)value.chars().filter(c -> c == 34).count();
    }
}

