/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.types.Types;

public enum ReturnType implements Type
{
    INTEGER(Integer.class),
    LONG(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class),
    BOOLEAN(Boolean.class),
    STRING(String.class),
    DATE(Date.class),
    VOID(Void.class);

    private static final Map<String, ReturnType> ALIASES;
    private final Class<?> typeClass;

    public static ReturnType getTypeFor(Class<?> typeClass) {
        return (ReturnType)Types.getByTypeClass((Type[])ReturnType.values(), typeClass);
    }

    @JsonCreator
    public static ReturnType parseReturnType(String input) {
        return Types.parse(ReturnType.class, input, ALIASES);
    }

    private ReturnType(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    static {
        ALIASES = new HashMap<String, ReturnType>();
        ALIASES.put("INT", INTEGER);
    }
}

