/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import oracle.pgx.common.util.AutoCloseableHelper;

public abstract class AbstractResourceCollection<E extends Exception, T extends AutoCloseable>
extends AbstractCollection<T>
implements AutoCloseable {
    private final Class<E> exceptionClass;
    private final Collection<T> closeables = new ConcurrentLinkedDeque<T>();

    AbstractResourceCollection(Class<E> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Override
    public final Iterator<T> iterator() {
        return new DisallowRemovalIterator(this.closeables.iterator());
    }

    @Override
    public void close() throws E {
        try {
            AutoCloseableHelper.closeAll(this.exceptionClass, this.closeables);
        }
        finally {
            this.closeables.clear();
        }
    }

    @Override
    public final boolean add(T resource) {
        return this.closeables.add(resource);
    }

    @Override
    public final int size() {
        return this.closeables.size();
    }

    private class DisallowRemovalIterator
    implements Iterator<T> {
        private Iterator<T> actualIterator;

        private DisallowRemovalIterator(Iterator<T> actualIterator) {
            this.actualIterator = actualIterator;
        }

        @Override
        public boolean hasNext() {
            return this.actualIterator.hasNext();
        }

        @Override
        public T next() {
            return (AutoCloseable)this.actualIterator.next();
        }
    }
}

