/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import oracle.pgx.common.util.MemoryResource;

public final class AutoCloseableHelper {
    private AutoCloseableHelper() {
    }

    public static void closeAll(AutoCloseable ... closeables) {
        AutoCloseableHelper.closeAll(RuntimeException.class, closeables);
    }

    public static void closeAll(MemoryResource ... closeables) {
        AutoCloseableHelper.closeAll(RuntimeException.class, (AutoCloseable[])closeables);
    }

    public static <E extends Exception> void closeAll(Class<E> exceptionClass, AutoCloseable ... closeables) throws E {
        if (closeables != null) {
            AutoCloseableHelper.closeAll(exceptionClass, Arrays.asList(closeables));
        }
    }

    public static void closeAll(Iterable<? extends MemoryResource> closeables) {
        AutoCloseableHelper.closeAll(RuntimeException.class, closeables);
    }

    public static <E extends Exception> void closeAll(Class<E> exceptionClass, Iterable<? extends AutoCloseable> closeables) throws E {
        Throwable throwable = AutoCloseableHelper.closeQuietly(closeables);
        if (throwable != null) {
            AutoCloseableHelper.propagateThrowable(exceptionClass, throwable);
        }
    }

    @SafeVarargs
    public static void closeAll(Iterable<? extends MemoryResource> ... closeables) {
        AutoCloseableHelper.closeAll(RuntimeException.class, closeables);
    }

    @SafeVarargs
    public static <E extends Exception> void closeAll(Class<E> exceptionClass, Iterable<? extends AutoCloseable> ... closeables) throws E {
        if (closeables == null) {
            return;
        }
        Optional<Throwable> throwable = Arrays.stream(closeables).filter(Objects::nonNull).map(AutoCloseableHelper::closeQuietly).filter(Objects::nonNull).reduce(AutoCloseableHelper::combineThrowables);
        if (throwable.isPresent()) {
            AutoCloseableHelper.propagateThrowable(exceptionClass, throwable.get());
        }
    }

    public static void closeAll(MemoryResource[] ... closeables) {
        AutoCloseableHelper.closeAll(RuntimeException.class, (AutoCloseable[][])closeables);
    }

    public static <E extends Exception> void closeAll(Class<E> exceptionClass, AutoCloseable[] ... closeables) throws E {
        if (closeables == null) {
            return;
        }
        Optional<Throwable> throwable = Arrays.stream(closeables).filter(Objects::nonNull).map(closeableArray -> AutoCloseableHelper.closeQuietly(Arrays.asList(closeableArray))).filter(Objects::nonNull).reduce(AutoCloseableHelper::combineThrowables);
        if (throwable.isPresent()) {
            AutoCloseableHelper.propagateThrowable(exceptionClass, throwable.get());
        }
    }

    @Nullable
    private static Throwable closeQuietly(Iterable<? extends AutoCloseable> closeables) {
        if (closeables == null) {
            return null;
        }
        Throwable throwable = null;
        for (AutoCloseable autoCloseable : closeables) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Throwable t) {
                throwable = AutoCloseableHelper.combineThrowables(t, throwable);
            }
        }
        return throwable;
    }

    private static RuntimeException propagate(Throwable throwable) {
        AutoCloseableHelper.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    private static void throwIfUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private static <X extends Throwable> void propagateIfPossible(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null) {
            if (declaredType.isInstance(throwable)) {
                throw (Throwable)declaredType.cast(throwable);
            }
            AutoCloseableHelper.throwIfUnchecked(throwable);
        }
    }

    private static <E extends Exception> void propagateThrowable(Class<E> exceptionClass, Throwable throwable) throws E {
        AutoCloseableHelper.propagateIfPossible(throwable, exceptionClass);
        AutoCloseableHelper.propagate(throwable);
    }

    private static Throwable combineThrowables(Throwable additional, Throwable existing) {
        if (existing == null) {
            existing = additional;
        } else if (additional != existing) {
            existing.addSuppressed(additional);
        }
        return existing;
    }
}

