/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.util.ErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessages
implements ErrorMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorMessages.class);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("error_messages");

    public static String getMessage(String key, Object ... params) {
        try {
            return MessageFormat.format(MESSAGES.getString(key), params);
        }
        catch (MissingResourceException e) {
            LOG.error("cannot load message " + key + " from classpath");
            return "!" + key + "!";
        }
    }

    public static <T extends Throwable> void throwException(Function<String, T> exceptionFactory, String key, Object ... params) throws T {
        String message = ErrorMessages.getMessage(key, params);
        throw (Throwable)exceptionFactory.apply(message);
    }

    public static void requireNonNull(Object obj, String field) {
        if (obj == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("PARAMETER_IS_REQUIRED", field));
        }
    }

    public static String getPropertyNotFoundMessage(EntityType entityType, String propertyName, String graphName) {
        if (entityType == EntityType.VERTEX) {
            return ErrorMessages.getMessage("NODE_PROPERTY_NOT_FOUND", propertyName, graphName);
        }
        if (entityType == EntityType.EDGE) {
            return ErrorMessages.getMessage("EDGE_PROPERTY_NOT_FOUND", propertyName, graphName);
        }
        return ErrorMessages.getMessage("PROPERTY_NOT_FOUND", propertyName, graphName);
    }

    public static OptionalExceptionThrower getOptionalExceptionThrower(boolean isIgnoreIncompatibleBackendOperations) {
        if (isIgnoreIncompatibleBackendOperations) {
            return new ExceptionLogger();
        }
        return new ExceptionThrower();
    }

    public static class ExceptionLogger
    implements OptionalExceptionThrower {
        @Override
        public <T extends Exception> void logOrThrow(Function<String, T> exceptionFactory, String text) throws T {
            LOG.warn(text);
        }
    }

    public static class ExceptionThrower
    implements OptionalExceptionThrower {
        @Override
        public <T extends Exception> void logOrThrow(Function<String, T> exceptionFactory, String text) throws T {
            throw (Exception)exceptionFactory.apply(text);
        }
    }

    public static interface OptionalExceptionThrower {
        public <T extends Exception> void logOrThrow(Function<String, T> var1, String var2) throws T;

        default public <T extends Exception> void logOrThrow(Function<String, T> exceptionFactory, String key, Object ... params) throws T {
            String message = ErrorMessages.getMessage(key, params);
            this.logOrThrow(exceptionFactory, message);
        }

        default public void logOrThrow(String key, Object ... params) {
            this.logOrThrow(UnsupportedOperationException::new, key, params);
        }
    }
}

