/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Reader;
import oracle.pgx.common.util.ErrorMessages;

public class SecureLineReader
implements AutoCloseable {
    private Reader in;
    private Object lock;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;
    private static final int MAX_LINE_SIZE = 0x3FFFFFFF;

    public SecureLineReader(Reader in) {
        this.lock = in;
        this.in = in;
        this.cb = new char[defaultCharBufferSize];
        this.nChars = 0;
        this.nextChar = 0;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    assert (this.cb.length - this.markedChar >= delta);
                    assert (this.cb.length > 0);
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(long lineNumber) throws IOException {
        StringBuffer s = null;
        Object object = this.lock;
        synchronized (object) {
            int startChar;
            int i;
            this.ensureOpen();
            boolean omitLF = this.skipLF;
            for (int index = 0; index < 0x3FFFFFFF; index += i - startChar) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (s != null && s.length() > 0) {
                        return s.toString();
                    }
                    return null;
                }
                boolean eol = false;
                char c = '\u0000';
                if (!omitLF || this.cb[this.nextChar] == '\n') {
                    // empty if block
                }
                this.skipLF = false;
                omitLF = false;
                for (i = ++this.nextChar; i < this.nChars; ++i) {
                    c = this.cb[i];
                    if (c != '\n' && c != '\r') continue;
                    eol = true;
                    break;
                }
                startChar = this.nextChar;
                this.nextChar = i;
                if (eol) {
                    String str;
                    if (s == null) {
                        str = new String(this.cb, startChar, i - startChar);
                    } else {
                        s.append(this.cb, startChar, i - startChar);
                        str = s.toString();
                    }
                    ++this.nextChar;
                    if (c == '\r') {
                        this.skipLF = true;
                    }
                    if (str.length() > 0x3FFFFFFF) {
                        throw new IOException(ErrorMessages.getMessage("INVALID_LINE_SIZE", lineNumber));
                    }
                    return str;
                }
                if (s == null) {
                    s = new StringBuffer(defaultExpectedLineLength);
                }
                s.append(this.cb, startChar, i - startChar);
            }
        }
        throw new IOException(ErrorMessages.getMessage("INVALID_LINE_SIZE", lineNumber));
    }

    public String readLine() throws IOException {
        return this.readLine(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.cb = null;
            }
        }
    }

    public static String readLine(DataInputStream dataInputStream, long lineNumber) throws IOException {
        int index;
        StringBuilder line = new StringBuilder();
        int currentChar = dataInputStream.read();
        for (index = 0; currentChar != -1 && index < 0x3FFFFFFF; ++index) {
            if (currentChar == 10 || currentChar == 13) {
                return line.toString();
            }
            line.append((char)currentChar);
            currentChar = dataInputStream.read();
        }
        if (index == 0) {
            return null;
        }
        if (index < 0x3FFFFFFF) {
            return line.toString();
        }
        throw new IOException(ErrorMessages.getMessage("INVALID_LINE_SIZE", lineNumber));
    }
}

