/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.patterns;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mb.flowspec.runtime.interpreter.Types;
import mb.flowspec.runtime.interpreter.patterns.PatternNode;
import org.metaborg.util.functions.Function2;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.M;

public class TuplePatternNode
extends PatternNode {
    @Node.Children
    private final PatternNode[] children;

    public TuplePatternNode(PatternNode[] children) {
        this.children = children;
    }

    @Override
    public boolean matchGeneric(VirtualFrame frame, Object value) {
        IStrategoTerm term = Types.asIStrategoTerm(value);
        M.tuple(term);
        return TuplePatternNode.zip(Arrays.stream(this.children), Arrays.stream(term.getAllSubterms()), (c, vc) -> c.matchGeneric(frame, vc)).allMatch(b -> b);
    }

    public static <A, B, C> Stream<C> zip(Stream<A> streamA, Stream<B> streamB, final Function2<A, B, C> zipper) {
        final Iterator iteratorA = streamA.iterator();
        final Iterator iteratorB = streamB.iterator();
        Iterator iteratorC = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(iteratorA.next(), iteratorB.next());
            }
        };
        boolean parallel = streamA.isParallel() || streamB.isParallel();
        return TuplePatternNode.iteratorToFiniteStream(iteratorC, parallel);
    }

    public static <T> Stream<T> iteratorToFiniteStream(Iterator<T> iterator, boolean parallel) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }
}

