/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.base;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import mb.nabl2.constraints.base.ACNew;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.terms.ITerm;

public final class CNew
extends ACNew
implements Serializable {
    private final ImmutableSet<ITerm> nVars;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CNew(Iterable<? extends ITerm> nVars, IMessageInfo messageInfo) {
        this.nVars = ImmutableSet.copyOf(nVars);
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CNew(CNew original, ImmutableSet<ITerm> nVars, IMessageInfo messageInfo) {
        this.nVars = nVars;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    public ImmutableSet<ITerm> getNVars() {
        return this.nVars;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CNew withNVars(ITerm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new CNew(this, (ImmutableSet<ITerm>)newValue, this.messageInfo);
    }

    public final CNew withNVars(Iterable<? extends ITerm> elements) {
        if (this.nVars == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new CNew(this, (ImmutableSet<ITerm>)newValue, this.messageInfo);
    }

    public final CNew withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CNew(this, this.nVars, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CNew && this.equalTo((CNew)another);
    }

    private boolean equalTo(CNew another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.nVars.equals(another.nVars) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.nVars.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CNew of(Set<ITerm> nVars, IMessageInfo messageInfo) {
        return CNew.of(nVars, messageInfo);
    }

    public static CNew of(Iterable<? extends ITerm> nVars, IMessageInfo messageInfo) {
        return new CNew(nVars, messageInfo);
    }

    public static CNew copyOf(ACNew instance) {
        if (instance instanceof CNew) {
            return (CNew)instance;
        }
        return CNew.of(instance.getNVars(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CNew(this, this.nVars, this.messageInfo);
    }
}

