/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.messages;

import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;

public enum MessageKind {
    ERROR,
    WARNING,
    NOTE;

    private static final String ERROR_OP = "Error";
    private static final String WARNING_OP = "Warning";
    private static final String NOTE_OP = "Note";

    public static TermMatch.IMatcher<MessageKind> matcher() {
        return TermMatch.M.cases(TermMatch.M.appl0(ERROR_OP, e -> ERROR), TermMatch.M.appl0(WARNING_OP, e -> WARNING), TermMatch.M.appl0(NOTE_OP, e -> NOTE));
    }

    public static ITerm build(MessageKind kind) {
        switch (kind) {
            case ERROR: {
                return TermBuild.B.newAppl(ERROR_OP, new ITerm[0]);
            }
            case WARNING: {
                return TermBuild.B.newAppl(WARNING_OP, new ITerm[0]);
            }
            case NOTE: {
                return TermBuild.B.newAppl(NOTE_OP, new ITerm[0]);
            }
        }
        throw new IllegalArgumentException();
    }
}

