/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.nameresolution;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.nameresolution.ACDeclProperty;
import mb.nabl2.terms.ITerm;

public final class CDeclProperty
extends ACDeclProperty
implements Serializable {
    private final ITerm declaration;
    private final ITerm key;
    private final ITerm value;
    private final int priority;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CDeclProperty(ITerm declaration, ITerm key, ITerm value, int priority, IMessageInfo messageInfo) {
        this.declaration = Objects.requireNonNull(declaration, "declaration");
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.priority = priority;
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CDeclProperty(CDeclProperty original, ITerm declaration, ITerm key, ITerm value, int priority, IMessageInfo messageInfo) {
        this.declaration = declaration;
        this.key = key;
        this.value = value;
        this.priority = priority;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getDeclaration() {
        return this.declaration;
    }

    @Override
    public ITerm getKey() {
        return this.key;
    }

    @Override
    public ITerm getValue() {
        return this.value;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CDeclProperty withDeclaration(ITerm value) {
        if (this.declaration == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "declaration");
        return CDeclProperty.validate(new CDeclProperty(this, newValue, this.key, this.value, this.priority, this.messageInfo));
    }

    public final CDeclProperty withKey(ITerm value) {
        if (this.key == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "key");
        return CDeclProperty.validate(new CDeclProperty(this, this.declaration, newValue, this.value, this.priority, this.messageInfo));
    }

    public final CDeclProperty withValue(ITerm value) {
        if (this.value == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "value");
        return CDeclProperty.validate(new CDeclProperty(this, this.declaration, this.key, newValue, this.priority, this.messageInfo));
    }

    public final CDeclProperty withPriority(int value) {
        if (this.priority == value) {
            return this;
        }
        return CDeclProperty.validate(new CDeclProperty(this, this.declaration, this.key, this.value, value, this.messageInfo));
    }

    public final CDeclProperty withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return CDeclProperty.validate(new CDeclProperty(this, this.declaration, this.key, this.value, this.priority, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CDeclProperty && this.equalTo((CDeclProperty)another);
    }

    private boolean equalTo(CDeclProperty another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.declaration.equals(another.declaration) && this.key.equals(another.key) && this.value.equals(another.value) && this.priority == another.priority && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.declaration.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.priority;
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CDeclProperty of(ITerm declaration, ITerm key, ITerm value, int priority, IMessageInfo messageInfo) {
        return CDeclProperty.validate(new CDeclProperty(declaration, key, value, priority, messageInfo));
    }

    private static CDeclProperty validate(CDeclProperty instance) {
        instance.check();
        return instance;
    }

    public static CDeclProperty copyOf(ACDeclProperty instance) {
        if (instance instanceof CDeclProperty) {
            return (CDeclProperty)instance;
        }
        return CDeclProperty.of(instance.getDeclaration(), instance.getKey(), instance.getValue(), instance.getPriority(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return CDeclProperty.validate(new CDeclProperty(this, this.declaration, this.key, this.value, this.priority, this.messageInfo));
    }
}

