/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.interpreter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mb.nabl2.constraints.namebinding.DeclProperties;
import mb.nabl2.solver.ISolution;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.IScopeGraph;
import mb.scopegraph.pepm16.StuckException;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import mb.scopegraph.pepm16.terms.path.Paths;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;

public class InterpreterTerms {
    private static final ILogger logger = LoggerUtils.logger(InterpreterTerms.class);

    public static ITerm context(ISolution solution) {
        return TermBuild.B.newAppl("NaBL2", InterpreterTerms.scopegraph(solution.scopeGraph()), InterpreterTerms.nameresolution(solution.scopeGraph().getAllRefs(), solution.nameResolution()), InterpreterTerms.declTypes(solution.declProperties(), solution.unifier()));
    }

    private static ITerm scopegraph(IScopeGraph<Scope, Label, Occurrence> scopeGraph) {
        return TermBuild.B.newAppl("G", InterpreterTerms.scopeEntries(scopeGraph), InterpreterTerms.declEntries(scopeGraph), InterpreterTerms.refEntries(scopeGraph));
    }

    private static ITerm scopeEntries(IScopeGraph<Scope, Label, Occurrence> scopeGraph) {
        HashMap entries = Maps.newHashMap();
        for (Scope scope : scopeGraph.getAllScopes()) {
            IListTerm decls = TermBuild.B.newList(scopeGraph.getDecls().inverse().get(scope));
            IListTerm refs = TermBuild.B.newList(scopeGraph.getRefs().inverse().get(scope));
            IListTerm edges = InterpreterTerms.multimap(scopeGraph.getDirectEdges().get(scope));
            IListTerm imports = InterpreterTerms.multimap(scopeGraph.getImportEdges().get(scope));
            IApplTerm entry = TermBuild.B.newAppl("SE", decls, refs, edges, imports);
            entries.put(scope, entry);
        }
        return InterpreterTerms.map(entries.entrySet());
    }

    private static ITerm declEntries(IScopeGraph<Scope, Label, Occurrence> scopeGraph) {
        HashMap entries = Maps.newHashMap();
        for (Occurrence decl : scopeGraph.getAllDecls()) {
            ITerm scope = scopeGraph.getDecls().get(decl).map(s -> TermBuild.B.newList((ITerm)s)).orElse(TermBuild.B.newNil());
            IListTerm assocs = InterpreterTerms.multimap(scopeGraph.getExportEdges().get(decl));
            IApplTerm entry = TermBuild.B.newAppl("DE", scope, assocs);
            entries.put(decl, entry);
        }
        return InterpreterTerms.map(entries.entrySet());
    }

    private static ITerm refEntries(IScopeGraph<Scope, Label, Occurrence> scopeGraph) {
        HashMap entries = Maps.newHashMap();
        for (Occurrence ref : scopeGraph.getAllRefs()) {
            ITerm scope = scopeGraph.getRefs().get(ref).map(s -> TermBuild.B.newList((ITerm)s)).orElse(TermBuild.B.newNil());
            IApplTerm entry = TermBuild.B.newAppl("RE", scope);
            entries.put(ref, entry);
        }
        return InterpreterTerms.map(entries.entrySet());
    }

    private static ITerm nameresolution(Iterable<Occurrence> refs, IEsopNameResolution<Scope, Label, Occurrence> nameResolution) {
        HashMap entries = Maps.newHashMap();
        try {
            for (Occurrence ref : refs) {
                try {
                    Collection paths = nameResolution.resolve(ref, new NullCancel(), new NullProgress());
                    if (paths.size() == 1) {
                        IResolutionPath path = (IResolutionPath)Iterables.getOnlyElement(paths);
                        ITerm value = TermBuild.B.newTuple((ITerm)path.getDeclaration(), Paths.toTerm(path));
                        entries.put(ref, value);
                        continue;
                    }
                    logger.warn("Can only convert a single path, but {} has {}.", ref, paths.size());
                }
                catch (CriticalEdgeException | StuckException e) {
                    logger.warn("Could not convert unresolvable {}.", ref);
                }
            }
        }
        catch (InterruptedException e) {
            logger.warn("Conversion interrupted.");
        }
        return InterpreterTerms.map(entries.entrySet());
    }

    private static ITerm declTypes(IProperties<Occurrence, ITerm, ITerm> declProperties, IUnifier unifier) {
        HashMap entries = Maps.newHashMap();
        for (Occurrence decl : declProperties.getIndices()) {
            declProperties.getValue(decl, DeclProperties.TYPE_KEY).map(unifier::findRecursive).ifPresent(type -> entries.put(decl, unifier.findRecursive((ITerm)type)));
        }
        return InterpreterTerms.map(entries.entrySet());
    }

    private static IListTerm map(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> entries) {
        ArrayList entryTerms = Lists.newArrayList();
        for (Map.Entry<? extends ITerm, ? extends ITerm> entry : entries) {
            entryTerms.add(TermBuild.B.newTuple(entry.getKey(), entry.getValue()));
        }
        return TermBuild.B.newList(entryTerms);
    }

    private static IListTerm multimap(Iterable<? extends Map.Entry<? extends ITerm, ? extends ITerm>> entries) {
        HashMultimap grouped = HashMultimap.create();
        for (Map.Entry<? extends ITerm, ? extends ITerm> entry : entries) {
            grouped.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (ITerm key : grouped.keySet()) {
            arrayList.add(TermBuild.B.newTuple(key, TermBuild.B.newList(grouped.get((Object)key))));
        }
        return TermBuild.B.newList(arrayList);
    }
}

