/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.relations.terms.Arg;
import mb.nabl2.relations.variants.IVariance;
import mb.nabl2.relations.variants.IVariantMatcher;
import mb.nabl2.relations.variants.Variances;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import org.immutables.value.Value;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.optionals.Optionals;

public class VariantMatchers {
    public static TermMatch.IMatcher<IVariantMatcher<ITerm>> matcher() {
        return TermMatch.M.cases(TermMatch.M.appl1("ListVariant", Variances.matcher(), (t, v) -> new ListVariant((IVariance)v)), TermMatch.M.appl2("OpVariant", TermMatch.M.stringValue(), TermMatch.M.listElems(Variances.matcher()), (t, op, vs) -> new OpVariant((String)op, (Iterable<IVariance>)vs)), TermMatch.M.appl1("TupleVariant", TermMatch.M.listElems(Variances.matcher()), (t, vs) -> new OpVariant("", (Iterable<IVariance>)vs)));
    }

    @Value.Immutable
    static abstract class AArg
    implements IVariantMatcher.IArg<ITerm>,
    Serializable {
        private static final long serialVersionUID = 42L;

        AArg() {
        }

        @Override
        @Value.Parameter
        public abstract IVariance getVariance();

        @Override
        @Value.Parameter
        public abstract ITerm getValue();
    }

    private static class ListVariant
    implements IVariantMatcher<ITerm>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final IVariance variance;

        public ListVariant(IVariance variance) {
            this.variance = variance;
        }

        @Override
        public Optional<List<IVariantMatcher.IArg<ITerm>>> match(ITerm t) {
            return TermMatch.M.listElems(TermMatch.M.term(), (l, list) -> {
                ArrayList args = Lists.newArrayList();
                for (ITerm arg : list) {
                    args.add(Arg.of(this.variance, arg));
                }
                return args;
            }).match(t);
        }

        @Override
        public ITerm build(Collection<? extends ITerm> ts) {
            return TermBuild.B.newList(ts);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.variance.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListVariant other = (ListVariant)obj;
            return this.variance.equals(other.variance);
        }
    }

    private static class OpVariant
    implements IVariantMatcher<ITerm>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final String op;
        private final ImmutableList<IVariance> variances;

        public OpVariant(String op, Iterable<IVariance> variances) {
            this.op = op;
            this.variances = ImmutableList.copyOf(variances);
        }

        @Override
        public Optional<List<IVariantMatcher.IArg<ITerm>>> match(ITerm t) {
            return TermMatch.IMatcher.flatten(TermMatch.M.appl(this.op, appl -> Optionals.when(this.variances.size() == appl.getArity()).map(eq -> Lists.newArrayList(Iterables2.zip(this.variances, appl.getArgs(), (v, a) -> Arg.of(v, a)))))).match(t);
        }

        @Override
        public ITerm build(Collection<? extends ITerm> ts) {
            return TermBuild.B.newAppl(this.op, ts);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.op.hashCode();
            result = 31 * result + this.variances.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OpVariant other = (OpVariant)obj;
            if (!this.op.equals(other.op)) {
                return false;
            }
            return this.variances.equals(other.variances);
        }
    }
}

