/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.AMultiUnitResult;
import mb.nabl2.terms.ITerm;

public final class MultiUnitResult
extends AMultiUnitResult
implements Serializable {
    private final ImmutableList<IConstraint> constraints;
    private final ISolution solution;
    private final ITerm customAnalysis;
    private final Fresh.Immutable fresh;
    private static final long serialVersionUID = 42L;

    private MultiUnitResult(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Fresh.Immutable fresh) {
        this.constraints = ImmutableList.copyOf(constraints);
        this.solution = Objects.requireNonNull(solution, "solution");
        this.customAnalysis = customAnalysis.orElse(null);
        this.fresh = Objects.requireNonNull(fresh, "fresh");
    }

    private MultiUnitResult(MultiUnitResult original, ImmutableList<IConstraint> constraints, ISolution solution, ITerm customAnalysis, Fresh.Immutable fresh) {
        this.constraints = constraints;
        this.solution = solution;
        this.customAnalysis = customAnalysis;
        this.fresh = fresh;
    }

    public ImmutableList<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public ISolution solution() {
        return this.solution;
    }

    @Override
    public Optional<ITerm> customAnalysis() {
        return Optional.ofNullable(this.customAnalysis);
    }

    @Override
    public Fresh.Immutable fresh() {
        return this.fresh;
    }

    public final MultiUnitResult withConstraints(IConstraint ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new MultiUnitResult(this, (ImmutableList<IConstraint>)newValue, this.solution, this.customAnalysis, this.fresh);
    }

    public final MultiUnitResult withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new MultiUnitResult(this, (ImmutableList<IConstraint>)newValue, this.solution, this.customAnalysis, this.fresh);
    }

    @Override
    public final MultiUnitResult withSolution(ISolution value) {
        if (this.solution == value) {
            return this;
        }
        ISolution newValue = Objects.requireNonNull(value, "solution");
        return new MultiUnitResult(this, this.constraints, newValue, this.customAnalysis, this.fresh);
    }

    @Override
    public final MultiUnitResult withCustomAnalysis(ITerm value) {
        ITerm newValue = Objects.requireNonNull(value, "customAnalysis");
        if (this.customAnalysis == newValue) {
            return this;
        }
        return new MultiUnitResult(this, this.constraints, this.solution, newValue, this.fresh);
    }

    public final MultiUnitResult withCustomAnalysis(Optional<? extends ITerm> optional) {
        ITerm value = optional.orElse(null);
        if (this.customAnalysis == value) {
            return this;
        }
        return new MultiUnitResult(this, this.constraints, this.solution, value, this.fresh);
    }

    @Override
    public final MultiUnitResult withFresh(Fresh.Immutable value) {
        if (this.fresh == value) {
            return this;
        }
        Fresh.Immutable newValue = Objects.requireNonNull(value, "fresh");
        return new MultiUnitResult(this, this.constraints, this.solution, this.customAnalysis, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MultiUnitResult && this.equalTo((MultiUnitResult)another);
    }

    private boolean equalTo(MultiUnitResult another) {
        return this.constraints.equals(another.constraints) && this.solution.equals(another.solution) && Objects.equals(this.customAnalysis, another.customAnalysis) && this.fresh.equals(another.fresh);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.solution.hashCode();
        h += (h << 5) + Objects.hashCode(this.customAnalysis);
        h += (h << 5) + this.fresh.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MultiUnitResult").omitNullValues().add("constraints", this.constraints).add("solution", (Object)this.solution).add("customAnalysis", (Object)this.customAnalysis).add("fresh", (Object)this.fresh).toString();
    }

    public static MultiUnitResult of(List<IConstraint> constraints, ISolution solution, Optional<ITerm> customAnalysis, Fresh.Immutable fresh) {
        return MultiUnitResult.of(constraints, solution, customAnalysis, fresh);
    }

    public static MultiUnitResult of(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Fresh.Immutable fresh) {
        return new MultiUnitResult(constraints, solution, customAnalysis, fresh);
    }

    public static MultiUnitResult copyOf(AMultiUnitResult instance) {
        if (instance instanceof MultiUnitResult) {
            return (MultiUnitResult)instance;
        }
        return MultiUnitResult.of(instance.constraints(), instance.solution(), instance.customAnalysis(), instance.fresh());
    }
}

