/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.ANilTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class NilTerm
extends ANilTerm
implements Serializable {
    private final IAttachments attachments;
    private final int minSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private NilTerm(Builder builder) {
        if (builder.attachments != null) {
            this.initShim.attachments(builder.attachments);
        }
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    private NilTerm(IAttachments attachments) {
        this.initShim.attachments(attachments);
        this.attachments = this.initShim.getAttachments();
        this.minSize = this.initShim.getMinSize();
        this.initShim = null;
    }

    @Override
    public IAttachments getAttachments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAttachments() : this.attachments;
    }

    @Override
    public int getMinSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinSize() : this.minSize;
    }

    @Override
    public final NilTerm withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new NilTerm(newValue);
    }

    public static NilTerm copyOf(ANilTerm instance) {
        if (instance instanceof NilTerm) {
            return (NilTerm)instance;
        }
        return NilTerm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ NilTerm(Builder builder, NilTerm nilTerm) {
        this(builder);
    }

    public static final class Builder {
        private IAttachments attachments;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ANilTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public NilTerm build() {
            return new NilTerm(this, null);
        }
    }

    private final class InitShim {
        private byte attachmentsBuildStage = 0;
        private IAttachments attachments;
        private byte minSizeBuildStage = 0;
        private int minSize;

        private InitShim() {
        }

        IAttachments getAttachments() {
            if (this.attachmentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachmentsBuildStage == 0) {
                this.attachmentsBuildStage = (byte)-1;
                this.attachments = Objects.requireNonNull(NilTerm.super.getAttachments(), "attachments");
                this.attachmentsBuildStage = 1;
            }
            return this.attachments;
        }

        void attachments(IAttachments attachments) {
            this.attachments = attachments;
            this.attachmentsBuildStage = 1;
        }

        int getMinSize() {
            if (this.minSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minSizeBuildStage == 0) {
                this.minSizeBuildStage = (byte)-1;
                this.minSize = NilTerm.super.getMinSize();
                this.minSizeBuildStage = 1;
            }
            return this.minSize;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.attachmentsBuildStage == -1) {
                attributes.add("attachments");
            }
            if (this.minSizeBuildStage == -1) {
                attributes.add("minSize");
            }
            return "Cannot build NilTerm, attribute initializers form cycle " + attributes;
        }
    }
}

