/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.INilTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.Appl0Term;
import mb.nabl2.terms.build.Appl1Term;
import mb.nabl2.terms.build.Appl2Term;
import mb.nabl2.terms.build.Appl3Term;
import mb.nabl2.terms.build.Appl4Term;
import mb.nabl2.terms.build.ApplTerm;
import mb.nabl2.terms.build.BlobTerm;
import mb.nabl2.terms.build.ConsTerm;
import mb.nabl2.terms.build.ITermBuild;
import mb.nabl2.terms.build.IntTerm;
import mb.nabl2.terms.build.NilTerm;
import mb.nabl2.terms.build.StringTerm;
import mb.nabl2.terms.build.TermVar;
import mb.nabl2.util.collections.ConcurrentWeakCache;

public class TermBuild {
    public static final B B = new B();

    public static class B
    implements ITermBuild {
        private static final INilTerm NIL = NilTerm.builder().build();
        final ConcurrentWeakCache<ITerm, ITerm> cache = new ConcurrentWeakCache();

        @Override
        public IApplTerm newAppl(String op, Iterable<? extends ITerm> args, @Nullable IAttachments attachments) {
            ImmutableList argList = ImmutableList.copyOf(args);
            switch (argList.size()) {
                case 0: {
                    if (attachments == null || attachments.isEmpty()) {
                        Appl0Term term = Appl0Term.of(op);
                        return (IApplTerm)this.cache.getOrPut(term, term);
                    }
                    return Appl0Term.builder().op(op).attachments(attachments).build();
                }
                case 1: {
                    if (attachments == null || attachments.isEmpty()) {
                        return Appl1Term.of(op, (ITerm)argList.get(0));
                    }
                    return Appl1Term.builder().op(op).arg0((ITerm)argList.get(0)).attachments(attachments).build();
                }
                case 2: {
                    if (attachments == null || attachments.isEmpty()) {
                        return Appl2Term.of(op, (ITerm)argList.get(0), (ITerm)argList.get(1));
                    }
                    return Appl2Term.builder().op(op).arg0((ITerm)argList.get(0)).arg1((ITerm)argList.get(1)).attachments(attachments).build();
                }
                case 3: {
                    if (attachments == null || attachments.isEmpty()) {
                        return Appl3Term.of(op, (ITerm)argList.get(0), (ITerm)argList.get(1), (ITerm)argList.get(2));
                    }
                    return Appl3Term.builder().op(op).arg0((ITerm)argList.get(0)).arg1((ITerm)argList.get(1)).arg2((ITerm)argList.get(2)).attachments(attachments).build();
                }
                case 4: {
                    if (attachments == null || attachments.isEmpty()) {
                        return Appl4Term.of(op, (ITerm)argList.get(0), (ITerm)argList.get(1), (ITerm)argList.get(2), (ITerm)argList.get(3));
                    }
                    return Appl4Term.builder().op(op).arg0((ITerm)argList.get(0)).arg1((ITerm)argList.get(1)).arg2((ITerm)argList.get(2)).arg3((ITerm)argList.get(3)).attachments(attachments).build();
                }
            }
            if (attachments == null || attachments.isEmpty()) {
                return ApplTerm.of(op, args);
            }
            return ApplTerm.builder().op(op).args(args).attachments(attachments).build();
        }

        @Override
        public INilTerm newNil(@Nullable IAttachments attachments) {
            if (attachments == null || attachments.isEmpty()) {
                return NIL;
            }
            return NilTerm.builder().attachments(attachments).build();
        }

        @Override
        public IConsTerm newCons(ITerm head, IListTerm tail, @Nullable IAttachments attachments) {
            if (attachments == null || attachments.isEmpty()) {
                return ConsTerm.of(head, tail);
            }
            return ConsTerm.builder().head(head).tail(tail).attachments(attachments).build();
        }

        @Override
        public IStringTerm newString(String value, @Nullable IAttachments attachments) {
            if (attachments == null || attachments.isEmpty()) {
                StringTerm term = StringTerm.of(value);
                return (IStringTerm)this.cache.getOrPut(term, term);
            }
            return StringTerm.builder().value(value).attachments(attachments).build();
        }

        @Override
        public IIntTerm newInt(int value, @Nullable IAttachments attachments) {
            if (attachments == null || attachments.isEmpty()) {
                IntTerm term = IntTerm.of(value);
                return (IIntTerm)this.cache.getOrPut(term, term);
            }
            return IntTerm.builder().value(value).attachments(attachments).build();
        }

        @Override
        public IBlobTerm newBlob(Object value, @Nullable IAttachments attachments) {
            if (attachments == null || attachments.isEmpty()) {
                return BlobTerm.of(value);
            }
            return BlobTerm.builder().value(value).attachments(attachments).build();
        }

        @Override
        public ITermVar newVar(String resource, String name, @Nullable IAttachments attachments) {
            if (attachments == null || attachments.isEmpty()) {
                TermVar term = TermVar.of(resource, name);
                return (ITermVar)this.cache.getOrPut(term, term);
            }
            return TermVar.builder().resource(resource).name(name).attachments(attachments).build();
        }
    }
}

