/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.collection;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;

public class TermMultiset {
    private final Multiset<ITerm> terms = HashMultiset.create();
    private final Multimap<ITermVar, ITerm> varTerms = HashMultimap.create();

    public void add(ITerm term, IUnifier unifier) {
        this.add(term, 1, unifier);
    }

    public void add(ITerm term, int n, IUnifier unifier) {
        ITerm rep = unifier.findRecursive(term);
        for (ITermVar var : rep.getVars()) {
            this.varTerms.put((Object)var, (Object)rep);
        }
        this.terms.add((Object)rep, n);
    }

    public int remove(ITerm term, IUnifier unifier) {
        return this.remove(term, 1, unifier);
    }

    public int remove(ITerm term, int n, IUnifier unifier) {
        ITerm rep = unifier.findRecursive(term);
        int prev_n = this.terms.remove((Object)rep, n);
        if (prev_n <= n) {
            this.varTerms.values().remove(rep);
        }
        return Math.min(prev_n, n);
    }

    public boolean contains(ITerm term, IUnifier unifier) {
        return this.count(term, unifier) > 0;
    }

    public int count(ITerm term, IUnifier unifier) {
        ITerm rep = unifier.findRecursive(term);
        return this.terms.count((Object)rep);
    }

    public int size() {
        return this.terms.size();
    }

    public Set<ITerm> elementSet() {
        return Collections.unmodifiableSet(this.terms.elementSet());
    }

    public Set<ITermVar> varSet() {
        return Collections.unmodifiableSet(this.varTerms.keySet());
    }

    public boolean update(Collection<ITermVar> vars, IUnifier unifier) {
        Set updatedTerms = vars.stream().flatMap(var -> this.varTerms.removeAll(var).stream()).collect(Collectors.toSet());
        for (ITerm term : updatedTerms) {
            int n = this.terms.remove((Object)term, this.terms.count((Object)term));
            this.varTerms.values().remove(term);
            this.add(term, n, unifier);
        }
        return !updatedTerms.isEmpty();
    }
}

