/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;

public class IndexedDeque<E>
implements Deque<E> {
    private final Deque<E> deque;
    private final Multiset<E> index;

    public IndexedDeque() {
        this(Queues.newArrayDeque());
    }

    public IndexedDeque(Deque<E> deque) {
        this.deque = deque;
        this.index = HashMultiset.create();
    }

    @Override
    public void addFirst(E e) {
        this.deque.addFirst(e);
        this.index.add(e);
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public void addLast(E e) {
        this.deque.addLast(e);
        this.index.add(e);
    }

    @Override
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.deque.offerFirst(e)) {
            this.index.add(e);
            return true;
        }
        return false;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.deque.toArray(a);
    }

    @Override
    public boolean offerLast(E e) {
        if (this.deque.offerLast(e)) {
            this.index.add(e);
            return true;
        }
        return false;
    }

    @Override
    public E removeFirst() {
        E elem = this.deque.removeFirst();
        this.index.remove(elem);
        return elem;
    }

    @Override
    public E removeLast() {
        E elem = this.deque.removeLast();
        this.index.remove(elem);
        return elem;
    }

    @Override
    public E pollFirst() {
        E elem = this.deque.pollFirst();
        if (elem != null) {
            this.index.remove(elem);
        }
        return elem;
    }

    @Override
    public E pollLast() {
        E elem = this.deque.pollLast();
        if (elem != null) {
            this.index.remove(elem);
        }
        return elem;
    }

    @Override
    public E getFirst() {
        return this.deque.getFirst();
    }

    @Override
    public E getLast() {
        return this.deque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.deque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.deque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (this.deque.removeFirstOccurrence(o)) {
            this.index.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (this.deque.removeLastOccurrence(o)) {
            this.index.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.index.containsAll(c);
    }

    @Override
    public boolean add(E e) {
        if (this.deque.add(e)) {
            this.index.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.deque.addAll(c)) {
            this.index.addAll(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        if (this.deque.offer(e)) {
            this.index.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.deque.removeAll(c)) {
            this.index.removeAll(c);
            return true;
        }
        return false;
    }

    @Override
    public E remove() {
        E elem = this.deque.remove();
        this.index.remove(elem);
        return elem;
    }

    @Override
    public E poll() {
        E elem = this.deque.poll();
        if (elem != null) {
            this.index.remove(elem);
        }
        return elem;
    }

    @Override
    public E element() {
        return this.deque.element();
    }

    @Override
    public E peek() {
        return this.deque.peek();
    }

    @Override
    public void push(E e) {
        this.deque.push(e);
        this.index.add(e);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.deque.retainAll(c)) {
            this.index.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public E pop() {
        E elem = this.deque.pop();
        this.index.remove(elem);
        return elem;
    }

    @Override
    public boolean remove(Object o) {
        if (this.deque.remove(o)) {
            this.index.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.deque.clear();
        this.index.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.deque.equals(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.index.contains(o);
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> it = this.deque.iterator();
        return new Iterator<E>(){
            private E current = null;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                this.current = it.next();
                return this.current;
            }

            @Override
            public void remove() {
                it.remove();
                IndexedDeque.this.index.remove(this.current);
            }
        };
    }

    @Override
    public Iterator<E> descendingIterator() {
        final Iterator<E> it = this.deque.descendingIterator();
        return new Iterator<E>(){
            private E current = null;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                this.current = it.next();
                return this.current;
            }

            @Override
            public void remove() {
                it.remove();
                IndexedDeque.this.index.remove(this.current);
            }
        };
    }

    @Override
    public int hashCode() {
        return this.deque.hashCode();
    }

    public String toString() {
        return this.deque.toString();
    }
}

