/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.alg.fw;

import java.util.HashMap;
import mb.nabl2.util.graph.alg.dred.DRedTcRelation;
import mb.nabl2.util.graph.alg.misc.memory.IMemoryView;
import mb.nabl2.util.graph.igraph.IBiDirectionalGraphDataSource;
import mb.nabl2.util.graph.igraph.IBiDirectionalWrapper;
import mb.nabl2.util.graph.igraph.IGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphObserver;

public class FloydWarshallAlg<V>
implements IGraphObserver<V> {
    private DRedTcRelation<V> tc = null;
    private IBiDirectionalGraphDataSource<V> gds = null;

    public FloydWarshallAlg(IGraphDataSource<V> gds) {
        this.gds = gds instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)gds : new IBiDirectionalWrapper<V>(gds);
        this.tc = new DRedTcRelation();
        gds.attachObserver(this);
        this.generateTc();
    }

    private void generateTc() {
        int j;
        this.tc.clear();
        int n = this.gds.getAllNodes().size();
        HashMap mapForw = new HashMap();
        HashMap mapBackw = new HashMap();
        int[][] P2 = new int[n][n];
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                P2[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        for (Object node : this.gds.getAllNodes()) {
            mapForw.put(node, i);
            mapBackw.put(i, node);
            ++i;
        }
        for (Object source : this.gds.getAllNodes()) {
            IMemoryView targets = this.gds.getTargetNodes(source);
            for (Object target : targets.distinctValues()) {
                P2[((Integer)mapForw.get(source)).intValue()][((Integer)mapForw.get(target)).intValue()] = 1;
            }
        }
        int k = 0;
        while (k < n) {
            i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    P2[i][j] = P2[i][j] | P2[i][k] & P2[k][j];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                if (P2[i][j] == 1 && i != j) {
                    this.tc.addTuple(mapBackw.get(i), mapBackw.get(j));
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void edgeInserted(V source, V target) {
        this.generateTc();
    }

    @Override
    public void edgeDeleted(V source, V target) {
        this.generateTc();
    }

    @Override
    public void nodeInserted(V n) {
        this.generateTc();
    }

    @Override
    public void nodeDeleted(V n) {
        this.generateTc();
    }

    public DRedTcRelation<V> getTcRelation() {
        return this.tc;
    }
}

