/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.alg.scc;

import java.util.Map;
import java.util.Set;
import mb.nabl2.util.graph.igraph.IGraphDataSource;

public class SCCResult<V> {
    private Set<Set<V>> sccs;
    private IGraphDataSource<V> gds;

    public SCCResult(Set<Set<V>> sccs, IGraphDataSource<V> gds) {
        this.sccs = sccs;
        this.gds = gds;
    }

    public Set<Set<V>> getSccs() {
        return this.sccs;
    }

    public int getSCCCount() {
        return this.sccs.size();
    }

    public double getAverageNodeCount() {
        double a = 0.0;
        for (Set<V> s : this.sccs) {
            a += (double)s.size();
        }
        return a / (double)this.sccs.size();
    }

    public double getAverageEdgeCount() {
        long edgeSum = 0L;
        for (Set<V> scc : this.sccs) {
            for (V source : scc) {
                for (Map.Entry<V, Integer> entry : this.gds.getTargetNodes(source).entriesWithMultiplicities()) {
                    if (!scc.contains(entry.getKey())) continue;
                    edgeSum += (long)entry.getValue().intValue();
                }
            }
        }
        return (double)edgeSum / (double)this.sccs.size();
    }

    public int getBiggestSCCSize() {
        int max2 = 0;
        for (Set<V> scc : this.sccs) {
            if (scc.size() <= max2) continue;
            max2 = scc.size();
        }
        return max2;
    }

    public long getSumOfSquares() {
        long sum = 0L;
        for (Set<V> scc : this.sccs) {
            sum += (long)(scc.size() * scc.size());
        }
        return sum;
    }
}

