/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Streams;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.p_raffrayi.DeadlockException;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.IUnitStats;
import mb.p_raffrayi.TypeCheckingFailedException;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorMonitor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.actors.IActorStats;
import mb.p_raffrayi.actors.TypeTag;
import mb.p_raffrayi.actors.deadlock.ChandyMisraHaas;
import mb.p_raffrayi.impl.ARecordedQuery;
import mb.p_raffrayi.impl.AbstractQueryTypeCheckerContext;
import mb.p_raffrayi.impl.BrokerProcess;
import mb.p_raffrayi.impl.DeadlockUtils;
import mb.p_raffrayi.impl.IProcess;
import mb.p_raffrayi.impl.IQueryAnswer;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.IUnitContext;
import mb.p_raffrayi.impl.QueryAnswer;
import mb.p_raffrayi.impl.RecordedQuery;
import mb.p_raffrayi.impl.StateSummary;
import mb.p_raffrayi.impl.UnitProcess;
import mb.p_raffrayi.impl.UnitResult;
import mb.p_raffrayi.impl.WaitForGraph;
import mb.p_raffrayi.impl.diff.IDifferContext;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.IScopeGraphDiffer;
import mb.p_raffrayi.impl.tokens.CloseLabel;
import mb.p_raffrayi.impl.tokens.CloseScope;
import mb.p_raffrayi.impl.tokens.DifferResult;
import mb.p_raffrayi.impl.tokens.DifferState;
import mb.p_raffrayi.impl.tokens.IWaitFor;
import mb.p_raffrayi.impl.tokens.InitScope;
import mb.p_raffrayi.impl.tokens.Match;
import mb.p_raffrayi.impl.tokens.PQuery;
import mb.p_raffrayi.impl.tokens.Query;
import mb.p_raffrayi.impl.tokens.TypeCheckerResult;
import mb.p_raffrayi.impl.tokens.TypeCheckerState;
import mb.p_raffrayi.impl.tokens.UnitAdd;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.p_raffrayi.nameresolution.IQuery;
import mb.p_raffrayi.nameresolution.IResolutionContext;
import mb.p_raffrayi.nameresolution.NameResolutionQuery;
import mb.p_raffrayi.nameresolution.StateMachineQuery;
import mb.p_raffrayi.nameresolution.tracing.ExtQuerySet;
import mb.p_raffrayi.nameresolution.tracing.ExtQuerySets;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.ScopeGraphUtil;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.path.IResolutionPath;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import mb.scopegraph.patching.IPatchCollection;
import mb.scopegraph.resolution.StateMachine;
import org.metaborg.util.Ref;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.HashTrieRelation3;
import org.metaborg.util.collection.IRelation3;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletable;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public abstract class AbstractUnit<S, L, D, R>
implements IUnit<S, L, D, R>,
IActorMonitor,
ChandyMisraHaas.Host<IProcess<S, L, D>> {
    private static final ILogger logger = LoggerUtils.logger(IUnit.class);
    protected final TypeTag<IUnit<S, L, D, ?>> TYPE = TypeTag.of(IUnit.class);
    protected final IActor<? extends IUnit<S, L, D, R>> self;
    @Nullable
    protected final IActorRef<? extends IUnit<S, L, D, ?>> parent;
    protected final IUnitContext<S, L, D> context;
    protected final ChandyMisraHaas<IProcess<S, L, D>> cmh;
    protected final UnitProcess<S, L, D> process;
    private final BrokerProcess<S, L, D> broker = BrokerProcess.of();
    private volatile boolean innerResult;
    private final Ref<R> analysis;
    protected final List<Throwable> failures;
    private final Map<String, IUnitResult<S, L, D, ?>> subUnitResults;
    private final ICompletableFuture<IUnitResult<S, L, D, R>> unitResult;
    protected final Ref<IScopeGraph.Immutable<S, L, D>> scopeGraph;
    protected final Set.Immutable<L> edgeLabels;
    protected final Set.Transient<S> scopes;
    protected final Set.Transient<S> sharedScopes;
    protected final List<S> rootScopes = new ArrayList<S>();
    private final IRelation3.Transient<S, EdgeOrData<L>, Delay> delays;
    @Nullable
    protected IScopeGraphDiffer<S, L, D> differ;
    private final Ref<ScopeGraphDiff<S, L, D>> diffResult = new Ref();
    protected final ICompletableFuture<Unit> whenDifferActivated = new CompletableFuture<Unit>();
    protected MultiSet.Transient<String> scopeNameCounters;
    protected Set.Transient<String> usedStableScopes;
    protected final java.util.Set<IRecordedQuery<S, L, D>> recordedQueries = new HashSet<IRecordedQuery<S, L, D>>();
    protected IUnitResult.TransitionTrace stateTransitionTrace = IUnitResult.TransitionTrace.OTHER;
    protected final Stats stats;
    private WaitForGraph<IProcess<S, L, D>, IWaitFor<S, L, D>> wfg = new WaitForGraph();
    private long wakeTimeNanos;

    public AbstractUnit(IActor<? extends IUnit<S, L, D, R>> self, @Nullable IActorRef<? extends IUnit<S, L, D, ?>> parent, IUnitContext<S, L, D> context, Iterable<L> edgeLabels) {
        this.self = self;
        this.parent = parent;
        this.context = context;
        this.cmh = new ChandyMisraHaas(this, this::handleDeadlock);
        this.process = new UnitProcess(self);
        this.innerResult = false;
        this.analysis = new Ref();
        this.failures = new ArrayList<Throwable>();
        this.subUnitResults = new HashMap();
        this.unitResult = new CompletableFuture<IUnitResult<S, L, D, R>>();
        this.scopeGraph = new Ref(ScopeGraph.Immutable.of());
        this.edgeLabels = CapsuleUtil.toSet(edgeLabels);
        this.scopes = CapsuleUtil.transientSet();
        this.sharedScopes = CapsuleUtil.transientSet();
        this.delays = HashTrieRelation3.Transient.of();
        this.scopeNameCounters = MultiSet.Transient.of();
        this.usedStableScopes = Set.Transient.of();
        this.stats = new Stats(self.stats());
    }

    protected abstract IFuture<D> getExternalDatum(D var1);

    protected abstract D getPreviousDatum(D var1);

    @Override
    public void _initShare(S scope, Iterable<EdgeOrData<L>> edges, boolean sharing) {
        this.resume();
        this.doInitShare(this.self.sender(this.TYPE), scope, edges, sharing);
    }

    @Override
    public void _addShare(S scope) {
        this.doAddShare(this.self.sender(this.TYPE), scope);
    }

    @Override
    public void _doneSharing(S scope) {
        this.resume();
        this.doCloseScope(this.self.sender(this.TYPE), scope);
    }

    @Override
    public void _addEdge(S source, L label, S target) {
        this.doAddEdge(this.self.sender(this.TYPE), source, label, target);
    }

    @Override
    public void _closeEdge(S scope, EdgeOrData<L> edge) {
        this.resume();
        this.doCloseLabel(this.self.sender(this.TYPE), scope, edge);
    }

    @Override
    public IFuture<IQueryAnswer<S, L, D>> _query(IActorRef<? extends IUnit<S, L, D, ?>> origin, ScopePath<S, L> path, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv) {
        ++this.stats.incomingQueries;
        return this.doQuery(this.self.sender(this.TYPE), origin, false, path, query, dataWF, dataEquiv, null, null);
    }

    protected final S makeScope(String baseName) {
        String name = baseName.replace('-', '_');
        int n = this.scopeNameCounters.add(name);
        S scope = this.context.makeScope(String.valueOf(name) + "-" + n);
        return scope;
    }

    protected final S makeStableScope(String name) {
        return this.context.makeScope(String.valueOf(name) + "!");
    }

    protected final void doStart(List<S> currentRootScopes) {
        this.rootScopes.addAll(currentRootScopes);
        for (Object rootScope : CapsuleUtil.toSet(currentRootScopes)) {
            this.scopes.__insert(rootScope);
            this.doAddLocalShare(this.self, rootScope);
        }
    }

    protected final IFuture<IUnitResult<S, L, D, R>> doFinish(IFuture<R> result) {
        CompletableFuture<Object> internalResult = new CompletableFuture<Object>();
        TypeCheckerResult token = TypeCheckerResult.of(this.self, internalResult);
        this.waitFor(token, this.self);
        result.whenComplete(internalResult::complete);
        internalResult.whenComplete((r, ex) -> {
            String id = this.self.id();
            logger.debug("{} type checker finished", id);
            this.resume();
            if (this.isDifferEnabled()) {
                this.self.assertOnActorThread();
                this.whenDifferActivated.thenAccept(__ -> this.differ.typeCheckerFinished());
            }
            if (ex != null) {
                logger.error("type checker errored: {}", (Throwable)ex);
                this.failures.add((Throwable)ex);
            } else {
                this.analysis.set(r);
            }
            this.granted(token, this.self);
            Multiset<IWaitFor<S, L, D>> selfTokens = this.getTokens(this.process);
            if (!selfTokens.isEmpty()) {
                logger.debug("{} returned while waiting on {}", this.self, selfTokens);
            }
            this.innerResult = true;
        });
        return this.unitResult;
    }

    protected boolean isDifferEnabled() {
        return this.context.settings().scopeGraphDiff();
    }

    protected void initDiffer(IScopeGraphDiffer<S, L, D> differ, List<S> currentRootScopes, List<S> previousRootScopes) {
        this.assertDifferEnabled();
        logger.debug("Initializing differ: {} with scopes: {} ~ {}.", differ, currentRootScopes, previousRootScopes);
        this.differ = differ;
        this.doFinishDiffer(differ.diff(currentRootScopes, previousRootScopes));
        this.whenDifferActivated.complete(Unit.unit);
    }

    protected void initDiffer(IScopeGraphDiffer<S, L, D> differ, IScopeGraph.Immutable<S, L, D> scopeGraph, Collection<S> scopes, Collection<S> sharedScopes, IPatchCollection.Immutable<S> patches, Collection<S> openScopes, Multimap<S, EdgeOrData<L>> openEdges) {
        this.assertDifferEnabled();
        logger.debug("Initializing differ: {} with initial scope graph: {}.", differ, scopeGraph);
        this.differ = differ;
        this.doFinishDiffer(differ.diff(scopeGraph, scopes, sharedScopes, patches, openScopes, openEdges));
        this.whenDifferActivated.complete(Unit.unit);
    }

    private void doFinishDiffer(IFuture<ScopeGraphDiff<S, L, D>> future) {
        CompletableFuture<ScopeGraphDiff> differResult = new CompletableFuture<ScopeGraphDiff>();
        DifferResult result = DifferResult.of(this.self, differResult);
        this.waitFor(result, this.self);
        this.self.schedule(future).whenComplete(differResult::complete);
        differResult.whenComplete((r, ex) -> {
            logger.debug("{} scope graph differ finished", this);
            if (ex != null) {
                logger.error("scope graph differ errored.", (Throwable)ex);
                this.failures.add((Throwable)ex);
            } else {
                this.diffResult.set((ScopeGraphDiff<S, L, D>)r);
            }
            this.granted(result, this.self);
            this.resume();
            this.tryFinish();
        });
    }

    protected <U> Tuple2<IActorRef<? extends IUnit<S, L, D, U>>, IFuture<IUnitResult<S, L, D, U>>> doAddSubUnit(String id, Function2<IActor<IUnit<S, L, D, U>>, IUnitContext<S, L, D>, IUnit<S, L, D, U>> unitProvider, List<S> rootScopes, boolean ignoreResult) {
        for (S rootScope : rootScopes) {
            this.assertOwnOrSharedScope(rootScope);
        }
        Tuple2 result_subunit = this.context.add(id, unitProvider, rootScopes);
        IActorRef subunit = result_subunit._2();
        CompletableFuture<IUnitResult> internalResult = new CompletableFuture<IUnitResult>();
        TypeCheckerResult token = TypeCheckerResult.of(this.self, internalResult);
        this.waitFor(token, subunit);
        result_subunit._1().whenComplete(internalResult::complete);
        for (Object rootScope : CapsuleUtil.toSet(rootScopes)) {
            this.doAddShare(subunit, rootScope);
        }
        IFuture<IUnitResult> ret = internalResult.whenComplete((r, ex) -> {
            logger.debug("{} subunit {} finished", this, subunit);
            this.granted(token, subunit);
            if (ex != null) {
                this.failures.add(new Exception("No result for sub unit " + id));
            } else if (!ignoreResult) {
                this.subUnitResults.put(id, (IUnitResult<S, L, D, ?>)r);
            }
        });
        return Tuple2.of(subunit, ret);
    }

    protected final S doFreshScope(String baseName, Iterable<L> edgeLabels, boolean data, boolean sharing) {
        S scope = this.makeScope(baseName);
        return this.doPrepareScope(scope, edgeLabels, data, sharing);
    }

    protected final S doStableFreshScope(String name, Iterable<L> edgeLabels, boolean data) {
        if (!this.usedStableScopes.__insert((Object)name)) {
            throw new IllegalStateException("Stable scope identity " + name + " already used.");
        }
        S scope = this.makeStableScope(name);
        return this.doPrepareScope(scope, edgeLabels, data, true);
    }

    private S doPrepareScope(S scope, Iterable<L> edgeLabels, boolean data, boolean sharing) {
        ArrayList labels = Lists.newArrayList();
        for (L l : edgeLabels) {
            labels.add(EdgeOrData.edge(l));
            if (this.edgeLabels.contains(l)) continue;
            logger.error("Initializing scope {} with unregistered edge label {}.", scope, l);
            throw new IllegalStateException("Initializing scope " + scope + " with unregistered edge label " + l + ".");
        }
        if (data) {
            labels.add(EdgeOrData.data());
        }
        this.scopes.__insert(scope);
        if (sharing) {
            this.sharedScopes.__insert(scope);
        }
        this.doAddLocalShare(this.self, scope);
        this.doInitShare(this.self, scope, labels, sharing);
        return scope;
    }

    @Override
    public IFuture<Optional<S>> _match(S previousScope) {
        this.assertOwnScope(previousScope);
        IActorRef<IUnit<S, L, D, ?>> sender = this.self.sender(this.TYPE);
        if (this.isDifferEnabled()) {
            return this.whenDifferActivated.thenCompose(__ -> {
                CompletableFuture<Optional> future = new CompletableFuture<Optional>();
                DifferState state = DifferState.ofMatch(sender, previousScope, future);
                this.waitFor(state, this.self);
                this.differ.match(previousScope).whenComplete(future::complete);
                future.whenComplete((r, ex) -> this.granted(state, this.self));
                return future;
            });
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    protected final void doAddLocalShare(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope) {
        this.assertOwnOrSharedScope(scope);
        this.waitFor(InitScope.of(this.self, scope), sender);
    }

    protected final void doAddShare(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope) {
        this.doAddLocalShare(sender, scope);
        if (!this.isOwner(scope)) {
            this.self.async(this.parent)._addShare(scope);
        }
    }

    protected final void doInitShare(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope, Iterable<EdgeOrData<L>> edges, boolean sharing) {
        this.assertOwnOrSharedScope(scope);
        this.granted(InitScope.of(this.self, scope), sender);
        for (EdgeOrData<L> edge : edges) {
            this.waitFor(CloseLabel.of(this.self, scope, edge), sender);
        }
        if (sharing) {
            this.waitFor(CloseScope.of(this.self, scope), sender);
        }
        if (this.isScopeInitialized(scope)) {
            this.releaseDelays(scope);
        }
        if (!this.isOwner(scope)) {
            this.self.async(this.parent)._initShare(scope, edges, sharing);
        }
    }

    protected final void doSetDatum(S scope, D datum) {
        EdgeOrData edge = EdgeOrData.data();
        this.assertLabelOpen(scope, edge);
        this.scopeGraph.set(this.scopeGraph.get().setDatum(scope, datum));
        this.doCloseLabel(this.self, scope, edge);
    }

    protected final void doCloseScope(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope) {
        this.assertOwnOrSharedScope(scope);
        this.granted(CloseScope.of(this.self, scope), sender);
        if (this.isScopeInitialized(scope)) {
            this.releaseDelays(scope);
        }
        if (!this.isOwner(scope)) {
            this.self.async(this.parent)._doneSharing(scope);
        }
    }

    protected final void doCloseLabel(IActorRef<? extends IUnit<S, L, D, ?>> sender, S scope, EdgeOrData<L> edge) {
        this.assertOwnOrSharedScope(scope);
        this.granted(CloseLabel.of(this.self, scope, edge), sender);
        if (this.isEdgeClosed(scope, edge)) {
            this.releaseDelays(scope, edge);
        }
        if (!this.isOwner(scope)) {
            this.self.async(this.parent)._closeEdge(scope, edge);
        }
    }

    protected final void doAddEdge(IActorRef<? extends IUnit<S, L, D, ?>> sender, S source, L label, S target) {
        this.assertOwnOrSharedScope(source);
        this.assertLabelOpen(source, EdgeOrData.edge(label));
        this.scopeGraph.set(this.scopeGraph.get().addEdge(source, label, target));
        if (!this.isOwner(source)) {
            this.self.async(this.parent)._addEdge(source, label, target);
        }
    }

    protected final IFuture<IQueryAnswer<S, L, D>> doQuery(final IActorRef<? extends IUnit<S, L, D, ?>> sender, final IActorRef<? extends IUnit<S, L, D, ?>> origin, final boolean record, ScopePath<S, L> path, IQuery<S, L, D> query, final DataWf<S, L, D> dataWF, final DataLeq<S, L, D> dataEquiv, final DataWf<S, L, D> dataWfInternal, final DataLeq<S, L, D> dataEquivInternal) {
        final ILogger logger = LoggerUtils.logger(IResolutionContext.class);
        logger.debug("got _query from {}", sender);
        final boolean external = !sender.equals(this.self);
        final Ref<1> context = new Ref<1>();
        context.set(new IResolutionContext<S, L, D, ExtQuerySet<S, L, D>>(){

            @Override
            public IFuture<Tuple2<Env<S, L, D>, ExtQuerySet<S, L, D>>> externalEnv(ScopePath<S, L> path, IQuery<S, L, D> query, ICancel cancel) {
                Object scope = path.getTarget();
                if (AbstractUnit.this.canAnswer(scope)) {
                    logger.debug("local env {}", scope);
                    return query.resolve((IResolutionContext)context.get(), path, cancel).thenApply(ans -> {
                        if (AbstractUnit.this.isQueryRecordingEnabled() && record && AbstractUnit.this.sharedScopes.contains(scope)) {
                            AbstractUnit.this.recordedQueries.add(RecordedQuery.of(path, AbstractUnit.this.datumScopes((Env)ans._1()), query.labelWf(), dataWF, (Env)ans._1()));
                        }
                        return ans;
                    });
                }
                return AbstractUnit.this.getOwner(scope).thenCompose(owner -> {
                    logger.debug("remote env {} at {}", scope, owner);
                    IFuture result = ((IUnit)AbstractUnit.this.self.async(owner))._query(origin, path, query, dataWF, dataEquiv);
                    Query wf = Query.of(sender, path, query, dataWF, dataEquiv, result);
                    AbstractUnit.this.waitFor(wf, owner);
                    if (external) {
                        ++AbstractUnit.this.stats.forwardedQueries;
                    } else {
                        ++AbstractUnit.this.stats.outgoingQueries;
                    }
                    return result.thenApply(ans -> {
                        ExtQuerySet.Builder extQueriesBuilder = ExtQuerySet.builder().from(ExtQuerySets.empty());
                        if (AbstractUnit.this.isQueryRecordingEnabled()) {
                            extQueriesBuilder.addAllTransitiveQueries(ans.transitiveQueries());
                            extQueriesBuilder.addAllPredicateQueries(ans.predicateQueries());
                            extQueriesBuilder.addTransitiveQueries(RecordedQuery.of(path, AbstractUnit.this.datumScopes(ans.env()), query.labelWf(), dataWF, ans.env()));
                        }
                        return Tuple2.of(ans.env(), extQueriesBuilder.build());
                    }).whenComplete((env, ex) -> {
                        logger.debug("got answer from {}", sender);
                        AbstractUnit.this.granted(wf, owner);
                        AbstractUnit.this.resume();
                    });
                });
            }

            @Override
            public IFuture<Optional<D>> getDatum(S scope) {
                return AbstractUnit.this.isComplete(scope, EdgeOrData.data(), sender).thenCompose(__ -> {
                    Optional datum = AbstractUnit.this.scopeGraph.get().getData(scope);
                    if (!datum.isPresent()) {
                        return CompletableFuture.completedFuture(Optional.empty());
                    }
                    if (external || dataWfInternal == null) {
                        IFuture<Object> ret;
                        logger.debug("require external rep for {}", datum.get());
                        IFuture result = AbstractUnit.this.getExternalDatum(datum.get());
                        if (result.isDone()) {
                            ret = result;
                        } else {
                            CompletableFuture<Object> internalResult = new CompletableFuture<Object>();
                            TypeCheckerState token = TypeCheckerState.of(sender, ImmutableList.of(datum.get()), internalResult);
                            AbstractUnit.this.waitFor(token, AbstractUnit.this.self);
                            result.whenComplete(internalResult::complete);
                            ret = internalResult.whenComplete((rep, ex) -> {
                                AbstractUnit.this.self.assertOnActorThread();
                                AbstractUnit.this.granted(token, AbstractUnit.this.self);
                            });
                        }
                        return ret.thenApply(rep -> {
                            logger.debug("got external rep {} for {}", rep, datum.get());
                            return Optional.of(rep);
                        });
                    }
                    return CompletableFuture.completedFuture(datum);
                });
            }

            @Override
            public IFuture<Iterable<S>> getEdges(S scope, L label) {
                return AbstractUnit.this.isComplete(scope, EdgeOrData.edge(label), sender).thenApply(__ -> AbstractUnit.this.scopeGraph.get().getEdges(scope, label));
            }

            @Override
            public IFuture<Tuple2<Boolean, ExtQuerySet<S, L, D>>> dataWf(D d, ICancel cancel) throws InterruptedException {
                ++AbstractUnit.this.stats.dataWfChecks;
                CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
                RecordingTypeCheckerContext queryContext = new RecordingTypeCheckerContext(origin);
                IFuture<Boolean> result = external || dataWfInternal == null ? dataWF.wf(d, queryContext, cancel) : dataWfInternal.wf(d, queryContext, cancel);
                if (result.isDone()) {
                    result.whenComplete(future::complete);
                } else {
                    CompletableFuture<Boolean> internalResult = new CompletableFuture<Boolean>();
                    TypeCheckerState token = TypeCheckerState.of(sender, ImmutableList.of(d), internalResult);
                    AbstractUnit.this.waitFor(token, AbstractUnit.this.self);
                    result.whenComplete(internalResult::complete);
                    internalResult.whenComplete((r, ex) -> {
                        AbstractUnit.this.self.assertOnActorThread();
                        AbstractUnit.this.granted(token, AbstractUnit.this.self);
                        future.complete((Boolean)r, (Throwable)ex);
                    });
                }
                return future.thenApply(wf -> Tuple2.of(wf, ExtQuerySet.builder().addAllPredicateQueries(queryContext.dispose()).build()));
            }

            @Override
            public IFuture<Tuple2<Boolean, ExtQuerySet<S, L, D>>> dataEquiv(D d1, D d2, ICancel cancel) throws InterruptedException {
                ++AbstractUnit.this.stats.dataLeqChecks;
                CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
                RecordingTypeCheckerContext queryContext = new RecordingTypeCheckerContext(origin);
                IFuture<Boolean> result = external || dataEquivInternal == null ? dataEquiv.leq(d1, d2, queryContext, cancel) : dataEquivInternal.leq(d1, d2, queryContext, cancel);
                if (result.isDone()) {
                    result.whenComplete(future::complete);
                } else {
                    CompletableFuture<Boolean> internalResult = new CompletableFuture<Boolean>();
                    TypeCheckerState token = TypeCheckerState.of(sender, ImmutableList.of(d1, d2), internalResult);
                    AbstractUnit.this.waitFor(token, AbstractUnit.this.self);
                    result.whenComplete(internalResult::complete);
                    internalResult.whenComplete((r, ex) -> {
                        AbstractUnit.this.self.assertOnActorThread();
                        AbstractUnit.this.granted(token, AbstractUnit.this.self);
                        future.complete((Boolean)r, (Throwable)ex);
                    });
                }
                return future.thenApply(wf -> Tuple2.of(wf, ExtQuerySet.builder().addAllPredicateQueries(queryContext.dispose()).build()));
            }

            @Override
            public IFuture<Boolean> dataEquivAlwaysTrue(ICancel cancel) {
                RecordingTypeCheckerContext queryContext = new RecordingTypeCheckerContext(origin);
                return dataEquiv.alwaysTrue(queryContext, cancel).thenApply(at -> {
                    if (!queryContext.dispose().isEmpty()) {
                        throw new IllegalStateException("alwaysTrue() check should not perform queries.");
                    }
                    return at;
                });
            }

            @Override
            public ExtQuerySet<S, L, D> unitMetadata() {
                return ExtQuerySets.empty();
            }

            @Override
            public ExtQuerySet<S, L, D> compose(ExtQuerySet<S, L, D> queries1, ExtQuerySet<S, L, D> queries2) {
                return queries1.addQueries(queries2);
            }
        });
        IFuture result = ((IResolutionContext)context.get()).externalEnv(path, query, this.context.cancel());
        result.whenComplete((env, ex) -> {
            logger.debug("have answer for {}", sender);
            if (record && this.isQueryRecordingEnabled()) {
                this.recordedQueries.addAll((Collection<IRecordedQuery<S, L, D>>)((ExtQuerySet)env._2()).transitiveQueries());
                this.recordedQueries.addAll((Collection<IRecordedQuery<S, L, D>>)((ExtQuerySet)env._2()).predicateQueries());
            }
        });
        return result.thenApply(env -> QueryAnswer.of((Env)env._1(), ((ExtQuerySet)env._2()).transitiveQueries(), ((ExtQuerySet)env._2()).predicateQueries()));
    }

    protected final IFuture<IQueryAnswer<S, L, D>> doQueryPrevious(IActorRef<? extends IUnit<S, L, D, ?>> sender, IScopeGraph.Immutable<S, L, D> scopeGraph, ScopePath<S, L> path, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv) {
        logger.debug("rec pquery from {}", sender);
        StaticNameResolutionContext context = new StaticNameResolutionContext(sender, scopeGraph, dataWF, dataEquiv);
        return query.resolve(context, path, this.context.cancel()).thenApply(env -> QueryAnswer.of((Env)env._1(), ((ExtQuerySet)env._2()).transitiveQueries(), ((ExtQuerySet)env._2()).predicateQueries()));
    }

    protected final boolean isOwner(S scope) {
        return this.context.scopeId(scope).equals(this.self.id());
    }

    protected final IFuture<IActorRef<? extends IUnit<S, L, D, ?>>> getOwner(S scope) {
        IFuture<IActorRef<IUnit<S, L, D, ?>>> future = this.context.owner(scope);
        if (future.isDone()) {
            return future;
        }
        CompletableFuture result = new CompletableFuture();
        UnitAdd unitAdd = UnitAdd.of(this.self, this.context.scopeId(scope), result);
        this.waitFor(unitAdd, this.broker);
        this.self.schedule(future).whenComplete((r, ex) -> {
            this.self.assertOnActorThread();
            this.granted(unitAdd, this.broker);
            result.complete((IActorRef<? extends IUnit<S, L, D, ?>>)r, (Throwable)ex);
            this.resume();
        });
        return result;
    }

    protected boolean canAnswer(S scope) {
        return this.isOwner(scope);
    }

    private Set<S> datumScopes(Env<S, L, D> env) {
        return (Set)Streams.stream(env).map(ResolutionPath::getDatum).map(this.context::getScopes).reduce(CapsuleUtil.immutableSet(), Set.Immutable::__insertAll);
    }

    protected boolean isWaiting() {
        return this.wfg.isWaiting();
    }

    protected boolean isWaitingFor(IWaitFor<S, L, D> token) {
        return this.wfg.isWaitingFor(token);
    }

    protected boolean isWaitingFor(IWaitFor<S, L, D> token, IActor<? extends IUnit<S, L, D, ?>> from) {
        return this.wfg.isWaitingFor(new UnitProcess(from), token);
    }

    protected int countWaitingFor(IWaitFor<S, L, D> token, IActorRef<? extends IUnit<S, L, D, ?>> from) {
        return this.wfg.countWaitingFor(new UnitProcess(from), token);
    }

    private Multiset<IWaitFor<S, L, D>> getTokens(IProcess<S, L, D> unit) {
        return this.wfg.getTokens(unit);
    }

    protected Multiset<IWaitFor<S, L, D>> ownTokens() {
        return this.getTokens(this.process);
    }

    protected void waitFor(IWaitFor<S, L, D> token, IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        this.waitFor(token, this.process(actor));
    }

    protected void waitFor(IWaitFor<S, L, D> token, IProcess<S, L, D> process) {
        if (this.wfg.waitFor(process, token)) {
            this.resume();
        }
    }

    protected void waitFor(IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        this.waitFor(this.process(actor));
    }

    protected void waitFor(IProcess<S, L, D> process) {
        if (this.wfg.waitFor(process)) {
            this.resume();
        }
    }

    protected void granted(IWaitFor<S, L, D> token, IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        this.granted(token, this.process(actor));
    }

    protected void granted(IWaitFor<S, L, D> token, IProcess<S, L, D> process) {
        if (this.wfg.granted(process, token)) {
            this.resume();
        }
    }

    protected void granted(IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        this.granted(this.process(actor));
    }

    protected void granted(IProcess<S, L, D> process) {
        if (this.wfg.granted(process)) {
            this.resume();
        }
    }

    private IProcess<S, L, D> process(IActorRef<? extends IUnit<S, L, D, ?>> actor) {
        return actor == this.self ? this.process : new UnitProcess(actor);
    }

    protected void tryFinish() {
        logger.debug("{} tryFinish", this);
        if (this.innerResult && !this.unitResult.isDone() && !this.isWaiting()) {
            logger.debug("{} finish", this);
            UnitResult result = UnitResult.builder().id(this.self.id()).scopeGraph(this.scopeGraph.get()).queries(this.recordedQueries).rootScopes(this.rootScopes).scopes(this.scopes.freeze()).result(this.analysis.get()).failures(this.failures).subUnitResults(this.subUnitResults).stats(this.stats).stateTransitionTrace(this.stateTransitionTrace).diff(this.diffResult.get()).build();
            this.self.complete(this.unitResult, result, null);
        } else {
            logger.trace("Still waiting for {}{}", !this.innerResult ? "inner result and " : "", this.wfg);
        }
    }

    private void releaseDelays(S scope) {
        for (Map.Entry entry : this.delays.get(scope)) {
            EdgeOrData edge = (EdgeOrData)entry.getKey();
            if (this.isWaitingFor(CloseLabel.of(this.self, scope, edge))) continue;
            Delay delay = (Delay)entry.getValue();
            logger.debug("released {} on {}(/{})", delay, scope, edge);
            this.delays.remove(scope, edge, delay);
            this.self.complete(delay.future, Unit.unit, null);
        }
    }

    private void releaseDelays(S scope, EdgeOrData<L> edge) {
        for (Delay delay : this.delays.get(scope, edge)) {
            logger.debug("released {} on {}/{}", delay, scope, edge);
            this.delays.remove(scope, edge, delay);
            this.self.complete(delay.future, Unit.unit, null);
        }
    }

    private boolean isScopeInitialized(S scope) {
        return !this.isWaitingFor(InitScope.of(this.self, scope)) && !this.isWaitingFor(CloseScope.of(this.self, scope));
    }

    private boolean isEdgeClosed(S scope, EdgeOrData<L> edge) {
        return this.isScopeInitialized(scope) && !this.isWaitingFor(CloseLabel.of(this.self, scope, edge));
    }

    private IFuture<Unit> isComplete(S scope, EdgeOrData<L> edge, IActorRef<? extends IUnit<S, L, D, ?>> sender) {
        this.assertOwnOrSharedScope(scope);
        if (this.isEdgeClosed(scope, edge)) {
            return CompletableFuture.completedFuture(Unit.unit);
        }
        CompletableFuture<Unit> result = new CompletableFuture<Unit>();
        this.delays.put(scope, edge, new Delay(result, sender));
        return result;
    }

    protected void suspend() {
        this.cmh.idle();
    }

    protected void resume() {
        this.cmh.exec();
    }

    @Override
    public void _deadlockQuery(IProcess<S, L, D> i, int m, IProcess<S, L, D> k) {
        this.cmh.query(i, m, k);
    }

    @Override
    public void _deadlockReply(IProcess<S, L, D> i, int m, java.util.Set<IProcess<S, L, D>> R2) {
        this.cmh.reply(i, m, R2);
    }

    @Override
    public void _deadlocked(java.util.Set<IProcess<S, L, D>> nodes) {
        this.self.assertOnActorThread();
        if (!nodes.contains(this.process)) {
            throw new IllegalStateException("Deadlock unrelated to this unit.");
        }
        if (nodes.size() == 1) {
            if (!this.failDelays(nodes)) {
                this.resume();
            }
        } else if (this.failDelays(nodes)) {
            this.resume();
        }
    }

    protected void handleDeadlock(java.util.Set<IProcess<S, L, D>> nodes) {
        logger.debug("{} deadlocked with {}", this, nodes);
        if (!nodes.contains(this.process)) {
            throw new IllegalStateException("Deadlock unrelated to this unit.");
        }
        if (nodes.size() == 1) {
            if (!this.failDelays(nodes)) {
                this.failAll();
            } else {
                this.resume();
            }
            return;
        }
        AggregateFuture.forAll(nodes, node -> node.from(this.self, this.context)._state()).whenComplete((states, ex) -> {
            if (ex != null) {
                this.failures.add((Throwable)ex);
                return;
            }
            DeadlockUtils.GraphBuilder wfgBuilder = DeadlockUtils.GraphBuilder.of();
            states.forEach(state -> {
                IProcess self = state.getSelf();
                wfgBuilder.addVertex(self);
                state.getDependencies().forEach(dep -> wfgBuilder.addEdge(self, dep));
            });
            DeadlockUtils.IGraph wfg = wfgBuilder.build();
            logger.debug("{} computing SCCs in graph.");
            java.util.Set sccs = DeadlockUtils.sccs(wfg);
            for (java.util.Set<IProcess<S, L, D>> set : sccs) {
                if (this.isIncrementalDeadlockEnabled()) {
                    java.util.Set<StateSummary<S, L, D>> subStates = states.stream().filter(ss -> scc.contains(ss.getSelf())).collect(Collectors.toSet());
                    this.handleDeadlockIncremental(set, subStates);
                    continue;
                }
                this.handleDeadlockRegular(set);
            }
        });
    }

    private void handleDeadlockIncremental(java.util.Set<IProcess<S, L, D>> nodes, Collection<StateSummary<S, L, D>> states) {
        logger.debug("Handling incremental deadlock: {}.", states);
        Map groupedStates = states.stream().collect(Collectors.groupingBy(StateSummary::getState, Collectors.toSet()));
        if (!groupedStates.containsKey((Object)StateSummary.State.UNKNOWN)) {
            logger.debug("No restartable units, doing regular deadlock handling.");
            this.handleDeadlockRegular(nodes);
        } else if (!groupedStates.containsKey((Object)StateSummary.State.ACTIVE)) {
            logger.debug("Releasing all involved units.");
            groupedStates.get((Object)StateSummary.State.UNKNOWN).forEach(node -> node.getSelf().from(this.self, this.context)._release());
        } else {
            java.util.Set activeProcesses = groupedStates.get((Object)StateSummary.State.ACTIVE);
            java.util.Set<IProcess> restarts = groupedStates.get((Object)StateSummary.State.UNKNOWN).stream().filter(node -> this.shouldRestart((StateSummary<S, L, D>)node, activeProcesses)).map(StateSummary::getSelf).collect(Collectors.toSet());
            if (restarts.isEmpty()) {
                logger.warn("Conservative deadlock detection failed: Active units have no incoming dependencies elegible for restart. Restarting all unknown units");
                groupedStates.get((Object)StateSummary.State.UNKNOWN).forEach(node -> node.getSelf().from(this.self, this.context)._restart());
            } else {
                logger.debug("Restarting {}.", restarts);
                restarts.forEach(node -> node.from(this.self, this.context)._restart());
                logger.debug("Restarted {}.", restarts);
            }
        }
    }

    private boolean shouldRestart(StateSummary<S, L, D> node, Collection<StateSummary<S, L, D>> activeProcesses) {
        java.util.Set activeNodes = activeProcesses.stream().map(StateSummary::getSelf).collect(Collectors.toSet());
        return node.getDependencies().stream().anyMatch(activeNodes::contains);
    }

    private void handleDeadlockRegular(java.util.Set<IProcess<S, L, D>> nodes) {
        block3: {
            block1: {
                block2: {
                    if (nodes.size() != 1 || !nodes.contains(this.process)) break block1;
                    logger.debug("{} self-deadlocked with {}", this, this.getTokens(this.process));
                    if (!this.failDelays(nodes)) break block2;
                    this.resume();
                    break block3;
                }
                if (!this.dependentSet().equals(Collections.singleton(this.process))) break block3;
                this.failAll();
                break block3;
            }
            for (IProcess<S, L, D> node : nodes) {
                node.from(this.self, this.context)._deadlocked(nodes);
            }
        }
    }

    private boolean failDelays(Collection<IProcess<S, L, D>> nodes) {
        Set.Transient deadlocked = CapsuleUtil.transientSet();
        for (Delay delay : this.delays.inverse().keySet()) {
            if (!nodes.contains(this.process(delay.sender))) continue;
            logger.debug("{} fail {}", this.self, delay);
            this.delays.inverse().remove(delay);
            deadlocked.__insert(delay.future);
        }
        for (IProcess iProcess : nodes) {
            for (IWaitFor wf : this.getTokens(iProcess)) {
                wf.visit(IWaitFor.cases(initScope -> {}, closeScope -> {}, closeLabel -> {}, query -> {}, pQuery -> {}, confirm -> {}, match -> {}, result -> {}, typeCheckerState -> {
                    if (nodes.contains(this.process(typeCheckerState.origin()))) {
                        logger.debug("{} fail {}", this.self, typeCheckerState);
                        deadlocked.__insert(typeCheckerState.future());
                    }
                }, differResult -> {}, differState -> {}, envDifferState -> {}, unitAdd -> {}));
            }
        }
        for (ICompletable iCompletable : deadlocked) {
            this.self.complete(iCompletable, null, new DeadlockException("Type checker " + this.self.id() + " deadlocked."));
        }
        return !deadlocked.isEmpty();
    }

    private void failAll() {
        for (IWaitFor wf : CapsuleUtil.toSet(this.wfg.getTokens())) {
            wf.visit(IWaitFor.cases(initScope -> {
                this.failures.add(new DeadlockException(initScope.toString()));
                this.granted((IWaitFor<S, L, D>)initScope, (IActorRef<? extends IUnit<S, L, D, ?>>)this.self);
                if (!this.isOwner(initScope.scope())) {
                    this.self.async(this.parent)._initShare(initScope.scope(), (Iterable<EdgeOrData<L>>)CapsuleUtil.immutableSet(), false);
                }
                this.releaseDelays(initScope.scope());
            }, closeScope -> {
                this.failures.add(new DeadlockException(closeScope.toString()));
                this.granted((IWaitFor<S, L, D>)closeScope, (IActorRef<? extends IUnit<S, L, D, ?>>)this.self);
                if (!this.isOwner(closeScope.scope())) {
                    this.self.async(this.parent)._doneSharing(closeScope.scope());
                }
                this.releaseDelays(closeScope.scope());
            }, closeLabel -> {
                this.failures.add(new DeadlockException(closeLabel.toString()));
                this.granted((IWaitFor<S, L, D>)closeLabel, (IActorRef<? extends IUnit<S, L, D, ?>>)this.self);
                if (!this.isOwner(closeLabel.scope())) {
                    this.self.async(this.parent)._closeEdge(closeLabel.scope(), closeLabel.label());
                }
                this.releaseDelays(closeLabel.scope(), closeLabel.label());
            }, query -> {
                logger.error("Unexpected remaining query: " + query);
                throw new IllegalStateException("Unexpected remaining query: " + query);
            }, pQuery -> {
                logger.error("Unexpected remaining query: " + pQuery);
                throw new IllegalStateException("Unexpected remaining query: " + pQuery);
            }, confirm -> {
                logger.error("Unexpected remaining confirmation request: " + confirm);
                throw new IllegalStateException("Unexpected remaining confirmation request: " + confirm);
            }, match -> {
                logger.error("Unexpected remaining match query: " + match);
                throw new IllegalStateException("Unexpected remaining match query: " + match);
            }, result -> this.self.complete(result.future(), null, new DeadlockException("Type checker did not return a result.")), typeCheckerState -> {
                if (typeCheckerState.origin().equals(this.self)) {
                    logger.error("Unexpected remaining internal state: " + typeCheckerState);
                    throw new IllegalStateException("Unexpected remaining internal state: " + typeCheckerState);
                }
                this.self.complete(typeCheckerState.future(), null, new DeadlockException("Type checker deadlocked."));
            }, differResult -> {
                logger.error("Differ could not complete.");
                this.self.complete(differResult.future(), null, new DeadlockException("Type checker deadlocked."));
            }, differState -> {
                logger.error("Unexpected remaining differ state.");
                this.self.complete(differState.future(), null, new DeadlockException("Type checker deadlocked."));
            }, envDifferState -> {
                logger.error("Unexpected remaining environment differ state.");
                this.self.complete(envDifferState.future(), null, new DeadlockException("Type checker deadlocked."));
            }, unitAdd -> {
                logger.error("Requested Unit {} was never added.", unitAdd.unitId());
                this.self.complete(unitAdd.future(), null, new DeadlockException("Requested Unit " + unitAdd.unitId() + " was never added."));
            }));
        }
    }

    protected boolean isIncrementalEnabled() {
        return this.context.settings().isIncremental();
    }

    protected boolean isQueryRecordingEnabled() {
        return this.context.settings().recording();
    }

    protected boolean isIncrementalDeadlockEnabled() {
        return this.context.settings().incrementalDeadlock();
    }

    @Override
    public IProcess<S, L, D> process() {
        return this.process;
    }

    @Override
    public java.util.Set<IProcess<S, L, D>> dependentSet() {
        return this.wfg.dependencies();
    }

    @Override
    public void query(IProcess<S, L, D> k, IProcess<S, L, D> i, int m) {
        k.from(this.self, this.context)._deadlockQuery(i, m, this.process);
    }

    @Override
    public void reply(IProcess<S, L, D> k, IProcess<S, L, D> i, int m, java.util.Set<IProcess<S, L, D>> R2) {
        k.from(this.self, this.context)._deadlockReply(i, m, R2);
    }

    @Override
    public void assertOnActorThread() {
        this.self.assertOnActorThread();
    }

    protected IDifferContext<S, L, D> differContext(final Function1<D, D> instantiateData) {
        return new IDifferContext<S, L, D>(){

            @Override
            public IFuture<Iterable<S>> getEdges(S scope, L label) {
                IFuture complete = AbstractUnit.this.isComplete(scope, EdgeOrData.edge(label), AbstractUnit.this.self);
                if (complete.isDone()) {
                    return CompletableFuture.completedFuture(AbstractUnit.this.scopeGraph.get().getEdges(scope, label));
                }
                CompletableFuture result = new CompletableFuture();
                complete.whenComplete((__, ex) -> {
                    if (ex != null) {
                        if (ex instanceof DeadlockException) {
                            this.getEdges(scope, label).whenComplete(result::complete);
                        } else {
                            result.completeExceptionally((Throwable)ex);
                        }
                    } else {
                        result.complete(AbstractUnit.this.scopeGraph.get().getEdges(scope, label));
                    }
                });
                return result;
            }

            @Override
            public IFuture<Optional<D>> datum(S scope) {
                AbstractUnit.this.assertOwnScope(scope);
                return AbstractUnit.this.isComplete(scope, EdgeOrData.data(), AbstractUnit.this.self).thenCompose(__ -> {
                    Optional datum = AbstractUnit.this.scopeGraph.get().getData(scope);
                    if (!datum.isPresent()) {
                        return CompletableFuture.completedFuture(datum);
                    }
                    CompletableFuture<Object> future = new CompletableFuture<Object>();
                    TypeCheckerState state = TypeCheckerState.of(AbstractUnit.this.self, Arrays.asList(datum.get()), future);
                    AbstractUnit.this.waitFor(state, AbstractUnit.this.self);
                    AbstractUnit.this.getExternalDatum(datum.get()).whenComplete(future::complete);
                    return future.whenComplete((r, ex) -> AbstractUnit.this.granted(state, AbstractUnit.this.self)).thenApply(Optional::of);
                });
            }

            @Override
            public Optional<D> rawDatum(S scope) {
                return AbstractUnit.this.scopeGraph.get().getData(scope).map(instantiateData::apply);
            }

            @Override
            public boolean available(S scope) {
                return AbstractUnit.this.scopes.contains(scope);
            }

            public String toString() {
                return "DifferContext(" + AbstractUnit.this.self.id() + "):\n" + ScopeGraphUtil.toString(AbstractUnit.this.scopeGraph.get(), instantiateData);
            }
        };
    }

    protected IDifferOps<S, L, D> differOps() {
        return new IDifferOps<S, L, D>(){

            @Override
            public boolean isMatchAllowed(S currentScope, S previousScope) {
                return AbstractUnit.this.context.scopeId(previousScope).equals(AbstractUnit.this.context.scopeId(currentScope));
            }

            @Override
            public Optional<BiMap.Immutable<S>> matchDatums(D currentDatum, D previousDatum) {
                return AbstractUnit.this.context.matchDatums(currentDatum, previousDatum);
            }

            @Override
            public Collection<S> getScopes(D d) {
                return AbstractUnit.this.context.getScopes(d);
            }

            @Override
            public D embed(S scope) {
                return AbstractUnit.this.context.embed(scope);
            }

            @Override
            public boolean ownScope(S scope) {
                return AbstractUnit.this.context.scopeId(scope).equals(AbstractUnit.this.self.id());
            }

            @Override
            public boolean ownOrSharedScope(S currentScope) {
                return AbstractUnit.this.scopes.contains(currentScope);
            }

            @Override
            public IFuture<Optional<S>> externalMatch(S previousScope) {
                return AbstractUnit.this.getOwner(previousScope).thenCompose(owner -> {
                    Match match = Match.of(AbstractUnit.this.self, previousScope);
                    AbstractUnit.this.waitFor(match, owner);
                    return ((IUnit)AbstractUnit.this.self.async(owner))._match(previousScope).whenComplete((__, ___) -> AbstractUnit.this.granted(match, owner));
                });
            }
        };
    }

    @Override
    public void started() {
        logger.debug("{} started", this);
        this.wakeTimeNanos = System.nanoTime();
    }

    @Override
    public void resumed() {
        logger.debug("{} resumed", this);
        this.wakeTimeNanos = System.nanoTime();
    }

    @Override
    public void suspended() {
        logger.debug("{} suspended", this);
        long suspendTimeNanos = System.nanoTime();
        long activeTimeNanos = suspendTimeNanos - this.wakeTimeNanos;
        this.stats.runtimeNanos += activeTimeNanos;
        this.suspend();
        this.tryFinish();
    }

    @Override
    public void stopped(Throwable ex) {
        if (!this.unitResult.isDone()) {
            if (ex != null && ex instanceof InterruptedException) {
                this.unitResult.completeExceptionally(ex);
            } else {
                this.unitResult.completeExceptionally(new TypeCheckingFailedException(this + " stopped.", ex));
            }
        }
    }

    protected void assertOwnScope(S scope) {
        if (!this.context.scopeId(scope).equals(this.self.id())) {
            logger.error("Scope {} is not owned by {}", scope, this);
            throw new IllegalArgumentException("Scope " + scope + " is not owned by " + this);
        }
    }

    protected void assertOwnOrSharedScope(S scope) {
        if (!this.scopes.contains(scope)) {
            logger.error("Scope {} is not owned or shared by {}", scope, this);
            throw new IllegalArgumentException("Scope " + scope + " is not owned or shared by " + this);
        }
    }

    protected void assertLabelOpen(S scope, EdgeOrData<L> edge) {
        this.assertOwnOrSharedScope(scope);
        if (this.isEdgeClosed(scope, edge)) {
            logger.error("Label {}/{} is not open on {}.", scope, edge, this.self);
            throw new IllegalArgumentException("Label " + scope + "/" + edge + " is not open on " + this.self + ".");
        }
    }

    protected void assertDifferEnabled() {
        if (!this.isDifferEnabled()) {
            logger.error("Scope graph differ is not enabled.");
            throw new IllegalStateException("Scope graph differ is not enabled.");
        }
    }

    protected void assertIncrementalDeadlockEnabled() {
        if (!this.isIncrementalDeadlockEnabled()) {
            logger.error("Deadlock resolution for incremental analysis is not enabled.");
            throw new IllegalStateException("Deadlock resolution for incremental analysis is not enabled.");
        }
    }

    private class Delay {
        public final ICompletableFuture<Unit> future;
        public final IActorRef<? extends IUnit<S, L, D, ?>> sender;

        Delay(ICompletableFuture<Unit> future, IActorRef<? extends IUnit<S, L, D, ?>> sender) {
            this.future = future;
            this.sender = sender;
        }

        public String toString() {
            return "Delay{future=" + this.future + ",sender=" + this.sender + "}";
        }
    }

    private class RecordingTypeCheckerContext
    extends AbstractQueryTypeCheckerContext<S, L, D, R> {
        private final ImmutableSet.Builder<IRecordedQuery<S, L, D>> queries = ImmutableSet.builder();
        private boolean disposed = false;
        private final IActorRef<? extends IUnit<S, L, D, ?>> origin;

        public RecordingTypeCheckerContext(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = origin;
        }

        @Override
        public String id() {
            return String.valueOf(AbstractUnit.this.self.id()) + "#query";
        }

        @Override
        public IFuture<? extends java.util.Set<IResolutionPath<S, L, D>>> query(S scope, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
            ScopePath path = new ScopePath(scope);
            IFuture result = AbstractUnit.this.doQuery(AbstractUnit.this.self, this.origin, false, path, query, dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
            Query wf = Query.of(AbstractUnit.this.self, path, query, dataWF, dataEquiv, result);
            AbstractUnit.this.waitFor(wf, AbstractUnit.this.self);
            ++AbstractUnit.this.stats.localQueries;
            return AbstractUnit.this.self.schedule(result).thenApply(ans -> {
                if (AbstractUnit.this.isQueryRecordingEnabled()) {
                    if (!AbstractUnit.this.context.scopeId(path.getTarget()).equals(this.origin.id())) {
                        this.recordQuery(ARecordedQuery.of(path, AbstractUnit.this.datumScopes(ans.env()), query.labelWf(), dataWF, ans.env(), false));
                    }
                    ans.transitiveQueries().forEach(q -> this.recordQuery(q.withIncludePatches(false)));
                    this.recordQueries(ans.predicateQueries());
                }
                return CapsuleUtil.toSet(ans.env());
            }).whenComplete((ans, ex) -> AbstractUnit.this.granted(wf, AbstractUnit.this.self));
        }

        @Override
        public IFuture<? extends java.util.Set<IResolutionPath<S, L, D>>> query(S scope, LabelWf<L> labelWF, LabelOrder<L> labelOrder, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, @Nullable DataWf<S, L, D> dataWfInternal, @Nullable DataLeq<S, L, D> dataEquivInternal) {
            return this.query(scope, new NameResolutionQuery(labelWF, labelOrder, AbstractUnit.this.edgeLabels), dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
        }

        @Override
        public IFuture<? extends java.util.Set<IResolutionPath<S, L, D>>> query(S scope, StateMachine<L> stateMachine, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
            return this.query(scope, new StateMachineQuery(stateMachine), dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
        }

        private void assertUndisposed() {
            if (this.disposed) {
                throw new IllegalStateException("Recording query after context disposed.");
            }
        }

        private void recordQuery(IRecordedQuery<S, L, D> query) {
            this.assertUndisposed();
            this.queries.add(query);
        }

        private void recordQueries(Iterable<IRecordedQuery<S, L, D>> queries) {
            this.assertUndisposed();
            this.queries.addAll(queries);
        }

        public java.util.Set<IRecordedQuery<S, L, D>> dispose() {
            this.assertUndisposed();
            this.disposed = true;
            return this.queries.build();
        }
    }

    protected final class StaticNameResolutionContext
    implements IResolutionContext<S, L, D, ExtQuerySet<S, L, D>> {
        private final IActorRef<? extends IUnit<S, L, D, ?>> sender;
        private final DataLeq<S, L, D> dataLeq;
        private final IScopeGraph.Immutable<S, L, D> scopeGraph;
        private final DataWf<S, L, D> dataWf;

        protected StaticNameResolutionContext(IActorRef<? extends IUnit<S, L, D, ?>> sender, IScopeGraph.Immutable<S, L, D> scopeGraph, DataWf<S, L, D> dataWf, DataLeq<S, L, D> dataLeq) {
            this.sender = sender;
            this.scopeGraph = scopeGraph;
            this.dataWf = dataWf;
            this.dataLeq = dataLeq;
        }

        @Override
        public IFuture<Tuple2<Env<S, L, D>, ExtQuerySet<S, L, D>>> externalEnv(ScopePath<S, L> path, IQuery<S, L, D> query, ICancel cancel) {
            Object scope = path.getTarget();
            if (AbstractUnit.this.canAnswer(scope)) {
                logger.debug("local p_env {}", scope);
                return query.resolve(this, path, cancel);
            }
            return AbstractUnit.this.getOwner(scope).thenCompose(owner -> {
                logger.debug("remote p_env from {}", owner);
                CompletableFuture future = new CompletableFuture();
                PQuery pQuery = PQuery.of(this.sender, path, this.dataWf, future);
                AbstractUnit.this.waitFor(pQuery, owner);
                ((IUnit)AbstractUnit.this.self.async(owner))._queryPrevious(path, query, this.dataWf, this.dataLeq).whenComplete((env, ex) -> {
                    logger.debug("got p_env from {}", this.sender);
                    AbstractUnit.this.granted(pQuery, owner);
                    future.complete(Tuple2.of(env.env(), ExtQuerySet.of(env.transitiveQueries(), env.predicateQueries())), (Throwable)ex);
                });
                return future;
            });
        }

        @Override
        public IFuture<Optional<D>> getDatum(S scope) {
            return CompletableFuture.completedFuture(this.scopeGraph.getData(scope).map(AbstractUnit.this::getPreviousDatum));
        }

        @Override
        public IFuture<Iterable<S>> getEdges(S scope, L label) {
            return CompletableFuture.completedFuture(this.scopeGraph.getEdges(scope, label));
        }

        @Override
        public IFuture<Tuple2<Boolean, ExtQuerySet<S, L, D>>> dataWf(D datum, ICancel cancel) throws InterruptedException {
            StaticQueryContext queryContext = new StaticQueryContext(this.sender, this.scopeGraph);
            return this.dataWf.wf(datum, queryContext, cancel).thenApply(wf -> Tuple2.of(wf, ExtQuerySet.builder().addAllPredicateQueries(queryContext.dispose()).build()));
        }

        @Override
        public IFuture<Tuple2<Boolean, ExtQuerySet<S, L, D>>> dataEquiv(D d1, D d2, ICancel cancel) throws InterruptedException {
            StaticQueryContext queryContext = new StaticQueryContext(this.sender, this.scopeGraph);
            return this.dataLeq.leq(d1, d2, queryContext, cancel).thenApply(wf -> Tuple2.of(wf, ExtQuerySet.builder().addAllPredicateQueries(queryContext.dispose()).build()));
        }

        @Override
        public IFuture<Boolean> dataEquivAlwaysTrue(ICancel cancel) {
            StaticQueryContext queryContext = new StaticQueryContext(this.sender, this.scopeGraph);
            return this.dataLeq.alwaysTrue(queryContext, cancel).thenApply(wf -> {
                if (!queryContext.dispose().isEmpty()) {
                    throw new IllegalStateException("alwaysTrue() evaluation should not perform queries.");
                }
                return wf;
            });
        }

        @Override
        public ExtQuerySet<S, L, D> unitMetadata() {
            return ExtQuerySets.empty();
        }

        @Override
        public ExtQuerySet<S, L, D> compose(ExtQuerySet<S, L, D> queries1, ExtQuerySet<S, L, D> queries2) {
            return queries1.addQueries(queries2);
        }
    }

    protected final class StaticQueryContext
    extends AbstractQueryTypeCheckerContext<S, L, D, R> {
        private final IActorRef<? extends IUnit<S, L, D, ?>> sender;
        private final IScopeGraph.Immutable<S, L, D> scopeGraph;
        private final ImmutableSet.Builder<IRecordedQuery<S, L, D>> queries = ImmutableSet.builder();
        private boolean disposed = false;

        public StaticQueryContext(IActorRef<? extends IUnit<S, L, D, ?>> sender, IScopeGraph.Immutable<S, L, D> scopeGraph) {
            this.sender = sender;
            this.scopeGraph = scopeGraph;
        }

        @Override
        public String id() {
            return String.valueOf(AbstractUnit.this.self.id()) + "#prev-query";
        }

        @Override
        public IFuture<? extends java.util.Set<IResolutionPath<S, L, D>>> query(S scope, IQuery<S, L, D> query, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
            StaticNameResolutionContext pContext = new StaticNameResolutionContext(this.sender, this.scopeGraph, dataWF, dataEquiv);
            return query.resolve(pContext, new ScopePath(scope), AbstractUnit.this.context.cancel()).thenApply(ans -> {
                this.recordQuery(ARecordedQuery.of(new ScopePath(scope), AbstractUnit.this.datumScopes((Env)ans._1()), query.labelWf(), dataWF, (Env)ans._1(), true));
                this.recordQueries((Iterable)((ExtQuerySet)ans._2()).transitiveQueries());
                this.recordQueries((Iterable)((ExtQuerySet)ans._2()).predicateQueries());
                return CapsuleUtil.toSet((Iterable)ans._1());
            });
        }

        @Override
        public IFuture<? extends java.util.Set<IResolutionPath<S, L, D>>> query(S scope, LabelWf<L> labelWF, LabelOrder<L> labelOrder, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
            return this.query(scope, new NameResolutionQuery(labelWF, labelOrder, AbstractUnit.this.edgeLabels), dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
        }

        @Override
        public IFuture<? extends java.util.Set<IResolutionPath<S, L, D>>> query(S scope, StateMachine<L> stateMachine, DataWf<S, L, D> dataWF, DataLeq<S, L, D> dataEquiv, DataWf<S, L, D> dataWfInternal, DataLeq<S, L, D> dataEquivInternal) {
            return this.query(scope, new StateMachineQuery(stateMachine), dataWF, dataEquiv, dataWfInternal, dataEquivInternal);
        }

        private void assertUnDisposed() {
            if (this.disposed) {
                throw new IllegalStateException("Cannot record query after disposing static context.");
            }
        }

        private void recordQueries(Iterable<IRecordedQuery<S, L, D>> queries) {
            this.assertUnDisposed();
            this.queries.addAll(queries);
        }

        private void recordQuery(IRecordedQuery<S, L, D> query) {
            this.assertUnDisposed();
            this.queries.add(query);
        }

        public java.util.Set<IRecordedQuery<S, L, D>> dispose() {
            this.assertUnDisposed();
            this.disposed = true;
            return this.queries.build();
        }
    }

    protected static class Stats
    implements IUnitStats,
    Serializable {
        private static final long serialVersionUID = 42L;
        protected int localQueries;
        protected int incomingQueries;
        protected int outgoingQueries;
        protected int forwardedQueries;
        protected int incomingConfirmations;
        protected long runtimeNanos;
        protected int dataWfChecks;
        protected int dataLeqChecks;
        private IActorStats actorStats;

        private Stats(IActorStats actorStats) {
            this.actorStats = actorStats;
        }

        @Override
        public Iterable<String> csvHeaders() {
            return Iterables.concat((Iterable)ImmutableList.of((Object)"runtimeMillis", (Object)"localQueries", (Object)"incomingQueries", (Object)"outgoingQueries", (Object)"forwardedQueries", (Object)"incomingConfirmations", (Object)"dataWfChecks", (Object)"dataLeqChecks"), this.actorStats.csvHeaders());
        }

        @Override
        public Iterable<String> csvRow() {
            return Iterables.concat((Iterable)ImmutableList.of((Object)Long.toString(TimeUnit.MILLISECONDS.convert(this.runtimeNanos, TimeUnit.NANOSECONDS)), (Object)Integer.toString(this.localQueries), (Object)Integer.toString(this.incomingQueries), (Object)Integer.toString(this.outgoingQueries), (Object)Integer.toString(this.forwardedQueries), (Object)Integer.toString(this.incomingConfirmations), (Object)Integer.toString(this.dataWfChecks), (Object)Integer.toString(this.dataLeqChecks)), this.actorStats.csvRow());
        }

        public String toString() {
            return "UnitStats{ownQueries=" + this.localQueries + ",foreignQueries=" + this.incomingQueries + ",forwardedQueries=" + this.outgoingQueries + "," + this.actorStats + "}";
        }
    }
}

