/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.confirm;

import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.impl.confirm.ConfirmResult;
import mb.p_raffrayi.impl.confirm.IConfirmation;
import mb.p_raffrayi.impl.confirm.IConfirmationContext;
import mb.p_raffrayi.impl.envdiff.AddedEdge;
import mb.p_raffrayi.impl.envdiff.RemovedEdge;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.patching.IPatchCollection;
import mb.scopegraph.patching.PatchCollection;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.Futures;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;

abstract class BaseConfirmation<S, L, D>
implements IConfirmation<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(BaseConfirmation.class);
    protected final IConfirmationContext<S, L, D> context;
    private final AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>> DENY = AggregateFuture.SC.shortCircuit(ConfirmResult.deny());
    private final AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>> ACC_NO_PATCHES = AggregateFuture.SC.of(ConfirmResult.confirm());

    protected BaseConfirmation(IConfirmationContext<S, L, D> context) {
        this.context = context;
    }

    @Override
    public IFuture<ConfirmResult<S, L, D>> confirm(IRecordedQuery<S, L, D> query) {
        logger.debug("Confirming {}.", query);
        CompletableFuture result = new CompletableFuture();
        this.confirm(query.source(), query.labelWf(), query.dataWf(), query.empty()).whenComplete((r, ex) -> {
            if (ex != null) {
                result.completeExceptionally((Throwable)ex);
                return;
            }
            r.visit(() -> result.complete((ConfirmResult)r), (addedQueries, removedQueries, resultPatches, globalPatches) -> Futures.reduce(PatchCollection.Immutable.of(), query.datumScopes(), (acc, scope) -> this.context.match(scope).thenApply(newScopeOpt -> {
                Object newScope = newScopeOpt.orElseThrow(() -> new IllegalStateException("Cannot have a missing datum scope match when all edge are confirmed."));
                return acc.put(newScope, scope);
            })).whenComplete((datumPatches, ex2) -> {
                if (ex2 != null) {
                    result.completeExceptionally((Throwable)ex2);
                } else if (query.includePatches()) {
                    result.complete(ConfirmResult.confirm(addedQueries, removedQueries, resultPatches.putAll(datumPatches), globalPatches));
                } else {
                    result.complete(ConfirmResult.confirm(addedQueries, removedQueries, resultPatches, globalPatches.putAll(datumPatches)));
                }
            }));
        });
        return result;
    }

    @Override
    public IFuture<ConfirmResult<S, L, D>> confirm(S scope, LabelWf<L> labelWF, DataWf<S, L, D> dataWF, boolean prevEnvEmpty) {
        return this.context.externalConfirm(scope, labelWF, dataWF, prevEnvEmpty).thenCompose(conf -> conf.map(CompletableFuture::completedFuture).orElseGet(() -> this.localConfirm(scope, labelWF, dataWF, prevEnvEmpty)));
    }

    private IFuture<ConfirmResult<S, L, D>> localConfirm(S scope, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, boolean prevEnvEmpty) {
        CompletableFuture<ConfirmResult> result = new CompletableFuture<ConfirmResult>();
        this.context.envDiff(scope, labelWf).whenComplete((envDiff, ex) -> {
            if (ex != null) {
                logger.error("Environment diff for {}/{} failed.", scope, labelWf, ex);
                result.completeExceptionally((Throwable)ex);
            } else {
                logger.debug("Environment diff for {}/{} completed.", scope, labelWf, ex);
                logger.trace("value: {}.", envDiff);
                ArrayList futures = new ArrayList();
                futures.add(CompletableFuture.completedFuture(AggregateFuture.SC.of(ConfirmResult.confirm(PatchCollection.Immutable.of(envDiff.patches())))));
                LazyFuture patchedDataWf = new LazyFuture(() -> this.patchDataWf(dataWf));
                envDiff.changes().forEach(diff -> futures.add(diff.match(addedEdge -> this.handleAddedEdge((AddedEdge<S, L, D>)addedEdge, patchedDataWf), removedEdge -> this.handleRemovedEdge((RemovedEdge<S, L, D>)removedEdge, dataWf, prevEnvEmpty))));
                AggregateFuture.ofShortCircuitable(this::merge, futures).whenComplete(result::complete);
            }
        });
        return result.whenComplete((res, ex) -> logger.debug("Environment diff completed: {}.", res));
    }

    protected abstract IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> handleAddedEdge(AddedEdge<S, L, D> var1, LazyFuture<Optional<DataWf<S, L, D>>> var2);

    protected abstract IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> handleRemovedEdge(RemovedEdge<S, L, D> var1, DataWf<S, L, D> var2, boolean var3);

    protected AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>> deny() {
        return this.DENY;
    }

    protected AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>> acceptAdded(Set<IRecordedQuery<S, L, D>> transitiveQueries, Set<IRecordedQuery<S, L, D>> predicateQueries) {
        if (transitiveQueries.isEmpty() && predicateQueries.isEmpty()) {
            return this.ACC_NO_PATCHES;
        }
        Set.Transient addedQueries = CapsuleUtil.transientSet();
        addedQueries.__insertAll(transitiveQueries);
        addedQueries.__insertAll(predicateQueries);
        return AggregateFuture.SC.of(ConfirmResult.confirm(addedQueries.freeze(), CapsuleUtil.immutableSet(), PatchCollection.Immutable.of()));
    }

    protected AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>> acceptRemoved(Set<IRecordedQuery<S, L, D>> transitiveQueries, Set<IRecordedQuery<S, L, D>> predicateQueries) {
        if (transitiveQueries.isEmpty() && predicateQueries.isEmpty()) {
            return this.ACC_NO_PATCHES;
        }
        Set.Transient removedQueries = CapsuleUtil.transientSet();
        removedQueries.__insertAll(transitiveQueries);
        removedQueries.__insertAll(predicateQueries);
        return AggregateFuture.SC.of(ConfirmResult.confirm(CapsuleUtil.immutableSet(), removedQueries.freeze(), PatchCollection.Immutable.of()));
    }

    protected IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> denyFuture() {
        return CompletableFuture.completedFuture(this.DENY);
    }

    protected IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> acceptFuture() {
        return CompletableFuture.completedFuture(this.ACC_NO_PATCHES);
    }

    protected IFuture<AggregateFuture.SC<IPatchCollection.Immutable<S>, ConfirmResult<S, L, D>>> accept(IPatchCollection.Immutable<S> patches) {
        return CompletableFuture.completedFuture(AggregateFuture.SC.of(patches));
    }

    protected ConfirmResult<S, L, D> merge(List<ConfirmResult<S, L, D>> confirmResults) {
        return confirmResults.stream().reduce(ConfirmResult.confirm(), ConfirmResult::add);
    }

    private AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>> toSC(ConfirmResult<S, L, D> intermediate) {
        return intermediate.match(() -> AggregateFuture.SC.shortCircuit(intermediate), (addQ, remQ, resP, globP) -> AggregateFuture.SC.of(intermediate));
    }

    protected IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> toSCFuture(IFuture<ConfirmResult<S, L, D>> intermediateFuture) {
        return intermediateFuture.thenApply(this::toSC);
    }

    private IFuture<Optional<DataWf<S, L, D>>> patchDataWf(DataWf<S, L, D> dataWf) {
        Set.Immutable<S> scopes = dataWf.scopes();
        if (scopes.isEmpty()) {
            return CompletableFuture.completedFuture(Optional.of(dataWf));
        }
        ArrayList futures = new ArrayList();
        for (Object scope : scopes) {
            futures.add(this.context.match(scope).thenApply(match -> match.map(m -> AggregateFuture.SC.of(Tuple2.of(scope, m))).orElse(AggregateFuture.SC.shortCircuit(Optional.empty()))));
        }
        return AggregateFuture.ofShortCircuitable(patches -> Optional.of(dataWf.patch(PatchCollection.Immutable.of().putAll((Collection)patches))), futures);
    }

    class LazyFuture<T> {
        private Supplier<IFuture<T>> supplier;
        private IFuture<T> value;

        public LazyFuture(Supplier<IFuture<T>> supplier) {
            this.supplier = supplier;
        }

        public IFuture<T> get() {
            if (this.value == null) {
                this.value = this.supplier.get();
                this.supplier = null;
            }
            return this.value;
        }
    }
}

